/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.ctakes.core.cc.pretty.html.CssWriter;
import org.apache.ctakes.core.cc.pretty.textspan.DefaultTextSpan;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="HTML Writer", description="Writes html files with document text and simple markups (Semantic Group, CUI, Negation).", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public final class HtmlTextWriter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"HtmlTextWriter");
    private static final String FILE_EXTENSION = ".pretty.html";
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Directory for all output files.", defaultValue={""})
    private String _outputDirPath;

    public void setOutputDirectory(String outputDirectoryPath) throws IllegalArgumentException, SecurityException {
        String fullDirPath;
        if (outputDirectoryPath == null || outputDirectoryPath.isEmpty()) {
            LOGGER.debug((Object)("No Output Directory Path specified, using current working directory " + System.getProperty("user.dir")));
            this._outputDirPath = System.getProperty("user.dir");
            return;
        }
        try {
            fullDirPath = FileLocator.getFullPath(outputDirectoryPath);
            File outputDir = new File(fullDirPath);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (!outputDir.isDirectory()) {
                throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
            }
        }
        catch (FileNotFoundException fnfE) {
            throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
        }
        this._outputDirPath = fullDirPath;
        LOGGER.debug((Object)("Output Directory Path set to " + this._outputDirPath));
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        try {
            JCas jcas = aCAS.getJCas();
            this.process(jcas);
        }
        catch (CASException casE) {
            throw new AnalysisEngineProcessException((Throwable)casE);
        }
    }

    public void process(JCas jcas) {
        LOGGER.info((Object)"Starting processing");
        String docId = DocumentIDAnnotationUtil.getDocumentIdForFile(jcas);
        File outputFile = new File(this._outputDirPath + "/" + docId + FILE_EXTENSION);
        String cssPath = this._outputDirPath + "/ctakes.pretty.css";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(HtmlTextWriter.getHeader());
            writer.write(HtmlTextWriter.getCssLink("ctakes.pretty.css"));
            Collection sentences = JCasUtil.select((JCas)jcas, Sentence.class);
            for (Sentence sentence : sentences) {
                HtmlTextWriter.writeSentence(jcas, (AnnotationFS)sentence, writer);
            }
            writer.write(HtmlTextWriter.getFooter());
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write html file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
        CssWriter.writeCssFile(cssPath);
        LOGGER.info((Object)"Finished processing");
    }

    private static void writeParagraph(JCas jcas, AnnotationFS paragraph, BufferedWriter writer) throws IOException {
        String sentenceText = paragraph.getCoveredText().trim();
        if (sentenceText.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(jcas, paragraph);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap = HtmlTextWriter.createAnnotationMap(jcas, paragraph);
        Map<Integer, String> tags = HtmlTextWriter.createTags(annotationMap);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TextSpan, String> entry : baseTokenMap.entrySet()) {
            String beginTag = tags.get(entry.getKey().getBegin());
            if (beginTag != null) {
                sb.append(beginTag);
            }
            sb.append(entry.getValue());
            String endTag = tags.get(entry.getKey().getEnd());
            if (endTag != null) {
                sb.append(endTag);
            }
            sb.append(" ");
        }
        writer.write("<p>\n" + sb.toString() + "\n</p>\n");
    }

    private static void writeSentence(JCas jcas, AnnotationFS sentence, BufferedWriter writer) throws IOException {
        String sentenceText = sentence.getCoveredText().trim();
        if (sentenceText.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(jcas, sentence);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap = HtmlTextWriter.createAnnotationMap(jcas, sentence);
        Map<Integer, String> tags = HtmlTextWriter.createTags(annotationMap);
        StringBuilder sb = new StringBuilder();
        int previousEndIndex = -1;
        for (Map.Entry<TextSpan, String> entry : baseTokenMap.entrySet()) {
            String beginTag;
            boolean annotation = false;
            TextSpan textSpan = entry.getKey();
            if (textSpan.getBegin() != previousEndIndex && (beginTag = tags.get(textSpan.getBegin())) != null) {
                sb.append(beginTag);
                annotation = true;
            }
            sb.append(entry.getValue());
            String endTag = tags.get(textSpan.getEnd());
            if (endTag != null) {
                sb.append(endTag);
            }
            sb.append(" ");
            previousEndIndex = textSpan.getEnd();
        }
        writer.write("<div>\n" + sb.toString() + "\n<br></div>\n");
    }

    private static Map<TextSpan, String> createBaseTokenMap(JCas jcas, AnnotationFS sentence) {
        int sentenceBegin = sentence.getBegin();
        List baseTokens = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)sentence);
        LinkedHashMap<TextSpan, String> baseItemMap = new LinkedHashMap<TextSpan, String>();
        for (BaseToken baseToken : baseTokens) {
            DefaultTextSpan textSpan = new DefaultTextSpan((AnnotationFS)baseToken, sentenceBegin);
            if (textSpan.getWidth() == 0) continue;
            if (baseToken instanceof NewlineToken) {
                baseItemMap.put(textSpan, " ");
                continue;
            }
            baseItemMap.put(textSpan, baseToken.getCoveredText());
        }
        return baseItemMap;
    }

    private static Map<TextSpan, Collection<IdentifiedAnnotation>> createAnnotationMap(JCas jcas, AnnotationFS sentence) {
        HashMap<TextSpan, Collection<IdentifiedAnnotation>> annotationMap = new HashMap<TextSpan, Collection<IdentifiedAnnotation>>();
        int sentenceBegin = sentence.getBegin();
        List identifiedAnnotations = JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, (AnnotationFS)sentence);
        for (IdentifiedAnnotation annotation : identifiedAnnotations) {
            Collection<String> semanticNames;
            DefaultTextSpan textSpan = new DefaultTextSpan((AnnotationFS)annotation, sentenceBegin);
            if (textSpan.getWidth() == 0 || (semanticNames = HtmlTextWriter.getSemanticNames(annotation)).isEmpty() && !(annotation instanceof TimeMention) && !(annotation instanceof EventMention)) continue;
            ArrayList<IdentifiedAnnotation> annotations = (ArrayList<IdentifiedAnnotation>)annotationMap.get(textSpan);
            if (annotations == null) {
                annotations = new ArrayList<IdentifiedAnnotation>();
                annotationMap.put(textSpan, annotations);
            }
            annotations.add(annotation);
        }
        return annotationMap;
    }

    private static Collection<String> getSemanticNames(IdentifiedAnnotation identifiedAnnotation) {
        Collection<UmlsConcept> umlsConcepts = OntologyConceptUtil.getUmlsConcepts(identifiedAnnotation);
        if (umlsConcepts == null || umlsConcepts.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> semanticNames = new HashSet<String>();
        for (UmlsConcept umlsConcept : umlsConcepts) {
            String tui = umlsConcept.getTui();
            String semanticName = SemanticGroup.getSemanticName(tui);
            if (semanticName.equals("Unknown")) {
                semanticName = identifiedAnnotation.getClass().getSimpleName();
            }
            semanticNames.add(semanticName);
        }
        ArrayList<String> semanticList = new ArrayList<String>(semanticNames);
        Collections.sort(semanticList);
        return semanticList;
    }

    private static Map<Integer, String> createTags(Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap) {
        if (annotationMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Integer> indices = new HashSet<Integer>();
        HashMap<Integer, Collection<String>> polarities = new HashMap<Integer, Collection<String>>();
        HashMap<Integer, Collection<String>> beginClasses = new HashMap<Integer, Collection<String>>();
        HashMap<Integer, Collection<String>> endClasses = new HashMap<Integer, Collection<String>>();
        for (Map.Entry<TextSpan, Collection<IdentifiedAnnotation>> entry : annotationMap.entrySet()) {
            Collection<String> tagClasses = HtmlTextWriter.createClasses(entry.getValue());
            if (tagClasses.isEmpty()) continue;
            TextSpan textSpan = entry.getKey();
            indices.add(textSpan.getBegin());
            indices.add(textSpan.getEnd());
            HtmlTextWriter.addAll(beginClasses, textSpan.getBegin(), tagClasses);
            HtmlTextWriter.addAll(endClasses, textSpan.getEnd(), tagClasses);
            Collection<String> polarity = HtmlTextWriter.createPolarity(entry.getValue());
            HtmlTextWriter.addAll(polarities, textSpan.getBegin(), polarity);
            HtmlTextWriter.addAll(polarities, textSpan.getEnd(), polarity);
        }
        if (indices.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList indexList = new ArrayList(indices);
        Collections.sort(indexList);
        HashMap<Integer, String> tagMap = new HashMap<Integer, String>();
        HashSet currentClasses = new HashSet();
        String currentTag = "";
        for (Integer index : indexList) {
            currentTag = currentClasses.isEmpty() ? "" : "</span>";
            Collection enders = (Collection)endClasses.get(index);
            if (enders != null) {
                currentClasses.removeAll(enders);
                if (currentClasses.isEmpty()) {
                    if (currentTag.isEmpty()) continue;
                    tagMap.put(index, currentTag);
                    continue;
                }
                Collection currentPolarity = (Collection)polarities.get(index);
                String polarClasses = String.join((CharSequence)" ", currentPolarity) + " " + String.join((CharSequence)" ", currentClasses);
                String toolTip = currentClasses.isEmpty() ? "" : " data-tooltip=\"" + polarClasses + "\"";
                currentTag = currentTag + "<span class=\"" + polarClasses + "\"" + toolTip + ">";
                tagMap.put(index, currentTag);
                continue;
            }
            Collection beginners = (Collection)beginClasses.get(index);
            if (beginners == null) continue;
            int size = currentClasses.size();
            currentClasses.addAll(beginners);
            if (currentClasses.size() == size) continue;
            Collection currentPolarity = (Collection)polarities.get(index);
            String polarClasses = String.join((CharSequence)" ", currentPolarity) + " " + String.join((CharSequence)" ", currentClasses);
            String toolTip = currentClasses.isEmpty() ? "" : " data-tooltip=\"" + polarClasses + "\"";
            currentTag = currentTag + "<span class=\"" + polarClasses + "\"" + toolTip + ">";
            tagMap.put(index, currentTag);
        }
        if (!currentTag.endsWith("</span>")) {
            tagMap.put((Integer)indexList.get(indexList.size() - 1), currentTag + "</span>");
        }
        return tagMap;
    }

    private static void addAll(Map<Integer, Collection<String>> map, Integer index, Collection<String> values) {
        Collection<String> set = map.get(index);
        if (set == null) {
            set = new HashSet<String>();
            map.put(index, set);
        }
        set.addAll(values);
    }

    private static Collection<String> createPolarity(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(HtmlTextWriter::createPolarity).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Collection<String> createPolarity(IdentifiedAnnotation annotation) {
        ArrayList<String> tags = new ArrayList<String>();
        if (annotation.getPolarity() < 0) {
            if (annotation.getUncertainty() > 0) {
                tags.add("uncertainnegated");
            } else {
                tags.add("negated");
            }
        } else if (annotation.getUncertainty() > 0) {
            tags.add("uncertain");
        } else {
            tags.add("affirmed");
        }
        return tags;
    }

    private static Collection<String> createClasses(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().map(HtmlTextWriter::getSemanticNames).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    private static String addBackgroundLink(String idName, String color) {
        return "onmouseover=\"linkBg(" + idName + "," + color + ")\" onmouseout=\"linkBg(" + idName + ",white)\"";
    }

    private static String getCssLink(String filePath) {
        return "<link rel=\"stylesheet\" href=\"" + filePath + "\" type=\"text/css\" media=\"screen\">";
    }

    private static String getHeader() {
        return "<!DOCTYPE html>\n<html>\n<body>\n";
    }

    private static String getFooter() {
        return "</body>\n</html>\n";
    }

    private static String startJavascript() {
        return "<script type=\"text/javascript\">";
    }

    private static String endJavascript() {
        return "</script>";
    }

    private static String getLinkBackgrounds() {
        return "  function linkBg(id,color) {\n    document.getElementById(id).style.backgroundColor = color;\n  }\n";
    }
}

