/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.ctakes.core.cc.AbstractOutputFileWriter;
import org.apache.ctakes.core.cc.XMISerializer;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.xml.sax.SAXException;

@PipeBitInfo(name="XMI Writer (Dir Tree)", description="Writes XMI files with full representation of input text and all extracted information.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX})
public final class FileTreeXmiWriter
extends AbstractOutputFileWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"FileTreeXmiWriter");

    @Override
    public void writeFile(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        File xmiFile = new File(outputDir, fileName + ".xmi");
        try {
            FileTreeXmiWriter.writeXmi(jCas.getCas(), xmiFile);
        }
        catch (IOException | SAXException multE) {
            throw new IOException(multE);
        }
    }

    private static void writeXmi(CAS cas, File file) throws IOException, SAXException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
            XmiCasSerializer casSerializer = new XmiCasSerializer(cas.getTypeSystem());
            XMISerializer xmiSerializer = new XMISerializer(outputStream);
            casSerializer.serialize(cas, xmiSerializer.getContentHandler());
        }
    }

    public static AnalysisEngine createEngine(String outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(FileTreeXmiWriter.class, (Object[])new Object[]{"OutputDirectory", outputDirectory});
    }
}

