/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.ctakes.ytex.kernel.BaseSparseDataFormatter;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.converters.ArffSaver;

public class WekaFormatterFactory
implements SparseDataFormatterFactory {
    private KernelUtil kernelUtil;

    @Override
    public SparseDataFormatter getFormatter() {
        return new WekaFormatter(this.getKernelUtil());
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public static class WekaFormatter
    extends BaseSparseDataFormatter {
        public static final String CLASS = "ytex_class";
        public static final String INSTANCE_ID = "instance_id";
        InstanceData instanceLabel = null;
        FastVector wekaAttributes = null;

        public WekaFormatter(KernelUtil kernelUtil) {
            super(kernelUtil);
        }

        private void addNominalAttribute(String attributeName, SortedSet<String> attributeValues, boolean addDummy0) {
            FastVector wordValues = new FastVector(attributeValues.size() + (addDummy0 ? 1 : 0));
            if (addDummy0) {
                String dummyName = !attributeValues.contains("null") ? "null" : (!attributeValues.contains("0") ? "0" : Long.toString(System.currentTimeMillis()));
                wordValues.addElement((Object)dummyName);
            }
            for (String wordValue : attributeValues) {
                wordValues.addElement((Object)wordValue);
            }
            Attribute attribute = new Attribute(attributeName, wordValues);
            this.wekaAttributes.addElement((Object)attribute);
        }

        private void addWordsToInstances(Instances instances, SparseData bagOfWordsData, SortedMap<Long, String> instanceClasses) throws IOException {
            for (Map.Entry<Long, String> entry : instanceClasses.entrySet()) {
                Attribute wordAttr;
                double[] zeroValues = new double[instances.numAttributes()];
                Arrays.fill(zeroValues, 0.0);
                SparseInstance wekaInstance = new SparseInstance(1.0, zeroValues);
                wekaInstance.setDataset(instances);
                Attribute instanceId = instances.attribute(INSTANCE_ID);
                wekaInstance.setValue(instanceId.index(), entry.getKey().doubleValue());
                Attribute classAttr = instances.attribute(CLASS);
                wekaInstance.setValue(classAttr.index(), (double)classAttr.indexOfValue(entry.getValue()));
                if (bagOfWordsData.getInstanceNumericWords().get(entry.getKey()) != null) {
                    for (Map.Entry<String, Double> entry2 : bagOfWordsData.getInstanceNumericWords().get(entry.getKey()).entrySet()) {
                        wordAttr = instances.attribute(entry2.getKey());
                        wekaInstance.setValue(wordAttr.index(), entry2.getValue().doubleValue());
                    }
                }
                if (bagOfWordsData.getInstanceNominalWords().get(entry.getKey()) != null) {
                    for (Map.Entry<String, Object> entry3 : bagOfWordsData.getInstanceNominalWords().get(entry.getKey()).entrySet()) {
                        wordAttr = instances.attribute(entry3.getKey());
                        int valueIndex = wordAttr.indexOfValue((String)entry3.getValue());
                        if (valueIndex == -1) {
                            throw new IOException("oops! " + entry3);
                        }
                        wekaInstance.setValue(wordAttr.index(), (double)valueIndex);
                    }
                }
                instances.add((Instance)wekaInstance);
            }
        }

        @Override
        public void clearFold() {
        }

        @Override
        public void clearLabel() {
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> sortedMap, boolean train, String label, Integer run, Integer fold) throws IOException {
            Instances inst = this.initializeInstances(sparseData, sortedMap, train, label, run, fold);
            String filename = FileUtil.getDataFilePrefix(this.outdir, label, run, fold, train) + ".arff";
            ArffSaver saver = new ArffSaver();
            saver.setDestination(new File(filename));
            saver.setFile(new File(filename));
            saver.setInstances(inst);
            saver.writeBatch();
        }

        protected void initializeAttributes(SparseData bagOfWordsData, SortedSet<String> classNames) {
            this.wekaAttributes = new FastVector(bagOfWordsData.getNumericWords().size() + bagOfWordsData.getNominalWordValueMap().size() + 2);
            this.wekaAttributes.addElement((Object)new Attribute(INSTANCE_ID));
            for (String string : bagOfWordsData.getNumericWords()) {
                Attribute attribute = new Attribute(string);
                this.wekaAttributes.addElement((Object)attribute);
            }
            for (Map.Entry entry : bagOfWordsData.getNominalWordValueMap().entrySet()) {
                this.addNominalAttribute((String)entry.getKey(), (SortedSet)entry.getValue(), true);
            }
            this.addNominalAttribute(CLASS, classNames, false);
        }

        @Override
        public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
            super.initializeExport(instanceLabel, properties, sparseData);
            this.instanceLabel = instanceLabel;
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            if ("fold".equals(this.exportProperties.getProperty("scope"))) {
                this.initializeAttributes(sparseData, (SortedSet)this.instanceLabel.getLabelToClassMap().get(label));
            }
        }

        public Instances initializeInstances(SparseData sparseData, SortedMap<Long, String> instanceClasses, boolean train, String label, Integer run, Integer fold) throws IOException {
            String arffRelation = this.exportProperties.getProperty("arffRelation", "org.apache.ctakes.ytex");
            String relation = arffRelation + "_" + FileUtil.getDataFilePrefix(null, label, run, fold, train);
            Instances instances = new Instances(relation, this.wekaAttributes, 0);
            instances.setClassIndex(instances.numAttributes() - 1);
            this.addWordsToInstances(instances, sparseData, instanceClasses);
            return instances;
        }

        @Override
        public void initializeLabel(String label, SortedMap<Integer, SortedMap<Integer, SortedMap<Boolean, SortedMap<Long, String>>>> labelInstances, Properties properties, SparseData sparseData) throws IOException {
            if ("label".equals(properties.getProperty("scope")) || properties.getProperty("scope") == null || properties.getProperty("scope").length() == 0) {
                this.initializeAttributes(sparseData, (SortedSet)this.instanceLabel.getLabelToClassMap().get(label));
            }
        }
    }
}

