/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.model;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ctakes.ytex.kernel.metric.LCSPath;
import org.apache.ctakes.ytex.kernel.model.ObjPair;

public class ConcRel
implements Serializable {
    private static final Logger log = Logger.getLogger(ConcRel.class.getName());
    private static final long serialVersionUID = 1L;
    private Set<ConcRel> children;
    private int[] childrenArray;
    private short depth;
    private double intrinsicInfoContent;
    private String nodeCUI;
    private int nodeIndex;
    private Set<ConcRel> parents;
    private int[] parentsArray;

    public static List<String> crListToString(List<ConcRel> crList) {
        if (crList != null) {
            ArrayList<String> path = new ArrayList<String>(crList.size());
            for (ConcRel cr : crList) {
                path.add(cr.getConceptID());
            }
            return path;
        }
        return null;
    }

    public static ObjPair<ConcRel, Integer> getLeastCommonConcept(ConcRel c1, ConcRel c2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getLeastCommonConcept(" + c1 + "," + c2 + ")");
        }
        ObjPair<Object, Integer> res = new ObjPair<Object, Integer>(null, Integer.MAX_VALUE);
        HashMap<ConcRel, Integer> cand1 = new HashMap<ConcRel, Integer>();
        HashMap<ConcRel, Integer> cand2 = new HashMap<ConcRel, Integer>();
        HashSet<ConcRel> parC1 = new HashSet<ConcRel>();
        parC1.add(c1);
        HashSet<ConcRel> parC2 = new HashSet<ConcRel>();
        parC2.add(c2);
        HashSet<ConcRel> tmp = new HashSet<ConcRel>();
        int dist = 0;
        while (!parC1.isEmpty() || !parC2.isEmpty()) {
            tmp.clear();
            for (ConcRel cr : parC1) {
                if (cand2.containsKey(cr)) {
                    res.v1 = cr;
                    res.v2 = dist + (Integer)cand2.get(cr);
                    return res;
                }
                cand1.put(cr, dist);
                tmp.addAll(cr.parents);
            }
            tmp.removeAll(cand1.keySet());
            HashSet<ConcRel> tmp2 = parC1;
            parC1 = tmp;
            tmp = tmp2;
            tmp.clear();
            for (ConcRel cr : parC2) {
                if (cand1.containsKey(cr)) {
                    res.v1 = cr;
                    res.v2 = dist + (Integer)cand1.get(cr);
                    return res;
                }
                cand2.put(cr, dist);
                tmp.addAll(cr.parents);
            }
            tmp.removeAll(cand2.keySet());
            tmp2 = parC2;
            parC2 = tmp;
            tmp = tmp2;
            ++dist;
        }
        return res;
    }

    public static int getLeastCommonConcept(ConcRel c1, ConcRel c2, Set<ConcRel> lcses, Map<ConcRel, LCSPath> paths) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getLeastCommonConcept(" + c1 + "," + c2 + ")");
        }
        HashMap<ConcRel, Integer> cand1 = new HashMap<ConcRel, Integer>();
        HashMap<ConcRel, Integer> cand2 = new HashMap<ConcRel, Integer>();
        HashMap<ConcRel, List<ConcRel>> paths1 = paths != null ? new HashMap<ConcRel, List<ConcRel>>() : null;
        HashMap<ConcRel, List<ConcRel>> paths2 = paths != null ? new HashMap<ConcRel, List<ConcRel>>() : null;
        HashSet<ConcRel> parC1 = new HashSet<ConcRel>();
        parC1.add(c1);
        HashSet<ConcRel> parC2 = new HashSet<ConcRel>();
        parC2.add(c2);
        HashSet<ConcRel> tmp = new HashSet<ConcRel>();
        HashSet<ConcRel> candidateLCSes = new HashSet<ConcRel>();
        int maxIter = -1;
        int dist = 0;
        int minDist = 0x7FFFFFFE;
        while (!(parC1.isEmpty() && parC2.isEmpty() || maxIter >= 0 && maxIter == 0)) {
            ConcRel.updateParent(cand1, parC1, tmp, dist, paths1);
            ConcRel.updateParent(cand2, parC2, tmp, dist, paths2);
            tmp.clear();
            tmp.addAll(cand1.keySet());
            tmp.retainAll(cand2.keySet());
            tmp.removeAll(candidateLCSes);
            if (!tmp.isEmpty()) {
                candidateLCSes.addAll(tmp);
                ConcRel.removeParents(tmp, parC1);
                ConcRel.removeParents(tmp, parC2);
                for (ConcRel lcs : tmp) {
                    int distTmp = (Integer)cand1.get(lcs) + (Integer)cand2.get(lcs) + 1;
                    if (distTmp <= minDist) {
                        if (distTmp < minDist) {
                            lcses.clear();
                        }
                        minDist = distTmp;
                        lcses.add(lcs);
                    }
                    int minLcsToConceptLen = Math.min((Integer)cand1.get(lcs), (Integer)cand2.get(lcs));
                    if (maxIter >= 0 && maxIter <= minLcsToConceptLen) continue;
                    maxIter = minLcsToConceptLen;
                }
            }
            --maxIter;
            ++dist;
        }
        if (lcses.isEmpty()) {
            return -1;
        }
        if (paths != null) {
            for (ConcRel lcs : lcses) {
                LCSPath lcsPath = new LCSPath();
                lcsPath.setLcs(lcs.getConceptID());
                lcsPath.setConcept1Path(ConcRel.crListToString((List)paths1.get(lcs)));
                lcsPath.setConcept2Path(ConcRel.crListToString((List)paths2.get(lcs)));
                paths.put(lcs, lcsPath);
            }
        }
        return minDist;
    }

    private static void removeParents(HashSet<ConcRel> lcses, HashSet<ConcRel> parents) {
        for (ConcRel lcs : lcses) {
            parents.removeAll(lcs.parents);
        }
    }

    private static void updateParent(Map<ConcRel, Integer> cand1, HashSet<ConcRel> parC1, HashSet<ConcRel> tmp, int dist, Map<ConcRel, List<ConcRel>> paths) {
        tmp.clear();
        for (ConcRel cr : parC1) {
            if (cand1.containsKey(cr)) continue;
            cand1.put(cr, dist);
            tmp.addAll(cr.parents);
            if (paths == null) continue;
            List<ConcRel> pathCR = paths.get(cr);
            for (ConcRel parent : cr.parents) {
                if (paths.containsKey(parent)) continue;
                ArrayList<ConcRel> path = new ArrayList<ConcRel>(pathCR != null ? pathCR.size() + 1 : 1);
                if (pathCR != null) {
                    path.addAll(pathCR);
                }
                path.add(cr);
                paths.put(parent, path);
            }
        }
        tmp.removeAll(cand1.keySet());
        parC1.clear();
        parC1.addAll(tmp);
    }

    public ConcRel(String cui, int nodeIndex) {
        this.nodeCUI = cui;
        this.parents = new HashSet<ConcRel>();
        this.children = new HashSet<ConcRel>();
        this.parentsArray = null;
        this.childrenArray = null;
        this.nodeIndex = nodeIndex;
    }

    public void constructRel(List<ConcRel> db) {
        ImmutableSet.Builder pBuilder = new ImmutableSet.Builder();
        for (int c : this.parentsArray) {
            pBuilder.add((Object)db.get(c));
        }
        this.parents = pBuilder.build();
        this.parentsArray = null;
        ImmutableSet.Builder cBuilder = new ImmutableSet.Builder();
        for (int c : this.childrenArray) {
            cBuilder.add((Object)db.get(c));
        }
        this.children = cBuilder.build();
        this.childrenArray = null;
    }

    public int depthMax() {
        int d = 0;
        for (ConcRel child : this.children) {
            int dm = child.depthMax() + 1;
            if (dm <= d) continue;
            d = dm;
        }
        return d;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcRel other = (ConcRel)obj;
        return this.nodeIndex == other.nodeIndex;
    }

    public Set<ConcRel> getChildren() {
        return this.children;
    }

    public int[] getChildrenArray() {
        return this.childrenArray;
    }

    public String getConceptID() {
        return this.nodeCUI;
    }

    public short getDepth() {
        return this.depth;
    }

    public double getIntrinsicInfoContent() {
        return this.intrinsicInfoContent;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public Set<ConcRel> getParents() {
        return this.parents;
    }

    public int[] getParentsArray() {
        return this.parentsArray;
    }

    public void getPath(List<ConcRel> lpath, List<List<ConcRel>> allPaths, int depth, int depthMax) {
        if (depth >= depthMax) {
            return;
        }
        if (lpath == null) {
            lpath = new ArrayList<ConcRel>();
        }
        lpath.add(this);
        if (this.isRoot()) {
            allPaths.add(new ArrayList<ConcRel>(lpath));
        } else {
            for (ConcRel p : this.parents) {
                p.getPath(lpath, allPaths, depth + 1, depthMax);
            }
        }
        lpath.remove(lpath.size() - 1);
    }

    public boolean hasAncestor(String cui) {
        if (this.nodeCUI.equals(cui)) {
            return true;
        }
        for (ConcRel c : this.parents) {
            if (!c.hasAncestor(cui)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.nodeIndex;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parents.isEmpty();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nodeCUI = (String)in.readObject();
        this.nodeIndex = in.readInt();
        this.intrinsicInfoContent = in.readDouble();
        this.depth = in.readShort();
        this.parentsArray = (int[])in.readObject();
        this.childrenArray = (int[])in.readObject();
        this.parents = new HashSet<ConcRel>(this.parentsArray.length);
        this.children = new HashSet<ConcRel>(this.childrenArray.length);
    }

    public void setChildrenArray(int[] childrenArray) {
        this.childrenArray = childrenArray;
    }

    public void setConceptID(String nodeCUI) {
        this.nodeCUI = nodeCUI;
    }

    public void setDepth(short depth) {
        this.depth = depth;
    }

    public void setIntrinsicInfoContent(double intrinsicInfoContent) {
        this.intrinsicInfoContent = intrinsicInfoContent;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public void setParentsArray(int[] parentsArray) {
        this.parentsArray = parentsArray;
    }

    public String toString() {
        return "ConcRel [nodeCUI=" + this.nodeCUI + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeObject(this.nodeCUI);
        out.writeInt(this.nodeIndex);
        out.writeDouble(this.intrinsicInfoContent);
        out.writeShort(this.depth);
        if (this.parentsArray == null) {
            this.parentsArray = new int[this.parents.size()];
            i = 0;
            for (ConcRel c : this.parents) {
                this.parentsArray[i++] = c.getNodeIndex();
            }
        }
        if (this.childrenArray == null) {
            this.childrenArray = new int[this.children.size()];
            i = 0;
            for (ConcRel c : this.children) {
                this.childrenArray[i++] = c.getNodeIndex();
            }
        }
        out.writeObject(this.parentsArray);
        out.writeObject(this.childrenArray);
        this.parentsArray = null;
        this.childrenArray = null;
    }
}

