/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.dao.DBUtil;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.metric.ConceptInfo;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluationIRStat;
import org.apache.ctakes.ytex.kernel.model.ClassifierInstanceEvaluation;
import org.apache.ctakes.ytex.kernel.model.CrossValidationFold;
import org.apache.ctakes.ytex.kernel.model.FeatureEvaluation;
import org.apache.ctakes.ytex.kernel.model.FeatureParentChild;
import org.apache.ctakes.ytex.kernel.model.FeatureRank;
import org.hibernate.Query;
import org.hibernate.SessionFactory;

public class ClassifierEvaluationDaoImpl
implements ClassifierEvaluationDao {
    private static final Log log = LogFactory.getLog(ClassifierEvaluationDaoImpl.class);
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void deleteCrossValidationFoldByName(String corpusName, String splitName) {
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getCrossValidationFoldByName");
        q.setString("corpusName", corpusName);
        q.setString("splitName", this.nullToEmptyString(splitName));
        List folds = q.list();
        for (CrossValidationFold fold : folds) {
            this.getSessionFactory().getCurrentSession().delete((Object)fold);
        }
    }

    @Override
    public CrossValidationFold getCrossValidationFold(String corpusName, String splitName, String label, int run, int fold) {
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getCrossValidationFold");
        q.setString("corpusName", corpusName);
        q.setString("splitName", this.nullToEmptyString(splitName));
        q.setString("label", this.nullToEmptyString(label));
        q.setInteger("run", run);
        q.setInteger("fold", fold);
        return (CrossValidationFold)q.uniqueResult();
    }

    @Override
    public void saveClassifierEvaluation(ClassifierEvaluation eval, Map<Integer, String> irClassMap, boolean saveInstanceEval) {
        this.saveClassifierEvaluation(eval, irClassMap, saveInstanceEval, true, null);
    }

    @Override
    public void saveClassifierEvaluation(ClassifierEvaluation eval, Map<Integer, String> irClassMap, boolean saveInstanceEval, boolean saveIRStats, Integer excludeTargetClassId) {
        this.getSessionFactory().getCurrentSession().save((Object)eval);
        if (saveIRStats) {
            this.saveIRStats(eval, irClassMap, excludeTargetClassId);
        }
        if (saveInstanceEval) {
            for (ClassifierInstanceEvaluation instanceEval : eval.getClassifierInstanceEvaluations().values()) {
                this.getSessionFactory().getCurrentSession().save((Object)instanceEval);
            }
        }
    }

    void saveIRStats(ClassifierEvaluation eval, Map<Integer, String> irClassMap, Integer excludeTargetClassId) {
        Set<Integer> classIds = this.getClassIds(eval, excludeTargetClassId);
        for (Integer irClassId : classIds) {
            String irClass = null;
            if (irClassMap != null) {
                irClass = irClassMap.get(irClassId);
            }
            if (irClass == null) {
                irClass = Integer.toString(irClassId);
            }
            ClassifierEvaluationIRStat irStat = this.calcIRStats(irClass, irClassId, eval, excludeTargetClassId);
            this.getSessionFactory().getCurrentSession().save((Object)irStat);
        }
    }

    private ClassifierEvaluationIRStat calcIRStats(String irClass, Integer irClassId, ClassifierEvaluation eval, Integer excludeTargetClassId) {
        int tp = 0;
        int tn = 0;
        int fp = 0;
        int fn = 0;
        for (ClassifierInstanceEvaluation instanceEval : eval.getClassifierInstanceEvaluations().values()) {
            if (instanceEval.getTargetClassId() == null || excludeTargetClassId != null && instanceEval.getTargetClassId().intValue() == excludeTargetClassId.intValue()) continue;
            if (instanceEval.getTargetClassId() == irClassId) {
                if (instanceEval.getPredictedClassId() == instanceEval.getTargetClassId().intValue()) {
                    ++tp;
                    continue;
                }
                ++fn;
                continue;
            }
            if (instanceEval.getPredictedClassId() == irClassId.intValue()) {
                ++fp;
                continue;
            }
            ++tn;
        }
        return new ClassifierEvaluationIRStat(eval, null, irClass, irClassId, tp, tn, fp, fn);
    }

    private Set<Integer> getClassIds(ClassifierEvaluation eval, Integer excludeTargetClassId) {
        HashSet<Integer> classIds = new HashSet<Integer>();
        for (ClassifierInstanceEvaluation instanceEval : eval.getClassifierInstanceEvaluations().values()) {
            classIds.add(instanceEval.getPredictedClassId());
            if (instanceEval.getTargetClassId() == null || excludeTargetClassId != null && instanceEval.getTargetClassId().intValue() == excludeTargetClassId.intValue()) continue;
            classIds.add(instanceEval.getTargetClassId());
        }
        return classIds;
    }

    @Override
    public void saveFold(CrossValidationFold fold) {
        this.getSessionFactory().getCurrentSession().save((Object)fold);
    }

    @Override
    public void saveFeatureEvaluation(FeatureEvaluation featureEvaluation, List<FeatureRank> features) {
        this.getSessionFactory().getCurrentSession().save((Object)featureEvaluation);
        for (FeatureRank r : features) {
            this.getSessionFactory().getCurrentSession().save((Object)r);
        }
    }

    @Override
    public void deleteFeatureEvaluationByNameAndType(String corpusName, String featureSetName, String type) {
        Query q = this.getSessionFactory().getCurrentSession().getNamedQuery("getFeatureEvaluationByNameAndType");
        q.setString("corpusName", corpusName);
        q.setString("featureSetName", this.nullToEmptyString(featureSetName));
        q.setString("type", type);
        for (FeatureEvaluation fe : q.list()) {
            this.getSessionFactory().getCurrentSession().delete((Object)fe);
        }
    }

    @Override
    public List<FeatureRank> getTopFeatures(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2, Integer parentConceptTopThreshold) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getTopFeatures");
        q.setMaxResults(parentConceptTopThreshold.intValue());
        return q.list();
    }

    @Override
    public Double getMaxFeatureEvaluation(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getMaxFeatureEvaluation");
        return (Double)q.uniqueResult();
    }

    private Query prepareUniqueFeatureEvalQuery(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, Double param1, String param2, String queryName) {
        Query q = this.sessionFactory.getCurrentSession().getNamedQuery(queryName);
        q.setString("corpusName", this.nullToEmptyString(corpusName));
        q.setString("featureSetName", this.nullToEmptyString(featureSetName));
        q.setString("label", this.nullToEmptyString(label));
        q.setString("evaluationType", evaluationType);
        q.setDouble("param1", param1 == null ? 0.0 : param1);
        q.setString("param2", this.nullToEmptyString(param2));
        q.setInteger("crossValidationFoldId", foldId == null ? 0 : foldId);
        return q;
    }

    private String nullToEmptyString(String param1) {
        return DBUtil.nullToEmptyString(param1);
    }

    @Override
    public List<FeatureRank> getThresholdFeatures(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2, double evaluationThreshold) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getThresholdFeatures");
        q.setDouble("evaluation", evaluationThreshold);
        return q.list();
    }

    @Override
    public void deleteFeatureEvaluation(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, Double param1, String param2) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getFeatureEvaluationByNK");
        FeatureEvaluation fe = (FeatureEvaluation)q.uniqueResult();
        if (fe != null) {
            q = this.sessionFactory.getCurrentSession().getNamedQuery("deleteFeatureRank");
            q.setInteger("featureEvaluationId", fe.getFeatureEvaluationId());
            q.executeUpdate();
            q = this.sessionFactory.getCurrentSession().getNamedQuery("deleteFeatureEval");
            q.setInteger("featureEvaluationId", fe.getFeatureEvaluationId());
            q.executeUpdate();
        }
    }

    @Override
    public Map<String, FeatureRank> getFeatureRanks(Set<String> featureNames, String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getFeatureRankEvaluations");
        q.setParameterList("featureNames", featureNames);
        List featureRanks = q.list();
        HashMap<String, FeatureRank> frMap = new HashMap<String, FeatureRank>(featureRanks.size());
        for (FeatureRank fr : featureRanks) {
            frMap.put(fr.getFeatureName(), fr);
        }
        return frMap;
    }

    @Override
    public Map<String, Double> getFeatureRankEvaluations(Set<String> featureNames, String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getFeatureRankEvaluations");
        q.setParameterList("featureNames", featureNames);
        List featureRanks = q.list();
        HashMap<String, Double> evalMap = new HashMap<String, Double>(featureRanks.size());
        for (FeatureRank fr : featureRanks) {
            evalMap.put(fr.getFeatureName(), fr.getEvaluation());
        }
        return evalMap;
    }

    @Override
    public Map<String, Double> getFeatureRankEvaluations(String corpusName, String featureSetName, String label, String evaluationType, Integer foldId, double param1, String param2) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, featureSetName, label, evaluationType, foldId, param1, param2, "getTopFeatures");
        List listFeatureRank = q.list();
        HashMap<String, Double> mapFeatureEval = new HashMap<String, Double>(listFeatureRank.size());
        for (FeatureRank r : listFeatureRank) {
            mapFeatureEval.put(r.getFeatureName(), r.getEvaluation());
        }
        return mapFeatureEval;
    }

    @Override
    public List<Object[]> getCorpusCuiTuis(String corpusName, String conceptGraphName, String conceptSetName) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, conceptSetName, null, "infocontent", 0, 0.0, conceptGraphName, "getCorpusCuiTuis");
        return q.list();
    }

    @Override
    public Map<String, Double> getInfoContent(String corpusName, String conceptGraphName, String conceptSet) {
        return this.getFeatureRankEvaluations(corpusName, conceptSet, null, "infocontent", 0, 0.0, conceptGraphName);
    }

    @Override
    public List<ConceptInfo> getIntrinsicInfoContent(String conceptGraphName) {
        Query q = this.prepareUniqueFeatureEvalQuery(null, null, null, "intrinsic-infocontent", null, null, conceptGraphName, "getIntrinsicInfoContent");
        return q.list();
    }

    @Override
    public Integer getMaxDepth(String conceptGraphName) {
        Query q = this.prepareUniqueFeatureEvalQuery(null, null, null, "intrinsic-infocontent", null, null, conceptGraphName, "getMaxFeatureRank");
        return (Integer)q.uniqueResult();
    }

    @Override
    public void saveFeatureParentChild(FeatureParentChild parchd) {
        this.sessionFactory.getCurrentSession().save((Object)parchd);
    }

    @Override
    public List<FeatureRank> getImputedFeaturesByPropagatedCutoff(String corpusName, String conceptSetName, String label, String evaluationType, String conceptGraphName, String propEvaluationType, int propRankCutoff) {
        Query q = this.prepareUniqueFeatureEvalQuery(corpusName, conceptSetName, label, evaluationType, 0, 0.0, conceptGraphName, "getImputedFeaturesByPropagatedCutoff");
        q.setInteger("propRankCutoff", propRankCutoff);
        q.setString("propEvaluationType", propEvaluationType);
        return q.list();
    }
}

