/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.ytex.kernel.CytoscapeHelper;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.ConceptDao;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.model.ConceptGraph;
import org.apache.ctakes.ytex.umls.dao.UMLSDao;

public class CytoscapeHelperImpl
implements CytoscapeHelper {
    protected ClassifierEvaluationDao classifierEvaluationDao;
    protected ConceptDao conceptDao;
    protected UMLSDao umlsDao;

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"prop");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"property file with queries and other parameters. todo desc");
        options.addOption(OptionBuilder.create((String)"prop"));
        OptionGroup og = new OptionGroup();
        OptionBuilder.withArgName((String)"network");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"create network using specified concept graph and corpus. creates prefix.sif with edges and prefix.node.txt with node data in working directory.");
        og.addOption(OptionBuilder.create((String)"network"));
        OptionBuilder.withArgName((String)"concept id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"get all descendants of specified concept, creates concept_id.tree file in working directory");
        og.addOption(OptionBuilder.create((String)"subtree"));
        og.setRequired(true);
        options.addOptionGroup(og);
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            CytoscapeHelper cytHelper = (CytoscapeHelper)KernelContextHolder.getApplicationContext().getBean(CytoscapeHelper.class);
            Properties props = new Properties(System.getProperties());
            props.putAll((Map<?, ?>)FileUtil.loadProperties(line.getOptionValue("prop"), true));
            if (!cytHelper.validateProps(props)) {
                CytoscapeHelperImpl.printHelp(options);
            } else if (line.hasOption("network")) {
                cytHelper.exportNetwork(line.getOptionValue("network"), props);
            } else if (line.hasOption("subtree")) {
                cytHelper.exportSubtree(line.getOptionValue("subtree"), props);
            } else {
                CytoscapeHelperImpl.printHelp(options);
            }
        }
        catch (ParseException pe) {
            CytoscapeHelperImpl.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + CytoscapeHelperImpl.class.getName() + " generate graphs and node lists for cytoscape", options);
    }

    private void addConcepts(ConceptGraph cg, String conceptId, Set<String> nodesToInclude, Set<String> leaves) {
        ConcRel cr = cg.getConceptMap().get(conceptId);
        if (!nodesToInclude.contains(cr.getConceptID())) {
            nodesToInclude.add(cr.getConceptID());
            for (ConcRel crp : cr.getParents()) {
                this.addConcepts(cg, crp.getConceptID(), nodesToInclude, leaves);
                leaves.remove(crp.getConceptID());
            }
        }
    }

    private void addSubtree(Set<String> nodes, ConcRel cr) {
        if (!nodes.contains(cr.getConceptID())) {
            nodes.add(cr.getConceptID());
            for (ConcRel crc : cr.getChildren()) {
                this.addSubtree(nodes, crc);
            }
        }
    }

    private void exportEdges(ConceptGraph cg, BufferedWriter network) throws IOException {
        for (ConcRel cr : cg.getConceptList()) {
            for (ConcRel crc : cr.getChildren()) {
                network.write(crc.getConceptID());
                network.write("\tisa\t");
                network.write(cr.getConceptID());
                network.write("\n");
            }
        }
    }

    @Override
    public void exportNetwork(ConceptGraph cg, String corpusName, String conceptGraphName, String conceptSetName, int leafChildrenDepth, BufferedWriter networkData, BufferedWriter nodeData) throws IOException {
        this.exportEdges(cg, networkData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportNetwork(String filePrefix, Properties props) throws IOException {
        BufferedWriter networkData = null;
        BufferedWriter nodeData = null;
        try {
            networkData = new BufferedWriter(new FileWriter(filePrefix + ".sif"));
            nodeData = new BufferedWriter(new FileWriter(filePrefix + ".node.txt"));
            String conceptGraphName = props.getProperty("org.apache.ctakes.ytex.conceptGraphName");
            this.exportNetwork(this.conceptDao.getConceptGraph(conceptGraphName), props.getProperty("org.apache.ctakes.ytex.corpusName"), conceptGraphName, props.getProperty("org.apache.ctakes.ytex.conceptSetName"), 0, networkData, nodeData);
        }
        finally {
            if (networkData != null) {
                networkData.close();
            }
            if (nodeData != null) {
                nodeData.close();
            }
        }
    }

    private void exportNodes(List<String> subList, BufferedWriter nodeData, Map<String, Double> ic) throws IOException {
        Map<String, String> nodeNames = this.umlsDao.getNames(subList);
        for (String conceptID : subList) {
            nodeData.write(conceptID);
            nodeData.write("\t");
            nodeData.write(Double.toString(ic.containsKey(conceptID) ? ic.get(conceptID) : 0.0));
            nodeData.write("\t\"");
            nodeData.write(nodeNames.containsKey(conceptID) ? nodeNames.get(conceptID).toString() : "");
            nodeData.write("\"\n");
        }
    }

    private void exportNodes(Set<String> exportedNodes, BufferedWriter nodeData, Map<String, Double> ic) throws IOException {
        ArrayList<String> exportedNodeList = new ArrayList<String>(exportedNodes);
        int size = exportedNodes.size();
        int chunks = size / 1000;
        if (size % 1000 != 0) {
            ++chunks;
        }
        for (int chunk = 0; chunk < chunks; ++chunk) {
            int start = chunk * 1000;
            int end = Math.min(size - 1, (chunk + 1) * 1000 - 1);
            List<String> subList = exportedNodeList.subList(start, end);
            this.exportNodes(subList, nodeData, ic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportSubtree(String conceptID, Properties props) throws IOException {
        HashSet<String> nodes = new HashSet<String>();
        ConceptGraph cg = this.conceptDao.getConceptGraph(props.getProperty("org.apache.ctakes.ytex.conceptGraphName"));
        ConcRel cr = cg.getConceptMap().get(conceptID);
        if (cr != null) {
            this.addSubtree(nodes, cr);
        }
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new FileWriter(conceptID + ".idlist"));
            for (String node : nodes) {
                w.write(node);
                w.write("\n");
            }
        }
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public ConceptDao getConceptDao() {
        return this.conceptDao;
    }

    public UMLSDao getUmlsDao() {
        return this.umlsDao;
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setConceptDao(ConceptDao conceptDao) {
        this.conceptDao = conceptDao;
    }

    public void setUmlsDao(UMLSDao umlsDao) {
        this.umlsDao = umlsDao;
    }

    @Override
    public boolean validateProps(Properties props) {
        String conceptGraphName = props.getProperty("org.apache.ctakes.ytex.conceptGraphName");
        return conceptGraphName != null;
    }
}

