/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.base;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.ctakes.jdl.schema.xdl.JdbcType;

public class JdlConnection {
    private String driver;
    private String url;
    private String user;
    private String password;
    private Connection connection;

    public JdlConnection(JdbcType jdbc) {
        this.driver = StringUtils.defaultIfEmpty((String)jdbc.getDriver(), (String)this.driver);
        this.url = StringUtils.defaultIfEmpty((String)jdbc.getUrl(), (String)this.url);
        this.user = StringUtils.defaultIfEmpty((String)jdbc.getUsername(), (String)this.user);
        this.password = StringUtils.defaultIfEmpty((String)jdbc.getPassword(), (String)this.password);
    }

    public final boolean isConnected() throws SQLException {
        return this.connection != null && !this.connection.isClosed();
    }

    private void openConnection() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        DriverManager.registerDriver((Driver)Class.forName(this.driver).newInstance());
        this.connection = DriverManager.getConnection(this.url, this.user, this.password);
    }

    public final Connection getOpenConnection() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        if (!this.isConnected()) {
            this.openConnection();
        }
        return this.connection;
    }

    public final void commitConnection() throws SQLException {
        if (this.isConnected() && !this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    public final void rollbackConnection() throws SQLException {
        if (this.isConnected() && !this.connection.getAutoCommit()) {
            this.connection.rollback();
        }
    }

    public final void closeConnection() throws SQLException {
        if (this.isConnected()) {
            this.connection.close();
        }
    }

    public final boolean isAutoCommit() throws SQLException {
        return this.isConnected() ? this.connection.getAutoCommit() : false;
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isConnected()) {
            this.connection.setAutoCommit(autoCommit);
        }
    }
}

