/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;

public class FSClassRegistry {
    private TypeSystemImpl ts;
    private FSGenerator<?>[] generators;
    private static final FSGenerator<FeatureStructureImplC> defaultGenerator = new DefaultFSGenerator();
    private final Map<ClassLoader, FSGenerator<?>[]> generatorsByClassLoader = Collections.synchronizedMap(new HashMap(4));

    FSClassRegistry(TypeSystemImpl ts) {
        this.ts = ts;
    }

    synchronized void initGeneratorArray() {
        this.generators = new FSGenerator[this.ts.getTypeArraySize()];
        for (int i = this.ts.getSmallestType(); i < this.generators.length; ++i) {
            this.generators[i] = defaultGenerator;
        }
    }

    synchronized void addClassForType(Type type, FSGenerator<?> fsFactory) {
        Iterator<Type> it = this.ts.getTypeIterator();
        while (it.hasNext()) {
            TypeImpl sub = (TypeImpl)it.next();
            if (!this.ts.subsumes(type, sub)) continue;
            this.generators[sub.getCode()] = fsFactory;
        }
    }

    public void addGeneratorForType(TypeImpl type, FSGenerator<?> fsFactory) {
    }

    void flush() {
    }

    public void saveGeneratorsForClassLoader(ClassLoader cl, FSGenerator<?>[] newGenerators) {
        this.generatorsByClassLoader.put(cl, newGenerators);
    }

    public boolean swapInGeneratorsForClassLoader(ClassLoader cl, CASImpl casImpl) {
        FSGenerator<?>[] cachedGenerators = this.generatorsByClassLoader.get(cl);
        if (cachedGenerators != null) {
            casImpl.setLocalFsGenerators(cachedGenerators);
            return true;
        }
        return false;
    }

    public synchronized FSGenerator<?>[] getBaseGenerators() {
        return this.generators;
    }

    public synchronized void setBaseGenerators(FSGenerator<?>[] generators) {
        this.generators = generators;
    }

    public synchronized FSGenerator<?>[] getNewFSGeneratorSet() {
        return (FSGenerator[])this.generators.clone();
    }

    private static class DefaultFSGenerator
    implements FSGenerator<FeatureStructureImplC> {
        private DefaultFSGenerator() {
        }

        @Override
        public FeatureStructureImplC createFS(int addr, CASImpl cas) {
            return new FeatureStructureImplC(cas, addr);
        }
    }
}

