/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.ArgumentValidationExceptionFactory;
import com.lexicalscope.jewel.cli.ValidationErrorBuilder;
import com.lexicalscope.jewel.cli.ValidationFailure;
import com.lexicalscope.jewel.cli.ValidationFailureMissingValue;
import com.lexicalscope.jewel.cli.ValidationFailureWrongNumberOfValues;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import java.util.ArrayList;
import java.util.List;

public class ValidationErrorBuilderImpl
implements ValidationErrorBuilder {
    private final List<ValidationFailure> validationExceptions = new ArrayList<ValidationFailure>();

    @Override
    public void missingValue(OptionSpecification optionSpecification) {
        this.validationExceptions.add(new ValidationFailureMissingValue(optionSpecification));
    }

    @Override
    public void wrongNumberOfValues(OptionSpecification optionSpecification, List<String> excessValues) {
        this.validationExceptions.add(new ValidationFailureWrongNumberOfValues(optionSpecification, excessValues));
    }

    @Override
    public void unexpectedOption(String name) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createUnexpectedOptionError(name));
    }

    @Override
    public void unexpectedValue(OptionSpecification optionSpecification, List<String> values) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createUnexpectedValueError(optionSpecification, values));
    }

    @Override
    public void unexpectedTrailingValue(List<String> unparsedArguments) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createUnexpectedTrailingValues(unparsedArguments));
    }

    @Override
    public void missingOption(OptionSpecification optionSpecification) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createMissingOptionError(optionSpecification));
    }

    @Override
    public void invalidValueForType(OptionSpecification optionSpecification, String message) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createInvalidValueForType(optionSpecification, message));
    }

    @Override
    public void unableToConstructType(OptionSpecification optionSpecification, String message) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createUnableToConstructType(optionSpecification, message));
    }

    @Override
    public void patternMismatch(OptionSpecification optionSpecification, String value) {
        this.validationExceptions.add(ArgumentValidationExceptionFactory.createPatternMismatch(optionSpecification, value));
    }

    @Override
    public void validate() throws ArgumentValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ArgumentValidationException(this.validationExceptions);
        }
    }
}

