/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.HelpMessageOptionSummaryBuilderImpl;
import com.lexicalscope.jewel.cli.OptionHelpMessage;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;

class ParsedOptionSummary {
    private final ParsedOptionSpecification m_option;

    public ParsedOptionSummary(ParsedOptionSpecification option) {
        this.m_option = option;
    }

    private boolean hasCustomPattern() {
        return !this.m_option.getPattern().equals(".*");
    }

    private boolean nullOrBlank(String description) {
        return description == null || description.trim().equals("");
    }

    public void describeOptionTo(OptionHelpMessage helpMessage) {
        if (this.m_option.isOptional()) {
            helpMessage.startOptionalOption();
        } else {
            helpMessage.startMandatoryOption();
        }
        helpMessage.longName(this.m_option.getLongName());
        helpMessage.shortName(this.m_option.getShortNames());
        if (this.m_option.hasValue()) {
            if (this.m_option.isMultiValued()) {
                if (this.hasCustomPattern()) {
                    helpMessage.multiValuedWithCustomPattern(this.m_option.getPattern());
                } else {
                    helpMessage.multiValuedWithCustomPattern();
                }
            } else if (this.hasCustomPattern()) {
                helpMessage.singleValuedWithCustomPattern(this.m_option.getPattern());
            } else {
                helpMessage.singleValued();
            }
        } else {
            helpMessage.noValued();
        }
        if (this.m_option.isOptional()) {
            if (this.hasDescription()) {
                helpMessage.endOptionalOption(this.m_option.getDescription());
            } else {
                helpMessage.endOptionalOption();
            }
        } else if (this.hasDescription()) {
            helpMessage.endMandatoryOption(this.m_option.getDescription());
        } else {
            helpMessage.endMandatoryOption();
        }
    }

    private boolean hasDescription() {
        return !this.nullOrBlank(this.m_option.getDescription());
    }

    public String toString() {
        HelpMessageOptionSummaryBuilderImpl helpMessageOptionSummaryBuilderImpl = new HelpMessageOptionSummaryBuilderImpl();
        this.describeOptionTo(helpMessageOptionSummaryBuilderImpl);
        return ((Object)helpMessageOptionSummaryBuilderImpl).toString();
    }
}

