/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.viterbi;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.SequenceDataWriter;
import org.cleartk.ml.jar.DirectoryDataWriter;
import org.cleartk.ml.viterbi.OutcomeFeatureExtractor;
import org.cleartk.ml.viterbi.ViterbiClassifier;
import org.cleartk.ml.viterbi.ViterbiClassifierBuilder;
import org.cleartk.util.ReflectionUtil;

public class ViterbiDataWriter<OUTCOME_TYPE>
extends DirectoryDataWriter<ViterbiClassifierBuilder<OUTCOME_TYPE>, ViterbiClassifier<OUTCOME_TYPE>>
implements SequenceDataWriter<OUTCOME_TYPE>,
ReflectionUtil.TypeArgumentDelegator {
    protected File outputDirectory;
    protected OutcomeFeatureExtractor[] outcomeFeatureExtractors;
    protected DataWriter<OUTCOME_TYPE> delegatedDataWriter = null;

    public ViterbiDataWriter(File outputDirectory, OutcomeFeatureExtractor[] outcomeFeatureExtractors) {
        super(outputDirectory);
        this.outcomeFeatureExtractors = outcomeFeatureExtractors;
        ((ViterbiClassifierBuilder)this.classifierBuilder).setOutcomeFeatureExtractors(this.outcomeFeatureExtractors);
    }

    @Override
    protected ViterbiClassifierBuilder<OUTCOME_TYPE> newClassifierBuilder() {
        return new ViterbiClassifierBuilder();
    }

    public void setDelegatedDataWriter(DataWriter<OUTCOME_TYPE> delegatedDataWriter) {
        this.delegatedDataWriter = delegatedDataWriter;
    }

    @Override
    public void write(List<Instance<OUTCOME_TYPE>> instances) throws CleartkProcessingException {
        if (this.delegatedDataWriter == null) {
            throw new IllegalStateException("delegatedDataWriter must be set before calling writeSequence");
        }
        ArrayList<Object> outcomes = new ArrayList<Object>();
        for (Instance<OUTCOME_TYPE> instance : instances) {
            List<Feature> instanceFeatures = instance.getFeatures();
            for (OutcomeFeatureExtractor outcomeFeatureExtractor : this.outcomeFeatureExtractors) {
                instanceFeatures.addAll(outcomeFeatureExtractor.extractFeatures(outcomes));
            }
            outcomes.add(instance.getOutcome());
            this.delegatedDataWriter.write(instance);
        }
    }

    @Override
    public void finish() throws CleartkProcessingException {
        if (this.delegatedDataWriter == null) {
            throw new IllegalStateException("delegatedDataWriter must be set before calling finish");
        }
        this.delegatedDataWriter.finish();
        super.finish();
    }

    public Map<String, Type> getTypeArguments(Class<?> genericType) {
        if (this.delegatedDataWriter == null) {
            throw new IllegalStateException("delegatedDataWriter must be set before calling getTypeArguments");
        }
        if (genericType.equals(SequenceDataWriter.class)) {
            genericType = DataWriter.class;
        }
        return ReflectionUtil.getTypeArguments(genericType, this.delegatedDataWriter);
    }
}

