/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.feature.function;

import java.util.Collections;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.util.HyphenUtil;

public class ContainsHyphenFeatureFunction
implements FeatureFunction {
    public static final String DEFAULT_NAME = "ContainsHyphen";
    public static final String CONTAINS_HYPHEN = "CONTAINS_HYPHEN";

    public List<Feature> apply(Feature feature) {
        String featureName = Feature.createName(DEFAULT_NAME, feature.getName());
        Object featureValue = feature.getValue();
        if (featureValue == null) {
            return Collections.emptyList();
        }
        if (featureValue instanceof String) {
            String value = featureValue.toString();
            if (value == null || value.length() == 0) {
                return Collections.emptyList();
            }
            if (HyphenUtil.containsHyphen(value)) {
                return Collections.singletonList(new Feature(featureName, CONTAINS_HYPHEN));
            }
        }
        return Collections.emptyList();
    }
}

