/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;
import org.icefaces.application.ProductInfo;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.event.MainEventListener;
import org.icefaces.impl.renderkit.RendererWrapper;
import org.icefaces.impl.util.FormEndRendering;
import org.icefaces.render.ExternalScript;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMRenderKit
extends RenderKitWrapper {
    private static Logger log = Logger.getLogger(DOMRenderKit.class.getName());
    private MainEventListener mainEventListener = new MainEventListener();
    private RenderKit delegate;
    private boolean deltaSubmit;
    private List mandatoryResourceConfig = null;
    private Renderer modifiedMessageRenderer = null;
    private static final String MESSAGE = "javax.faces.Message";
    private static final String MESSAGE_CLASS = "org.icefaces.impl.renderkit.html_basic.MessageRenderer";
    private Renderer modifiedMessagesRenderer = null;
    private static final String MESSAGES = "javax.faces.Messages";
    private static final String MESSAGES_CLASS = "org.icefaces.impl.renderkit.html_basic.MessagesRenderer";
    private ArrayList<ExternalScript> customScriptRenderers = new ArrayList();
    private ArrayList<String> mandatoryResourceComponents = new ArrayList();

    public DOMRenderKit(RenderKit delegate) {
        this.delegate = delegate;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.deltaSubmit = EnvUtils.isDeltaSubmit(facesContext);
        String mandatoryResourceConfigString = EnvUtils.getMandatoryResourceConfig(facesContext);
        if (null != mandatoryResourceConfigString) {
            this.mandatoryResourceConfig = Arrays.asList(mandatoryResourceConfigString.split("\\s+"));
        }
        try {
            this.modifiedMessageRenderer = (Renderer)Class.forName(MESSAGE_CLASS).newInstance();
        }
        catch (Throwable t) {
            log.fine("No override for Message Renderer " + t.toString());
        }
        try {
            this.modifiedMessagesRenderer = (Renderer)Class.forName(MESSAGES_CLASS).newInstance();
        }
        catch (Throwable t) {
            log.fine("No override for Messages Renderer " + t.toString());
        }
    }

    public RenderKit getWrapped() {
        return this.delegate;
    }

    public void addRenderer(String family, String rendererType, Renderer r) {
        String compClassName;
        MandatoryResourceComponent mrc;
        Class<?> clazz = r.getClass();
        ExternalScript ec = clazz.getAnnotation(ExternalScript.class);
        if (ec != null && ec.scriptURL() != null) {
            this.customScriptRenderers.add(ec);
        }
        if ((mrc = clazz.getAnnotation(MandatoryResourceComponent.class)) != null && (compClassName = mrc.value()) != null && compClassName.length() > 0 && !this.mandatoryResourceComponents.contains(compClassName) && (null == this.mandatoryResourceConfig || this.mandatoryResourceConfig.contains(compClassName))) {
            this.mandatoryResourceComponents.add(compClassName);
        }
        Renderer renderer = "javax.faces.Form".equals(family) ? new FormBoost(r) : r;
        super.addRenderer(family, rendererType, renderer);
    }

    public Renderer getRenderer(String family, String type) {
        Renderer renderer = this.delegate.getRenderer(family, type);
        String className = renderer.getClass().getName();
        if (className.equals("com.sun.faces.renderkit.html_basic.MessageRenderer")) {
            return this.modifiedMessageRenderer;
        }
        if (className.equals("com.sun.faces.renderkit.html_basic.MessagesRenderer")) {
            return this.modifiedMessagesRenderer;
        }
        return renderer;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String encoding) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter parentWriter = this.delegate.createResponseWriter(writer, contentTypeList, encoding);
        if (facesContext.getPartialViewContext().isPartialRequest()) {
            return parentWriter;
        }
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return parentWriter;
        }
        return new DOMResponseWriter((Writer)parentWriter, parentWriter.getCharacterEncoding(), parentWriter.getContentType());
    }

    public List<ExternalScript> getCustomRenderScripts() {
        return this.customScriptRenderers;
    }

    public List<String> getMandatoryResourceComponents() {
        return this.mandatoryResourceComponents;
    }

    static {
        if (log.isLoggable(Level.INFO)) {
            log.info(new ProductInfo().toString());
        }
    }

    private class FormBoost
    extends RendererWrapper {
        private FormBoost(Renderer renderer) {
            super(renderer);
        }

        public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
            FormEndRendering.renderIntoForm(context, component);
            if (DOMRenderKit.this.deltaSubmit && EnvUtils.isICEfacesView(context)) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("script", component);
                writer.writeAttribute("type", (Object)"text/javascript", null);
                writer.writeText((Object)"ice.calculateInitialParameters('", null);
                writer.writeText((Object)component.getClientId(context), null);
                writer.writeText((Object)"');", null);
                writer.endElement("script");
            }
            super.encodeEnd(context, component);
        }
    }
}

