/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.application;

import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.icefaces.application.PortableRenderer;
import org.icefaces.impl.application.LazyPushManager;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class PushRenderer {
    private static Logger log = Logger.getLogger(PushRenderer.class.getName());
    public static final String ALL_SESSIONS = "PushRenderer.ALL_SESSIONS";
    private static final String MissingICEpushMessage = "ICEpush library missing. Push notification disabled.";

    public static synchronized void addCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            String viewID = PushRenderer.lookupViewState(context);
            LazyPushManager.enablePushForView(context, viewID);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.addGroupMember(groupName, viewID);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized void removeCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            String viewID = PushRenderer.lookupViewState(context);
            LazyPushManager.disablePushForView(context, viewID);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.removeGroupMember(groupName, viewID);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized void addCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.enablePushForSessionViews(context);
            SessionViewManager.startAddingNewViewsToGroup(context, groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized void removeCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.disablePushForSessionViews(context);
            SessionViewManager.stopAddingNewViewsToGroup(context, groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static void render(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.push(groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static PortableRenderer getPortableRenderer() {
        return PushRenderer.getPortableRenderer(FacesContext.getCurrentInstance());
    }

    public static PortableRenderer getPortableRenderer(FacesContext context) {
        if (EnvUtils.isICEpushPresent()) {
            final PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            return new PortableRenderer(){

                public void render(String group) {
                    pushContext.push(group);
                }
            };
        }
        log.warning(MissingICEpushMessage);
        return new PortableRenderer(){

            public void render(String group) {
                log.warning(PushRenderer.MissingICEpushMessage);
            }
        };
    }

    private static String lookupViewState(FacesContext context) {
        return BridgeSetup.getViewID(context.getExternalContext());
    }

    private static void missingFacesContext(FacesContext context) {
        if (context == null) {
            throw new RuntimeException("FacesContext is not present for thread " + Thread.currentThread());
        }
    }
}

