/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AssertionDepUtils {
    public static SimpleTree getTokenTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation annotation) {
        return AssertionDepUtils.getTokenTreeString(jCas, nodes, annotation, 1);
    }

    public static SimpleTree getTokenTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation annotation, int upNodes) {
        HashMap<ConllDependencyNode, SimpleTree> node2tree = new HashMap<ConllDependencyNode, SimpleTree>();
        for (ConllDependencyNode node : nodes) {
            if (node.getHead() == null) continue;
            SimpleTree curTree = null;
            SimpleTree headTree = null;
            if (!node2tree.containsKey(node)) {
                curTree = new SimpleTree(node.getCoveredText().toLowerCase());
                node2tree.put(node, curTree);
            } else {
                curTree = (SimpleTree)node2tree.get(node);
            }
            if (curTree.parent != null || node.getHead().getHead() == null) continue;
            if (node2tree.containsKey(node.getHead())) {
                headTree = (SimpleTree)node2tree.get(node.getHead());
            } else {
                headTree = new SimpleTree(node.getHead().getCoveredText().toLowerCase());
                node2tree.put(node.getHead(), headTree);
            }
            curTree.parent = headTree;
            headTree.addChild(curTree);
        }
        List coveredNodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)annotation);
        if (coveredNodes == null || coveredNodes.size() == 0) {
            return null;
        }
        ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((List)coveredNodes);
        SimpleTree localTree = (SimpleTree)node2tree.get(headNode.getHead().getHead() == null ? headNode : headNode.getHead());
        String realCat = ((SimpleTree)node2tree.get((Object)headNode)).cat;
        ((SimpleTree)node2tree.get((Object)headNode)).cat = "CONCEPT";
        if (annotation instanceof IdentifiedAnnotation) {
            ((SimpleTree)node2tree.get((Object)headNode)).cat = ((SimpleTree)node2tree.get((Object)headNode)).cat + ((IdentifiedAnnotation)annotation).getTypeID();
        }
        SimpleTree returnTree = null;
        ConllDependencyNode returnNode = headNode;
        for (int steps = 0; steps < upNodes && returnNode.getHead().getHead() != null; ++steps) {
            returnNode = returnNode.getHead();
        }
        returnTree = (SimpleTree)node2tree.get(returnNode);
        return returnTree;
    }

    public static String getTokenRelTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation annotation, String label) {
        return AssertionDepUtils.getTokenRelTreeString(jCas, nodes, new Annotation[]{annotation}, new String[]{label});
    }

    public static String getTokenRelTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation[] annotations, String[] labels) {
        HashMap<ConllDependencyNode, SimpleTree> node2tree = new HashMap<ConllDependencyNode, SimpleTree>();
        for (ConllDependencyNode node : nodes) {
            if (node.getHead() == null) continue;
            SimpleTree curTree = null;
            SimpleTree headTree = null;
            if (!node2tree.containsKey(node)) {
                curTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getDeprel(), node.getCoveredText()));
                node2tree.put(node, curTree);
            } else {
                curTree = (SimpleTree)node2tree.get(node);
            }
            if (curTree.parent != null || node.getHead().getHead() == null) continue;
            if (node2tree.containsKey(node.getHead())) {
                headTree = (SimpleTree)node2tree.get(node.getHead());
            } else {
                headTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getHead().getDeprel(), node.getHead().getCoveredText()));
                node2tree.put(node.getHead(), headTree);
            }
            curTree.parent = (SimpleTree)headTree.children.get(0);
            ((SimpleTree)headTree.children.get(0)).addChild(curTree);
        }
        ConllDependencyNode highestHead = null;
        for (int i = 0; i < annotations.length; ++i) {
            List coveredNodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)annotations[i]);
            if (coveredNodes == null || coveredNodes.size() == 0) continue;
            ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((List)coveredNodes);
            if (highestHead == null || AssertionDepUtils.distanceFromRoot(headNode) < AssertionDepUtils.distanceFromRoot(highestHead)) {
                highestHead = headNode;
            }
            SimpleTree insertionPoint = (SimpleTree)node2tree.get(headNode);
            SimpleTree insertingTree = new SimpleTree(insertionPoint.cat);
            insertionPoint.cat = labels[i];
            insertingTree.children = insertionPoint.children;
            ((SimpleTree)insertingTree.children.get((int)0)).parent = insertingTree;
            insertionPoint.children = new ArrayList();
            insertionPoint.addChild(insertingTree);
            insertingTree.parent = insertionPoint;
        }
        SimpleTree localTree = (SimpleTree)node2tree.get(highestHead.getHead().getHead() == null ? highestHead : highestHead.getHead());
        String treeStr = localTree.toString();
        treeStr = treeStr.replaceAll("\\(([^\\(]+) \\)", "($1 nil)").toLowerCase();
        return treeStr;
    }

    private static int distanceFromRoot(ConllDependencyNode node) {
        int dist = 0;
        while (node.getHead() != null) {
            ++dist;
            node = node.getHead();
        }
        return dist;
    }
}

