/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cr;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.assertion.cr.NegExAnnotation;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionComponents;
import org.apache.ctakes.core.cc.XmiWriterCasConsumerCtakes;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="NegEx Corpus Reader", description="Reads lines from file named by AssertionConst.NEGEX_CORPUS", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class NegExCorpusReader
extends CollectionReader_ImplBase {
    static Logger LOGGER = Logger.getLogger(NegExCorpusReader.class);
    private boolean skipReadingValuesJustReadText = false;
    private static TypeSystemDescription typeSystemDescription = AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION;
    private static List<NegExAnnotation> list;
    private static int i;

    public NegExCorpusReader() {
        this(false);
    }

    public NegExCorpusReader(boolean skipReadingValuesJustReadText) {
        this.skipReadingValuesJustReadText = skipReadingValuesJustReadText;
        NegExCorpusReader.readAndParseAllLines(null);
    }

    private static List<NegExAnnotation> readAndParseAllLines(String filename) {
        String[] lines;
        int n;
        if (filename == null || filename.length() == 0) {
            RuntimeException e = new RuntimeException("Going to continue with default values");
            LOGGER.warn((Object)e.getLocalizedMessage());
            filename = "/projects/data/assertion/data/gold_standard/negex/Annotations-1-120-random.txt";
        }
        if ((n = (lines = NegExCorpusReader.readNonWhiteSpaceLines(filename)).length) == 0) {
            LOGGER.error((Object)(n + " lines found in " + filename));
        }
        LOGGER.info((Object)("Processing " + n + " lines from the negex file, treating each line as a document."));
        list = new ArrayList<NegExAnnotation>();
        for (String data : lines) {
            LOGGER.info((Object)("Processing line '" + data + "'."));
            try {
                list.add(new NegExAnnotation(data));
            }
            catch (RuntimeException e) {
                LOGGER.warn((Object)"Skipping this one because of RuntimeException");
            }
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            String filename = args[0];
        } else {
            try {
                LOGGER.warn((Object)String.format("usage: java %s path/to/negex/file ", NegExCorpusReader.class.getName()));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            RuntimeException e = new RuntimeException("Going to continue with default values");
            LOGGER.warn((Object)e.getLocalizedMessage());
            String filename = "/projects/data/assertion/data/gold_standard/negex/Annotations-1-120-random.txt";
            LOGGER.warn((Object)("filename: " + filename));
        }
        CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(NegExCorpusReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[0]);
        AnalysisEngineDescription xWriter = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (Object[])new Object[]{"OutputDirectory", "/projects/data/assertion/data/preprocessed_data/negex/all"});
        AggregateBuilder aggregate = new AggregateBuilder();
        aggregate.add(xWriter, new String[0]);
        SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readNonWhiteSpaceLines(String filename) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (Exception e1) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return lines.toArray(new String[0]);
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jCas;
        try {
            jCas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        NegExAnnotation a = list.get(i);
        ++i;
        jCas.setDocumentText(a.sentenceText);
        DocumentID documentID = new DocumentID(jCas);
        documentID.setDocumentID("doc" + a.lineNumber);
        documentID.addToIndexes();
        EventMention ia = new EventMention(jCas);
        ia.setBegin(Integer.parseInt(a.begin));
        ia.setEnd(Integer.parseInt(a.end));
        if (!this.skipReadingValuesJustReadText) {
            ia.setPolarity(Integer.parseInt(a.polarity));
        }
        ia.addToIndexes();
    }

    public boolean hasNext() throws IOException, CollectionException {
        try {
            return i < list.size();
        }
        catch (Exception e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        ProgressImpl p = new ProgressImpl(i, list.size(), "entities");
        return new Progress[]{p};
    }

    static {
        i = 0;
    }
}

