/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.utils;

import java.lang.reflect.Array;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected ArrayUtils() {
    }

    public static Class commonClass(Class c1, Class c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c1 == Object.class || c1.isAssignableFrom(c2)) {
            return c1;
        }
        if (c2.isAssignableFrom(c1)) {
            return c2;
        }
        if (c1.isPrimitive() || c2.isPrimitive()) {
            throw new IllegalArgumentException("incompatible types " + c1 + " and " + c2);
        }
        return Object.class;
    }

    public static Object concat(Object arr1, Object arr2) {
        int len2;
        int len1;
        int n = len1 = arr1 == null ? -1 : Array.getLength(arr1);
        if (len1 <= 0) {
            return arr2;
        }
        int n2 = len2 = arr2 == null ? -1 : Array.getLength(arr2);
        if (len2 <= 0) {
            return arr1;
        }
        Class commonComponentType = ArrayUtils.commonClass(arr1.getClass().getComponentType(), arr2.getClass().getComponentType());
        Object newArray = Array.newInstance(commonComponentType, len1 + len2);
        System.arraycopy(arr1, 0, newArray, 0, len1);
        System.arraycopy(arr2, 0, newArray, len1, len2);
        return newArray;
    }

    public static Object concat(Object[] arrs) {
        int totalLen = 0;
        Class commonComponentType = null;
        int len = arrs.length;
        for (int i = 0; i < len; ++i) {
            int arrayLen;
            if (arrs[i] == null || (arrayLen = Array.getLength(arrs[i])) == 0) continue;
            totalLen += arrayLen;
            Class componentType = arrs[i].getClass().getComponentType();
            commonComponentType = commonComponentType == null ? componentType : ArrayUtils.commonClass(commonComponentType, componentType);
        }
        if (commonComponentType == null) {
            return null;
        }
        return ArrayUtils.concat(Array.newInstance(commonComponentType, totalLen), totalLen, arrs);
    }

    public static Object concat(Object toArray, int totalLen, Object[] arrs) {
        if (totalLen == 0) {
            return toArray;
        }
        if (totalLen > Array.getLength(toArray)) {
            toArray = Array.newInstance(toArray.getClass().getComponentType(), totalLen);
        }
        int len = arrs.length;
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            int arrayLen;
            Object arr = arrs[i];
            if (arr == null || (arrayLen = Array.getLength(arr)) <= 0) continue;
            System.arraycopy(arr, 0, toArray, offset, arrayLen);
            offset += arrayLen;
        }
        return toArray;
    }

    public static Object concat(Object arr1, Object arr2, Object arr3) {
        return ArrayUtils.concat(new Object[]{arr1, arr2, arr3});
    }

    public static Object concat(Object arr1, Object arr2, Object arr3, Object arr4) {
        return ArrayUtils.concat(new Object[]{arr1, arr2, arr3, arr4});
    }

    public static Object concat(Object arr1, Object arr2, Object arr3, Object arr4, Object arr5) {
        return ArrayUtils.concat(new Object[]{arr1, arr2, arr3, arr4, arr5});
    }

    public static Object concatSameType(Object toArray, Object[] arrs) {
        int totalLen = 0;
        int len = arrs.length;
        for (int i = 0; i < len; ++i) {
            if (arrs[i] == null) continue;
            totalLen += Array.getLength(arrs[i]);
        }
        return ArrayUtils.concat(toArray, totalLen, arrs);
    }

    public static boolean contains(Object[] array, Object value) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if ((o != null || value != null) && (o == null || !o.equals(value))) continue;
            return true;
        }
        return false;
    }
}

