/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.Vector;

public class CombineRecords {
    public static final int BY_NONE = 0;
    public static final int BY_TERM = 1;
    public static final int BY_CATEGORY = 2;
    public static final int BY_INFLECTION = 3;
    public static final int BY_EUI = 4;

    public static Vector<LexItem> Combine(Vector<LexItem> ins, int rule) {
        Vector<LexItem> out = new Vector();
        if (rule == 0) {
            out = new Vector<LexItem>(ins);
            return out;
        }
        Vector<LexItem> records = new Vector<LexItem>(ins);
        LexItemComparator lc = new LexItemComparator();
        lc.SetRule(rule);
        Collections.sort(records, lc);
        for (int i = 0; i < records.size(); ++i) {
            if (i == 0) {
                LexItem cur = records.elementAt(i);
                out.addElement(cur);
                continue;
            }
            CombineRecords.CombineRecords(out, records, i, rule);
        }
        return out;
    }

    private static void CombineRecords(Vector<LexItem> out, Vector<LexItem> ins, int index, int rule) {
        LexItem o2;
        if (index == 0 || index >= ins.size()) {
            return;
        }
        LexItem o1 = out.lastElement();
        if (!CombineRecords.IsCombinable(o1, o2 = ins.elementAt(index), rule)) {
            out.addElement(o2);
        } else {
            LexItem o3 = CombineRecords.CombineByRule(o1, o2, rule);
            out.setElementAt(o3, out.size() - 1);
        }
    }

    private static LexItem CombineByRule(LexItem o1, LexItem o2, int rule) {
        LexItem out = new LexItem(o1, true);
        long cat = 0L;
        long infl = 0L;
        switch (rule) {
            case 1: {
                cat = Bit.Add(o1.GetTargetCategory().GetValue(), o2.GetTargetCategory().GetValue());
                infl = Bit.Add(o1.GetTargetInflection().GetValue(), o2.GetTargetInflection().GetValue());
                break;
            }
            case 4: {
                cat = Bit.Add(o1.GetTargetCategory().GetValue(), o2.GetTargetCategory().GetValue());
                infl = Bit.Add(o1.GetTargetInflection().GetValue(), o2.GetTargetInflection().GetValue());
                break;
            }
            case 2: {
                cat = o1.GetTargetCategory().GetValue();
                infl = Bit.Add(o1.GetTargetInflection().GetValue(), o2.GetTargetInflection().GetValue());
                break;
            }
            case 3: {
                cat = Bit.Add(o1.GetTargetCategory().GetValue(), o2.GetTargetCategory().GetValue());
                infl = o1.GetTargetInflection().GetValue();
            }
        }
        out.SetTargetCategory(cat);
        out.SetTargetInflection(infl);
        return out;
    }

    private static boolean IsCombinable(LexItem o1, LexItem o2, int rule) {
        boolean flag = true;
        flag = flag && o1.GetOriginalTerm().equals(o2.GetOriginalTerm()) && o1.GetFlowHistory().equals(o2.GetFlowHistory());
        switch (rule) {
            case 1: {
                flag = flag && o1.GetTargetTerm().equals(o2.GetTargetTerm());
                break;
            }
            case 4: {
                flag = flag && o1.GetTargetTerm().equals(o2.GetTargetTerm()) && o1.GetMutateInformation().equals(o2.GetMutateInformation());
                break;
            }
            case 2: {
                flag = flag && o1.GetTargetTerm().equals(o2.GetTargetTerm()) && o1.GetTargetCategory().GetValue() == o2.GetTargetCategory().GetValue();
                break;
            }
            case 3: {
                flag = flag && o1.GetTargetTerm().equals(o2.GetTargetTerm()) && o1.GetTargetInflection().GetValue() == o2.GetTargetInflection().GetValue();
            }
        }
        return flag;
    }
}

