/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.CanonRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCanon;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToCanonicalize
extends Transformation {
    private static final String INFO = "Canonicalize";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        CanonInfo canonInfo = ToCanonicalize.CanonicalizeWords(in.GetSourceTerm().toLowerCase(), conn);
        String term = canonInfo.GetCanonTerm();
        String numberStr = canonInfo.GetCanonNum();
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = "Canonicalize (" + numberStr + ")";
        }
        if (mutateFlag) {
            mutate = numberStr + GlobalBehavior.GetInstance().GetFieldSeparator();
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToCanonicalize.UpdateLexItem(in, term, 10, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToCanonicalize.GetTestStr(args, "being");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToCanonicalize.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToCanonicalize.PrintResults(in, outs);
    }

    private static CanonInfo CanonicalizeWords(String inStr, Connection conn) throws SQLException {
        CanonRecord temp;
        StringBuffer out = new StringBuffer();
        StringBuffer canonId = new StringBuffer();
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        Vector<CanonRecord> canonList = new Vector<CanonRecord>();
        while (buf.hasMoreTokens()) {
            String curStr = buf.nextToken();
            temp = ToCanonicalize.CanonicalizeWord(curStr, conn);
            canonList.addElement(temp);
        }
        for (int i = 0; i < canonList.size(); ++i) {
            temp = (CanonRecord)canonList.elementAt(i);
            out.append(temp.GetCanonicalizedTerm());
            out.append(" ");
            canonId.append(temp.GetCanonicalId());
            canonId.append(" ");
        }
        CanonInfo canonInfo = new CanonInfo(out.toString().trim(), canonId.toString().trim());
        return canonInfo;
    }

    private static CanonRecord CanonicalizeWord(String inWord, Connection conn) throws SQLException {
        CanonRecord out = new CanonRecord(inWord);
        Vector<CanonRecord> outList = DbCanon.GetCanons(inWord, conn);
        if (outList.size() == 1) {
            out = outList.elementAt(0);
        }
        return out;
    }

    private static class CanonInfo {
        private String canonTerm_ = null;
        private String canonNum_ = null;

        private CanonInfo(String canonTerm, String canonNum) {
            this.canonTerm_ = canonTerm;
            this.canonNum_ = canonNum;
        }

        private String GetCanonTerm() {
            return this.canonTerm_;
        }

        private String GetCanonNum() {
            return this.canonNum_;
        }
    }
}

