/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.Util.Out;
import java.util.Iterator;
import java.util.Vector;

public abstract class SystemOption {
    protected Option systemOption_ = null;

    public SystemOption() {
        this.DefineFlag();
    }

    public Option GetOption() {
        return this.systemOption_;
    }

    public static boolean CheckSyntax(Option option, Option systemOption, boolean printRun, boolean printError) {
        boolean legalFlag = true;
        Vector<OptionItem> inputItems = option.GetOptionItems();
        for (int i = 0; i < inputItems.size(); ++i) {
            OptionItem inputItem = inputItems.elementAt(i);
            legalFlag &= SystemOption.CheckOptionItem(inputItem, systemOption, printRun, printError);
        }
        return legalFlag;
    }

    public void ExecuteCommands(Option inOption, Option systemOption, Out out) {
        Vector<OptionItem> optionItems = inOption.GetOptionItems();
        for (int i = 0; i < optionItems.size(); ++i) {
            OptionItem optionItem = optionItems.elementAt(i);
            this.ExecuteCommand(optionItem, systemOption, out);
        }
    }

    protected abstract void ExecuteCommand(OptionItem var1, Option var2, Out var3);

    protected abstract void DefineFlag();

    protected boolean ToBoolean(String in) {
        boolean argu = false;
        if (in.equalsIgnoreCase("t") || in.equalsIgnoreCase("true")) {
            argu = true;
        }
        return argu;
    }

    protected int[] ToIntArray(Vector<String> inList) {
        int[] array = new int[inList.size()];
        int index = 0;
        Iterator<String> it = inList.iterator();
        while (it.hasNext()) {
            array[index++] = Integer.parseInt(it.next());
        }
        return array;
    }

    protected float[] ToFloatArray(Vector<String> inList) {
        float[] array = new float[inList.size()];
        int index = 0;
        Iterator<String> it = inList.iterator();
        while (it.hasNext()) {
            array[index++] = Float.parseFloat(it.next());
        }
        return array;
    }

    protected String[] ToStringArray(Vector<String> inList) {
        String[] array = (String[])inList.toArray();
        return array;
    }

    protected static boolean CheckOption(OptionItem inItem, String systemItemStr) {
        OptionItem systemItem = new OptionItem(systemItemStr);
        boolean legalFlag = SystemOption.CheckOption(inItem, systemItem);
        return legalFlag;
    }

    private static boolean CheckOptionItem(OptionItem inputItem, Option systemOption, boolean PrintRun, boolean PrintError) {
        OptionItem nameItem = OptionUtility.GetItemByName(inputItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        boolean legalOption = false;
        for (int i = 0; i < systemItems.size(); ++i) {
            OptionItem systemItem = systemItems.elementAt(i);
            if (!SystemOption.CheckOption(nameItem, systemItem)) continue;
            if (PrintRun) {
                System.out.println("Run: " + inputItem.GetOptionItem() + " => " + systemItem.GetOptionFlag() + ", '" + systemItem.GetOptionArgument() + "'.");
            }
            legalOption = true;
            break;
        }
        if (!legalOption && PrintError) {
            System.out.println("*** Syntax Error: " + inputItem.GetOptionItem() + "(" + SystemOption.GetLegalSyntax(inputItem, systemOption) + ").");
        }
        return legalOption;
    }

    private static String GetLegalSyntax(OptionItem item, Option systemOption) {
        int i;
        Vector<String> msgList = new Vector<String>(1);
        String msg = null;
        String msgFlag = "";
        String msgArgu = "";
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        String itemStr = item.GetOptionItem();
        String flag = item.GetOptionFlag();
        String argu = item.GetOptionArgument();
        String lastStr = null;
        boolean errorFlag = false;
        for (i = 0; i < systemItems.size(); ++i) {
            String newStr;
            OptionItem systemItem = systemItems.elementAt(i);
            String systemItemStr = systemItem.GetOptionItem();
            int index = systemItemStr.indexOf(itemStr);
            if (index != -1 && !(newStr = SystemOption.CombineArguments(lastStr, systemItemStr)).equals(lastStr)) {
                int ind = msgList.size() - 1;
                if (ind == -1) {
                    msgList.addElement(newStr);
                } else {
                    msgList.setElementAt(newStr, ind);
                }
                lastStr = newStr;
            }
            if (!systemItem.GetOptionFlag().equals(flag) || SystemOption.CheckArguments(argu, systemItem.GetOptionArgument())) continue;
            msgFlag = systemItem.GetOptionFlag();
            if (msgFlag.equals("Root")) {
                msgFlag = "";
            }
            msgArgu = msgArgu + OptionItem.GetSeparator(msgFlag, 1) + systemItem.GetOptionArgument();
            errorFlag = true;
        }
        if (errorFlag) {
            msgList.addElement(msgFlag + msgArgu);
        }
        if (msgList.size() == 0) {
            msg = "Illegal option arguments; Too many levels!";
        } else {
            msg = (String)msgList.elementAt(0);
            for (i = 1; i < msgList.size(); ++i) {
                msg = msg + "; " + (String)msgList.elementAt(i);
            }
        }
        return msg;
    }

    private static String CombineArguments(String oldStr, String systemStr) {
        if (oldStr == null) {
            return systemStr;
        }
        Option option = new Option(oldStr);
        Vector<OptionItem> optionItems = option.GetOptionItems();
        OptionItem optionItem = new OptionItem(systemStr);
        optionItems.addElement(optionItem);
        String newStr = OptionUtility.GetOptionStr(optionItems);
        return newStr;
    }

    private static boolean CheckOption(OptionItem inItem, OptionItem systemItem) {
        String flag = inItem.GetOptionFlag();
        String argu = inItem.GetOptionArgument();
        boolean legalFlag = systemItem.GetOptionFlag().equals(flag) && SystemOption.CheckArguments(argu, systemItem.GetOptionArgument());
        return legalFlag;
    }

    private static boolean CheckArguments(String in, String system) {
        boolean legalFlag = false;
        int index = system.indexOf(43);
        legalFlag = index == -1 ? SystemOption.IsLegalArgument(in, system) : SystemOption.IsLegalArguments(in, system);
        return legalFlag;
    }

    private static boolean IsLegalArguments(String in, String system) {
        boolean flag = false;
        Vector<String> systemList = OptionItem.GetArgumentList(system);
        Vector<String> inList = OptionItem.GetArgumentList(in);
        if (systemList.size() == inList.size()) {
            for (int i = 0; i < inList.size() && (flag = SystemOption.IsLegalArgument(inList.elementAt(i), systemList.elementAt(i))); ++i) {
            }
        }
        return flag;
    }

    private static boolean IsLegalArgument(String in, String system) {
        boolean flag = false;
        if (system.equals("STR")) {
            flag = true;
        } else if (system.equals(in)) {
            flag = true;
        } else if (system.equals("INT")) {
            try {
                Integer.parseInt(in);
                flag = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (system.equals("LONG")) {
            try {
                Long.parseLong(in);
                flag = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (system.equals("FLT")) {
            try {
                Float.parseFloat(in);
                flag = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (system.equals("BLN") && (in.equalsIgnoreCase("t") || in.equalsIgnoreCase("f") || in.equalsIgnoreCase("true") || in.equalsIgnoreCase("false"))) {
            flag = true;
        }
        return flag;
    }
}

