/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    protected static final Param[] EMPTY_PARAMS = new Param[0];

    @Override
    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (!(component instanceof UIInput)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is not an instance or a sub class of UIInput", component.getId());
            }
            return;
        }
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        Map<String, String> requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = requestMap.get(clientId);
        if (newValue != null) {
            this.setSubmittedValue(component, newValue);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new value after decoding {0}", newValue);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String currentValue = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value to be rendered {0}", currentValue);
        }
        this.getEndTextToRender(context, component, currentValue);
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    protected final String decodeBehaviors(FacesContext context, UIComponent component) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder holder = (ClientBehaviorHolder)((Object)component);
        Map<String, List<ClientBehavior>> behaviors = holder.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return null;
        }
        ExternalContext external = context.getExternalContext();
        Map<String, String> params = external.getRequestParameterMap();
        String behaviorEvent = params.get("javax.faces.behavior.event");
        if (null != behaviorEvent) {
            List<ClientBehavior> behaviorsForEvent = behaviors.get(behaviorEvent);
            if (behaviors.size() > 0) {
                String clientId;
                String behaviorSource = params.get("javax.faces.source");
                if (this.isBehaviorSource(context, behaviorSource, clientId = component.getClientId())) {
                    for (ClientBehavior behavior : behaviorsForEvent) {
                        behavior.decode(context, component);
                    }
                }
                return clientId;
            }
        }
        return null;
    }

    protected boolean isBehaviorSource(FacesContext ctx, String behaviorSourceId, String componentClientId) {
        return behaviorSourceId != null && behaviorSourceId.equals(componentClientId);
    }

    protected String augmentIdReference(String forValue, UIComponent fromComponent) {
        int idSuffix;
        String id;
        int forSuffix = forValue.lastIndexOf("j_id");
        if (forSuffix <= 0 && (id = fromComponent.getId()) != null && (idSuffix = id.lastIndexOf("j_id")) > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Augmenting for attribute with " + id.substring(idSuffix) + " suffix from Id attribute");
            }
            forValue = forValue + id.substring(idSuffix);
        }
        return forValue;
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator<UIComponent> getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return component.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return submittedValue.toString();
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = this.getFormattedValue(context, component, currentObj);
        }
        return currentValue;
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = null;
        if (component.getFacetCount() > 0 && (facet = component.getFacet(name)) != null && !facet.isRendered()) {
            facet = null;
        }
        return facet;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component) {
        if (null == forComponent || forComponent.length() == 0) {
            return null;
        }
        UIComponent result = null;
        try {
            for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
            }
            if (result == null) {
                result = HtmlBasicRenderer.findUIComponentBelow(context.getViewRoot(), forComponent);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", forComponent));
        }
        return result;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue, Converter converter) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                return currentValue.toString();
            }
            return null;
        }
        if (converter == null) {
            converter = ((ValueHolder)((Object)component)).getConverter();
        }
        if (converter == null) {
            if (currentValue == null) {
                return "";
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null) {
                return currentValue.toString();
            }
        }
        return converter.getAsString(context, component, currentValue);
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return this.getFormattedValue(context, component, currentValue, null);
    }

    protected Iterator getMessageIter(FacesContext context, String forComponent, UIComponent component) {
        UIComponent result;
        Iterator<Object> messageIter = null != forComponent ? (forComponent.length() == 0 ? context.getMessages(null) : ((result = this.getForComponent(context, forComponent, component)) == null ? Collections.EMPTY_LIST.iterator() : context.getMessages(result.getClientId(context)))) : context.getMessages();
        return messageIter;
    }

    protected Param[] getParamList(UIComponent command) {
        if (command.getChildCount() > 0) {
            ArrayList<Param> parameterList = new ArrayList<Param>();
            for (UIComponent kid : command.getChildren()) {
                UIParameter uiParam;
                if (!(kid instanceof UIParameter) || (uiParam = (UIParameter)kid).isDisable()) continue;
                Object value = uiParam.getValue();
                Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
                parameterList.add(param);
            }
            return parameterList.toArray(new Param[parameterList.size()]);
        }
        return EMPTY_PARAMS;
    }

    protected Collection<ClientBehaviorContext.Parameter> getBehaviorParameters(UIComponent command) {
        ArrayList<ClientBehaviorContext.Parameter> params = null;
        int childCount = command.getChildCount();
        if (childCount > 0) {
            for (UIComponent kid : command.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)kid;
                String name = uiParam.getName();
                Object value = uiParam.getValue();
                if (name == null || name.length() <= 0) continue;
                if (params == null) {
                    params = new ArrayList<ClientBehaviorContext.Parameter>(childCount);
                }
                params.add(new ClientBehaviorContext.Parameter(name, value));
            }
        }
        return params == null ? Collections.emptyList() : params;
    }

    protected Object getValue(UIComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)((Object)component)).getClientBehaviors().isEmpty());
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) {
        String id;
        block3: {
            id = null;
            if (this.shouldWriteIdAttribute(component)) {
                try {
                    id = component.getClientId(context);
                    writer.writeAttribute("id", id, "id");
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_WRITE_ID_ATTRIBUTE", e.getMessage());
                    logger.warning(message);
                }
            }
        }
        return id;
    }

    protected void rendererParamsNotNull(FacesContext context, UIComponent component) {
        Util.notNull("context", context);
        Util.notNull("component", component);
    }

    protected boolean shouldEncode(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "End encoding component {0} since rendered attribute is set to false", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldDecode(UIComponent component) {
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is disabled or read-only", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldEncodeChildren(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Children of component {0} will not be encoded since this component's rendered attribute is false", component.getId());
            }
            return false;
        }
        return true;
    }

    protected static Map<String, List<ClientBehavior>> getPassThruBehaviors(UIComponent component, String domEventName, String componentEventName) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        Map<String, List<ClientBehavior>> behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors();
        int size = behaviors.size();
        if (size == 1 || size == 2) {
            boolean hasDomBehavior = behaviors.containsKey(domEventName);
            boolean hasComponentBehavior = behaviors.containsKey(componentEventName);
            if (size == 1 && (hasDomBehavior || hasComponentBehavior) || size == 2 && hasDomBehavior && hasComponentBehavior) {
                return null;
            }
        }
        return behaviors;
    }

    private static UIComponent findUIComponentBelow(UIComponent startPoint, String forComponent) {
        UIComponent retComp = null;
        if (startPoint.getChildCount() > 0) {
            List<UIComponent> children = startPoint.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                UIComponent comp = children.get(i);
                if (comp instanceof NamingContainer) {
                    try {
                        retComp = comp.findComponent(forComponent);
                    }
                    catch (IllegalArgumentException iae) {
                        continue;
                    }
                }
                if (retComp == null && comp.getChildCount() > 0) {
                    retComp = HtmlBasicRenderer.findUIComponentBelow(comp, forComponent);
                }
                if (retComp != null) break;
            }
        }
        return retComp;
    }

    public static class OptionComponentInfo {
        String disabledClass;
        String enabledClass;
        String selectedClass;
        String unselectedClass;
        boolean disabled;
        boolean hideNoSelection;

        public OptionComponentInfo(String disabledClass, String enabledClass, boolean disabled, boolean hideNoSelection) {
            this(disabledClass, enabledClass, null, null, disabled, hideNoSelection);
        }

        public OptionComponentInfo(String disabledClass, String enabledClass, String unselectedClass, String selectedClass, boolean disabled, boolean hideNoSelection) {
            this.disabledClass = disabledClass;
            this.enabledClass = enabledClass;
            this.unselectedClass = unselectedClass;
            this.selectedClass = selectedClass;
            this.disabled = disabled;
            this.hideNoSelection = hideNoSelection;
        }

        public String getDisabledClass() {
            return this.disabledClass;
        }

        public String getEnabledClass() {
            return this.enabledClass;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isHideNoSelection() {
            return this.hideNoSelection;
        }

        public String getSelectedClass() {
            return this.selectedClass;
        }

        public String getUnselectedClass() {
            return this.unselectedClass;
        }
    }

    public static class Param {
        public String name;
        public String value;

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

