/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.ArrayList;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.AnnotationCounter;
import org.apache.ctakes.coreference.util.AnnotationSelector;
import org.apache.ctakes.coreference.util.AttributeCalculator;
import org.apache.ctakes.coreference.util.TextMatch;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class PairAttributeCalculator
extends AttributeCalculator {
    protected Markable m1;
    protected Markable m2;
    protected String ms1;
    protected String ms2;
    protected String es1;
    protected String es2;
    protected Annotation a1;
    protected Annotation a2;
    boolean alias;

    public PairAttributeCalculator(JCas jcas, Markable m1, Markable m2) {
        super(jcas);
        this.m1 = m1;
        this.m2 = m2;
        this.a1 = m1.getContent();
        this.a2 = m2.getContent();
        this.ms1 = m1.getCoveredText();
        this.ms2 = m2.getCoveredText();
        this.es1 = this.a1.getCoveredText();
        this.es2 = this.a2.getCoveredText();
        this.alias = this.isAlias();
    }

    public String calcSameSection() {
        boolean sameSection = false;
        return sameSection ? "yes" : "no";
    }

    public double calcTokenDistance() {
        return (double)AnnotationCounter.countInterval(AnnotationSelector.selectBaseToken(this.jcas), this.m1.getEnd(), this.m2.getBegin()) / 600.0;
    }

    public double calcSentenceDistance() {
        return (double)this.getSentenceDistance() / 20.0;
    }

    public int getSentenceDistance() {
        return AnnotationCounter.countPoint(AnnotationSelector.selectSentence(this.jcas), this.m1.getEnd(), this.m2.getBegin());
    }

    public boolean calcExactMatch() {
        return this.ms1.equalsIgnoreCase(this.ms2);
    }

    public boolean calcStartMatch() {
        return TextMatch.startMatch(this.ms1, this.ms2);
    }

    public boolean calcMidMatch() {
        return false;
    }

    public boolean calcEndMatch() {
        return TextMatch.endMatch(this.ms1, this.ms2);
    }

    public boolean calcStringMatch() {
        return this.calcExactMatch() || this.calcStartMatch() || this.calcEndMatch();
    }

    public boolean calcEntityExactMatch() {
        return this.es1.equalsIgnoreCase(this.es2);
    }

    public boolean calcEntityStartMatch() {
        return TextMatch.startMatch(this.es1, this.es2);
    }

    public boolean calcEntityEndMatch() {
        return TextMatch.endMatch(this.es1, this.es2);
    }

    public boolean calcSoonStr() {
        String sl1 = this.ms1.toLowerCase();
        String sl2 = this.ms2.toLowerCase();
        sl1 = PairAttributeCalculator.nonDetSubstr(sl1);
        sl2 = PairAttributeCalculator.nonDetSubstr(sl2);
        return sl1.equals(sl2);
    }

    private static String nonDetSubstr(String s) {
        if (s.startsWith("the ")) {
            return s.substring(4);
        }
        if (s.startsWith("a ")) {
            return s.substring(2);
        }
        if (s.startsWith("this ")) {
            return s.substring(5);
        }
        if (s.startsWith("that ")) {
            return s.substring(5);
        }
        return s;
    }

    public boolean calcPronoun1() {
        return PairAttributeCalculator.isPronoun(this.m1);
    }

    public boolean calcPronoun2() {
        return PairAttributeCalculator.isPronoun(this.m2);
    }

    public boolean calcDefinite2() {
        return PairAttributeCalculator.isDefinite(this.ms2);
    }

    public boolean calcDemonstrative2() {
        return PairAttributeCalculator.isDemonstrative(this.ms2);
    }

    public boolean calcNumberMatchC() {
        String n1 = this.number(this.m1);
        String n2 = this.number(this.m2);
        return !n1.equals("U") && !n2.equals("U") && n1.equals(n2);
    }

    public boolean calcNumberMatchI() {
        String n1 = this.number(this.m1);
        String n2 = this.number(this.m2);
        return !n1.equals("U") && !n2.equals("U") && !n1.equals(n2);
    }

    public boolean calcNumberMatchNA() {
        String n1 = this.number(this.m1);
        String n2 = this.number(this.m2);
        return n1.equals("U") || n2.equals("U");
    }

    public boolean calcWnClassC() {
        if (this.m1.getContent() instanceof IdentifiedAnnotation && this.m2.getContent() instanceof IdentifiedAnnotation) {
            IdentifiedAnnotation ne1 = (IdentifiedAnnotation)this.m1.getContent();
            IdentifiedAnnotation ne2 = (IdentifiedAnnotation)this.m2.getContent();
            return ne1.getTypeID() == ne2.getTypeID();
        }
        return false;
    }

    public boolean calcWnClassI() {
        if (this.m1.getContent() instanceof IdentifiedAnnotation && this.m2.getContent() instanceof IdentifiedAnnotation) {
            IdentifiedAnnotation ne1 = (IdentifiedAnnotation)this.m1.getContent();
            IdentifiedAnnotation ne2 = (IdentifiedAnnotation)this.m2.getContent();
            return ne1.getTypeID() != ne2.getTypeID();
        }
        return false;
    }

    public boolean calcWnClassNA() {
        return !(this.m1.getContent() instanceof IdentifiedAnnotation) || !(this.m2.getContent() instanceof IdentifiedAnnotation);
    }

    public boolean calcWnClass() {
        if (this.m1.getContent() instanceof IdentifiedAnnotation && this.m2.getContent() instanceof IdentifiedAnnotation) {
            IdentifiedAnnotation ne1 = (IdentifiedAnnotation)this.m1.getContent();
            IdentifiedAnnotation ne2 = (IdentifiedAnnotation)this.m2.getContent();
            if (ne1.getTypeID() == ne2.getTypeID()) {
                return true;
            }
        }
        return false;
    }

    public boolean calcAlias() {
        return this.alias;
    }

    public boolean isAlias() {
        try {
            if (this.m1.getContent() instanceof IdentifiedAnnotation && this.m2.getContent() instanceof IdentifiedAnnotation) {
                int i;
                IdentifiedAnnotation ne1 = (IdentifiedAnnotation)this.m1.getContent();
                IdentifiedAnnotation ne2 = (IdentifiedAnnotation)this.m2.getContent();
                ArrayList<String> l = new ArrayList<String>();
                FSArray fsa = ne1.getOntologyConceptArr();
                for (i = 0; i < fsa.size(); ++i) {
                    if (!(fsa.get(i) instanceof UmlsConcept)) continue;
                    l.add(((UmlsConcept)fsa.get(i)).getCui());
                }
                fsa = ne2.getOntologyConceptArr();
                for (i = 0; i < fsa.size(); ++i) {
                    if (!(fsa.get(i) instanceof UmlsConcept) || !l.contains(((UmlsConcept)fsa.get(i)).getCui())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error here!");
        }
        return false;
    }

    public boolean calcProStr() {
        return PairAttributeCalculator.isPronominal(this.m1) && PairAttributeCalculator.isPronominal(this.m2) && this.ms1.equalsIgnoreCase(this.ms2);
    }

    public boolean calcWordsStr() {
        return !PairAttributeCalculator.isPronominal(this.m1) && !PairAttributeCalculator.isPronominal(this.m2) && this.ms1.equalsIgnoreCase(this.ms2);
    }

    private static String removeArticleAndDemon(String s) {
        if (s.toLowerCase().startsWith("a ")) {
            return s.substring(2);
        }
        if (s.toLowerCase().startsWith("an ")) {
            return s.substring(3);
        }
        if (s.toLowerCase().startsWith("the ")) {
            return s.substring(4);
        }
        if (s.toLowerCase().startsWith("this ")) {
            return s.substring(5);
        }
        if (s.toLowerCase().startsWith("that ")) {
            return s.substring(5);
        }
        if (s.toLowerCase().startsWith("these ")) {
            return s.substring(6);
        }
        if (s.toLowerCase().startsWith("those ")) {
            return s.substring(6);
        }
        return s;
    }

    public boolean calcSoonStrNonpro() {
        if (!PairAttributeCalculator.isPronominal(this.m1) && !PairAttributeCalculator.isPronominal(this.m2)) {
            String str1 = PairAttributeCalculator.removeArticleAndDemon(this.ms1);
            String str2 = PairAttributeCalculator.removeArticleAndDemon(this.ms2);
            if (str1.toLowerCase().indexOf(str2.toLowerCase()) >= 0 || str2.toLowerCase().indexOf(str1.toLowerCase()) >= 0) {
                return true;
            }
        }
        return false;
    }

    public boolean calcWordOverlap() {
        ArrayList<String> t1 = this.contentWords(this.m1);
        ArrayList<String> t2 = this.contentWords(this.m2);
        for (String s : t2) {
            if (!t1.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean calcModifier() {
        return true;
    }

    private static boolean isProperSubstring(ArrayList<String> l1, ArrayList<String> l2) {
        String str1 = "";
        String str2 = "";
        for (String s : l1) {
            str1 = str1 + " " + s;
        }
        for (String s : l2) {
            str2 = str2 + " " + s;
        }
        return str1.length() != str2.length() || str2.indexOf(str1) >= 0;
    }

    public boolean calcWordsSubstr() {
        ArrayList<String> t2;
        ArrayList<String> t1;
        return !PairAttributeCalculator.isPronominal(this.m1) && !PairAttributeCalculator.isPronominal(this.m2) && (PairAttributeCalculator.isProperSubstring(t1 = this.contentWords(this.m1), t2 = this.contentWords(this.m2)) || PairAttributeCalculator.isProperSubstring(t2, t1));
    }

    public boolean calcBothDefinitesC() {
        return PairAttributeCalculator.isDefinite(this.ms1) && PairAttributeCalculator.isDefinite(this.ms2);
    }

    public boolean calcBothDefinitesI() {
        return !PairAttributeCalculator.isDefinite(this.ms1) && !PairAttributeCalculator.isDefinite(this.ms2);
    }

    public boolean calcBothDefinitesNA() {
        boolean b1 = PairAttributeCalculator.isDefinite(this.ms1);
        boolean b2 = PairAttributeCalculator.isDefinite(this.ms2);
        return !(b1 && b2 || !b1 && !b2);
    }

    public boolean calcBothPronounsC() {
        boolean b1 = PairAttributeCalculator.isPronoun(this.m1);
        boolean b2 = PairAttributeCalculator.isPronoun(this.m2);
        return b1 && b2;
    }

    public boolean calcBothPronounsI() {
        boolean b1 = PairAttributeCalculator.isPronoun(this.m1);
        boolean b2 = PairAttributeCalculator.isPronoun(this.m2);
        return !b1 && !b2;
    }

    public boolean calcBothPronounsNA() {
        boolean b1 = PairAttributeCalculator.isPronoun(this.m1);
        boolean b2 = PairAttributeCalculator.isPronoun(this.m2);
        return !(b1 && b2 || !b1 && !b2);
    }

    public boolean calcBothPronouns() {
        boolean b1 = PairAttributeCalculator.isPronoun(this.m1);
        boolean b2 = PairAttributeCalculator.isPronoun(this.m2);
        return b1 && b2;
    }

    public boolean calcIndefinite() {
        return !this.ms2.toLowerCase().startsWith("a ") && !this.ms2.toLowerCase().startsWith("an ");
    }

    public boolean calcPronoun() {
        return !PairAttributeCalculator.isPronoun(this.m1) || PairAttributeCalculator.isPronoun(this.m2);
    }

    public boolean calcDefinite1() {
        return PairAttributeCalculator.isDefinite(this.ms1);
    }

    public boolean calcIsDrug() {
        return this.m1.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m1.getContent()).getTypeID() == 1;
    }

    public boolean calcIsDisorder() {
        return this.m1.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m1.getContent()).getTypeID() == 2;
    }

    public boolean calcIsFinding() {
        return this.m1.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m1.getContent()).getTypeID() == 3;
    }

    public boolean calcIsProcedure() {
        return this.m1.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m1.getContent()).getTypeID() == 5;
    }

    public boolean calcIsAnatomicalSite() {
        return this.m1.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m1.getContent()).getTypeID() == 6;
    }

    public boolean calcNegatedBoth() {
        return (this.a1 instanceof EntityMention && this.a2 instanceof EntityMention || this.a1 instanceof EventMention && this.a2 instanceof EventMention) && ((IdentifiedAnnotation)this.a1).getPolarity() == -1 && ((IdentifiedAnnotation)this.a2).getPolarity() == -1;
    }

    public boolean calcNonNegatedBoth() {
        return (this.a1 instanceof EntityMention && this.a2 instanceof EntityMention || this.a1 instanceof EventMention && this.a2 instanceof EventMention) && (double)((IdentifiedAnnotation)this.a1).getPolarity() == 1.0 && (double)((IdentifiedAnnotation)this.a2).getPolarity() == 1.0;
    }

    public boolean calcClosestComp() {
        if (this.calcWnClass()) {
            ArrayList<Annotation> l = AnnotationSelector.selectNE(this.jcas);
            int m2type = ((IdentifiedAnnotation)this.m2.getContent()).getTypeID();
            for (Annotation a : l) {
                if (((IdentifiedAnnotation)a).getTypeID() != m2type || a.getBegin() < this.m1.getEnd() || a.getEnd() > this.m2.getBegin()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean calcNPHead() {
        Annotation a = this.m1.getContent();
        for (LookupWindowAnnotation lwa : this.jcas.getJFSIndexRepository().getAnnotationIndex(LookupWindowAnnotation.type)) {
            if (lwa.getBegin() > a.getBegin() || lwa.getEnd() != a.getEnd()) continue;
            return true;
        }
        return false;
    }

    public double calcPermStrDist() {
        return 0.0;
    }

    public boolean calcAliasDrug() {
        return this.alias && this.calcIsDrug();
    }

    public boolean calcAliasDisorder() {
        return this.alias && this.calcIsDisorder();
    }

    public boolean calcAliasFinding() {
        return this.alias && this.calcIsFinding();
    }

    public boolean calcAliasProcedure() {
        return this.alias && this.calcIsProcedure();
    }

    public boolean calcAliasAnatomy() {
        return this.alias && this.calcIsAnatomicalSite();
    }
}

