/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class HobbsTreeNavigator {
    public static LinkedList<TreebankNode> bfs(Queue<TreebankNode> q, TreebankNode X, TreebankNode node) {
        LinkedList<TreebankNode> list = new LinkedList<TreebankNode>();
        HashSet<TreebankNode> path = new HashSet<TreebankNode>();
        TreebankNode cur = node;
        if (cur != null) {
            path.add(cur);
            while (cur != X) {
                cur = cur.getParent();
                path.add(cur);
            }
        }
        block1: while (!q.isEmpty()) {
            TreebankNode n;
            cur = q.remove();
            if (cur.getNodeType().equals("NP") && !path.contains(cur)) {
                list.add(cur);
            }
            for (int i = 0; i < cur.getChildren().size() && (n = cur.getChildren(i)) != node; ++i) {
                q.add(n);
                if (path.contains(n)) continue block1;
            }
        }
        return list;
    }

    public static TreebankNode nextX(TreebankNode curX) {
        TreebankNode nextX = curX.getParent();
        while (!nextX.getNodeType().equals("NP") && !nextX.getNodeType().equals("S") && (nextX = nextX.getParent()) != null) {
        }
        return nextX;
    }

    public static Queue<TreebankNode> initializeQueue(TreebankNode X, TreebankNode Y) {
        LinkedList<TreebankNode> q = new LinkedList<TreebankNode>();
        while (Y.getParent() != X) {
            Y = Y.getParent();
        }
        for (int i = 0; i < X.getChildren().size(); ++i) {
            TreebankNode n = X.getChildren(i);
            q.add(n);
            if (n == Y) break;
        }
        return q;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LinkedList<Markable> sort(Markable m, LinkedList<Markable> lm, JCas jcas) {
        TreebankNode node;
        Annotation a;
        LinkedList<Markable> ll = new LinkedList<Markable>();
        HashMap<TreebankNode, Markable> node2mark = new HashMap<TreebankNode, Markable>();
        HashSet<Markable> allMarks = new HashSet<Markable>();
        FSIterator iterator = jcas.getAnnotationIndex(TopTreebankNode.type).iterator();
        LinkedList<Annotation> sentList = FSIteratorToList.convert(iterator);
        int sentInd = 0;
        Iterator iterator2 = lm.iterator();
        while (iterator2.hasNext() && (a = (Annotation)iterator2.next()).getBegin() <= m.getBegin()) {
            TreebankNode n = MarkableTreeUtils.markableNode(jcas, a.getBegin(), a.getEnd());
            node2mark.put(n, (Markable)a);
            allMarks.add((Markable)a);
        }
        for (int i = 0; i < sentList.size(); ++i) {
            a = sentList.get(i);
            if (m.getBegin() < a.getBegin() || m.getEnd() > a.getEnd()) continue;
            sentInd = i;
            break;
        }
        TreebankNode Y = node = MarkableTreeUtils.markableNode(jcas, m.getBegin(), m.getEnd());
        TreebankNode X = HobbsTreeNavigator.nextX(node);
        if (X == null) return ll;
        Queue<TreebankNode> q = HobbsTreeNavigator.initializeQueue(X, Y);
        LinkedList<TreebankNode> tempList = HobbsTreeNavigator.bfs(q, X, Y);
        Iterator iterator3 = tempList.iterator();
        block2: while (true) {
            if (!iterator3.hasNext()) {
                if (allMarks.size() != 0) break;
                return ll;
            }
            TreebankNode treebankNode = (TreebankNode)iterator3.next();
            TreebankNode n = treebankNode.getParent();
            while (true) {
                if (n == null || n == X) continue block2;
                if ((n.getNodeType().equals("NP") || n.getNodeType().equals("S")) && node2mark.containsKey(n)) {
                    ll.add((Markable)((Object)node2mark.get(n)));
                    allMarks.remove(node2mark.get(n));
                    continue block2;
                }
                n = n.getParent();
            }
            break;
        }
        while (X != null && !X.getParent().getNodeType().equals("TOP")) {
            Y = X;
            if ((X = HobbsTreeNavigator.nextX(Y)) == null) continue;
            if (X.getNodeType().equals("NP") && node2mark.containsKey(X)) {
                ll.add((Markable)((Object)node2mark.get(X)));
                allMarks.remove(node2mark.get(X));
            }
            q = HobbsTreeNavigator.initializeQueue(X, Y);
            tempList = HobbsTreeNavigator.bfs(q, X, Y);
            for (TreebankNode treebankNode : tempList) {
                if (!node2mark.containsKey(treebankNode)) continue;
                ll.add((Markable)((Object)node2mark.get(treebankNode)));
                allMarks.remove(node2mark.get(treebankNode));
            }
        }
        block6: while (allMarks.size() > 0) {
            if (--sentInd < 0) {
                return ll;
            }
            TopTreebankNode ttn = (TopTreebankNode)sentList.get(sentInd);
            q = new LinkedList<TreebankNode>();
            q.add((TreebankNode)ttn);
            tempList = HobbsTreeNavigator.bfs(q, null, null);
            Iterator iterator4 = tempList.iterator();
            while (true) {
                if (!iterator4.hasNext()) continue block6;
                TreebankNode cur = (TreebankNode)iterator4.next();
                if (!node2mark.containsKey(cur)) continue;
                ll.add((Markable)((Object)node2mark.get(cur)));
                allMarks.remove(node2mark.get(cur));
            }
            break;
        }
        return ll;
    }
}

