/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AttributeCalculator {
    static HashSet<String> stopwords;
    JCas jcas;
    Hashtable<Integer, BaseToken> hbs;
    Hashtable<Integer, BaseToken> hbe;

    public AttributeCalculator(JCas jcas) {
        this.jcas = jcas;
        this.hbs = new Hashtable();
        this.hbe = new Hashtable();
        for (BaseToken t : jcas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type)) {
            this.hbs.put(t.getBegin(), t);
            this.hbe.put(t.getEnd(), t);
        }
    }

    public void setStopWordsList(HashSet<String> l) {
        stopwords = l;
    }

    static boolean isPronoun(Markable m) {
        BaseToken t;
        return m.getContent() instanceof BaseToken && (t = (BaseToken)m.getContent()).getPartOfSpeech().startsWith("PRP");
    }

    static boolean isDemonstrative(String s) {
        return s.startsWith("this") || s.startsWith("that") || s.startsWith("these") || s.startsWith("those");
    }

    static boolean isPronominal(Markable m) {
        return AttributeCalculator.isDemonstrative(m.getCoveredText()) || AttributeCalculator.isPronoun(m);
    }

    static boolean isDefinite(String s) {
        return s.toLowerCase().startsWith("the ");
    }

    public String number(Markable m) {
        TreebankNode node = MarkableTreeUtils.markableNode(this.jcas, m.getBegin(), m.getEnd());
        if (node == null) {
            return this.basicNumber(m);
        }
        try {
            TerminalTreebankNode termNode = MarkableTreeUtils.getHead(node);
            String pos = termNode.getNodeType();
            if (pos.equals("NN") || pos.equals("NNP")) {
                return "S";
            }
            if (pos.equals("NNS") || pos.equals("NNPS")) {
                return "P";
            }
            String word = termNode.getCoveredText();
            if (word.equalsIgnoreCase("it")) {
                return "S";
            }
            if (word.equalsIgnoreCase("its")) {
                return "S";
            }
            if (word.equalsIgnoreCase("they")) {
                return "P";
            }
            if (word.equalsIgnoreCase("their")) {
                return "P";
            }
            return "U";
        }
        catch (NullPointerException e) {
            return this.basicNumber(m);
        }
    }

    String basicNumber(Markable m) {
        ArrayList<BaseToken> l = this.containedTokens(m.getContent().getBegin(), m.getContent().getEnd());
        for (BaseToken t : l) {
            String pos = t.getPartOfSpeech();
            if (pos.equals("NN") || pos.equals("NNP")) {
                return "S";
            }
            if (!pos.equals("NNS") && !pos.equals("NNPS")) continue;
            return "P";
        }
        return "U";
    }

    public ArrayList<BaseToken> containedTokens(int a, int b) {
        ArrayList<BaseToken> ret = new ArrayList<BaseToken>();
        BaseToken t1 = this.hbs.get(a);
        BaseToken t2 = this.hbe.get(b);
        if (t1 != null && t2 != null) {
            int begin = t1.getTokenNumber();
            int end = t2.getTokenNumber();
            LinkedList<Annotation> l = FSIteratorToList.convert(this.jcas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type).iterator());
            for (int i = 0; i < l.size(); ++i) {
                BaseToken t = (BaseToken)l.get(i);
                if (t.getTokenNumber() < begin || t.getTokenNumber() > end) continue;
                ret.add(t);
            }
        }
        return ret;
    }

    public ArrayList<String> contentWords(int begin, int end) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<BaseToken> l = this.containedTokens(begin, end);
        for (BaseToken t : l) {
            String s = t.getCoveredText().toLowerCase();
            if (stopwords.contains(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    ArrayList<String> contentWords(Markable m) {
        return this.contentWords(m.getBegin(), m.getEnd());
    }
}

