/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.eval;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.assertion.medfacts.cleartk.GenericCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.HistoryCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.SubjectCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.UncertaintyCleartkAnalysisEngine;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.ListFactory;
import org.apache.ctakes.coreference.ae.CoreferenceChainScoringOutput;
import org.apache.ctakes.coreference.ae.DeterministicMarkableAnnotator;
import org.apache.ctakes.coreference.ae.EventCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.coreference.ae.MarkableSalienceAnnotator;
import org.apache.ctakes.coreference.ae.MentionClusterCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.MentionClusterRankingCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.PersonChainAnnotator;
import org.apache.ctakes.coreference.factory.CoreferenceAnnotatorFactory;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.BackwardsTimeAnnotator;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.ae.EventAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.CoreferenceRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.utils.distsem.WordEmbeddings;
import org.apache.ctakes.utils.distsem.WordVector;
import org.apache.ctakes.utils.distsem.WordVectorReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.FlowControllerFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.JCasFlowController_ImplBase;
import org.apache.uima.flow.JCasFlow_ImplBase;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.ml.svmlight.rank.SvmLightRankDataWriter;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfEventCoreference
extends EvaluationOfTemporalRelations_ImplBase {
    private static Logger logger = Logger.getLogger(EvaluationOfEventCoreference.class);
    public static float COREF_PAIRS_DOWNSAMPLE = 0.5f;
    public static float COREF_CLUSTER_DOWNSAMPLE = 0.5f;
    private static final int NUM_SAMPLES = 0;
    private static final double DROPOUT_RATE = 0.1;
    protected static EvaluationOfEventTimeRelations.ParameterSettings pairwiseParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, COREF_PAIRS_DOWNSAMPLE, "tk", 1.0, 1.0, "linear", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings clusterParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, COREF_CLUSTER_DOWNSAMPLE, "tk", 1.0, 1.0, "linear", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    private static String goldOut = "";
    private static String systemOut = "";
    boolean skipTrain = false;
    boolean skipWrite = false;
    boolean skipTest = false;
    boolean goldMarkables = false;
    EVAL_SYSTEM evalType;
    String config = null;
    private String outputDirectory;

    public static void main(String[] args) throws Exception {
        CoreferenceOptions options = (CoreferenceOptions)CliFactory.parseArguments(CoreferenceOptions.class, (String[])args);
        List patientSets = options.getPatients().getList();
        List trainItems = EvaluationOfEventCoreference.getTrainItems((Evaluation_ImplBase.Options)options);
        List testItems = options.getTestOnTrain() ? EvaluationOfEventCoreference.getTrainItems((Evaluation_ImplBase.Options)options) : EvaluationOfEventCoreference.getTestItems((Evaluation_ImplBase.Options)options);
        EvaluationOfEventTimeRelations.ParameterSettings params = options.getEvalSystem() == EVAL_SYSTEM.MENTION_PAIR ? pairwiseParams : clusterParams;
        File workingDir = new File("target/eval/temporal-relations/coreference/" + (Object)((Object)options.getEvalSystem()) + File.separator + options.getConfig());
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        }
        if (options.getUseTmp()) {
            File tempModelDir = File.createTempFile("temporal", null, workingDir);
            tempModelDir.delete();
            tempModelDir.mkdir();
            workingDir = tempModelDir;
        }
        EvaluationOfEventCoreference eval = new EvaluationOfEventCoreference(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getPrintErrors(), options.getPrintFormattedRelations(), params, options.getKernelParams(), options.getOutputDirectory());
        eval.skipTrain = options.getSkipTrain();
        eval.skipWrite = options.getSkipDataWriting();
        eval.skipTest = options.getSkipTest();
        eval.goldMarkables = options.getGoldMarkables();
        eval.evalType = options.getEvalSystem();
        eval.config = options.getConfig();
        goldOut = "gold." + eval.config + ".conll";
        systemOut = "system." + eval.config + ".conll";
        eval.prepareXMIsFor(patientSets);
        params.stats = (AnnotationStatistics)eval.trainAndTest(trainItems, testItems);
        if (options.getUseTmp()) {
            FileUtils.deleteRecursive((File)workingDir);
        }
        if (options.getUseExternalScorer() && !options.getSkipTest()) {
            String line;
            Pattern patt = Pattern.compile("(?:Coreference|BLANC): Recall: \\([^\\)]*\\) (\\S+)%.*Precision: \\([^\\)]*\\) (\\S+)%.*F1: (\\S+)%");
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(new String[]{"perl", options.getScorerPath(), "all", options.getOutputDirectory() + goldOut, options.getOutputDirectory() + systemOut, "none"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String metric = null;
            System.out.println(String.format("%10s%7s%7s%7s", "Metric", "Rec", "Prec", "F1"));
            HashMap<String, Double> scores = new HashMap<String, Double>();
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if ((line = line.trim()).startsWith("METRIC")) {
                    metric = line.substring(7);
                    metric = metric.substring(0, metric.length() - 1);
                    continue;
                }
                if (!line.startsWith("Coreference") || !(m = patt.matcher(line)).matches()) continue;
                System.out.println(String.format("%10s%7.2f%7.2f%7.2f", metric, Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)), Double.parseDouble(m.group(3))));
                scores.put(metric, Double.parseDouble(m.group(3)));
            }
            if (scores.containsKey("muc") && scores.containsKey("bcub") && scores.containsKey("ceafe")) {
                double conll = ((Double)scores.get("muc") + (Double)scores.get("bcub") + (Double)scores.get("ceafe")) / 3.0;
                System.out.println(String.format("%10s              %7.2f", "Conll", conll));
            }
        }
    }

    public EvaluationOfEventCoreference(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean printErrors, boolean printRelations, EvaluationOfEventTimeRelations.ParameterSettings params, String cmdParams, String outputDirectory) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory, printErrors, printRelations, params);
        this.outputDirectory = outputDirectory;
        this.kernelParams = cmdParams == null ? null : cmdParams.replace("\"", "").split(" ");
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        String[] optArray;
        if (this.skipTrain) {
            return;
        }
        if (this.evalType == EVAL_SYSTEM.BASELINE || this.evalType == EVAL_SYSTEM.PERSON_ONLY) {
            return;
        }
        if (!this.skipWrite) {
            AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DocumentIDPrinter.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(UncertaintyCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(GenericCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(HistoryCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(SubjectCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", "Baseline"}), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ParagraphAnnotator.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RelationPropagator.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(EventAnnotator.createAnnotatorDescription(), new String[0]);
            aggregateBuilder.add(BackwardsTimeAnnotator.createAnnotatorDescription((String)"/org/apache/ctakes/temporal/ae/timeannotator/model.jar"), new String[0]);
            aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription((String)"/org/apache/ctakes/temporal/ae/doctimerel/model.jar"), new String[0]);
            if (this.goldMarkables) {
                aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyGoldMarkablesInChains.class, (Object[])new Object[0]), new String[0]);
            } else {
                aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DeterministicMarkableAnnotator.class, (Object[])new Object[0]), new String[0]);
                aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemovePersonMarkables.class, (Object[])new Object[0]), new String[0]);
            }
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(MarkableHeadTreeCreator.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyCoreferenceRelations.class, (Object[])new Object[]{"GoldViewName", "GoldView"}), new String[0]);
            aggregateBuilder.add(MarkableSalienceAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/salience/model.jar"), new String[0]);
            if (this.evalType == EVAL_SYSTEM.MENTION_PAIR) {
                aggregateBuilder.add(EventCoreferenceAnnotator.createDataWriterDescription(LibLinearStringOutcomeDataWriter.class, directory, this.params.probabilityOfKeepingANegativeExample), new String[0]);
            } else if (this.evalType == EVAL_SYSTEM.MENTION_CLUSTER) {
                AnalysisEngineDescription aed = AnalysisEngineFactory.createEngineDescription(MentionClusterCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", true, "ProbabilityOfKeepingANegativeExample", Float.valueOf(this.params.probabilityOfKeepingANegativeExample), "dataWriterClassName", LibLinearStringOutcomeDataWriter.class, "outputDirectory", directory});
                aggregateBuilder.add(aed, new String[0]);
                for (int i = 0; i < 0; ++i) {
                    aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveAllCoreferenceAnnotations.class, (Object[])new Object[0]), new String[0]);
                    aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyCoreferenceRelations.class, (Object[])new Object[]{"GoldViewName", "GoldView", "Dropout", true}), new String[0]);
                    aed = AnalysisEngineFactory.createEngineDescription(MentionClusterCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", true, "ProbabilityOfKeepingANegativeExample", Float.valueOf(this.params.probabilityOfKeepingANegativeExample), "UseExistingEncoders", true, "dataWriterClassName", LibLinearStringOutcomeDataWriter.class, "outputDirectory", directory});
                    aggregateBuilder.add(aed, new String[0]);
                }
            } else if (this.evalType == EVAL_SYSTEM.CLUSTER_RANK) {
                aggregateBuilder.add(MentionClusterRankingCoreferenceAnnotator.createDataWriterDescription(SvmLightRankDataWriter.class, directory, this.params.probabilityOfKeepingANegativeExample), new String[0]);
            } else {
                logger.warn((Object)("Encountered a training configuration taht does not add an annotator: " + (Object)((Object)this.evalType)));
            }
            Logger.getLogger(EventCoreferenceAnnotator.class).setLevel(Level.WARN);
            FlowControllerDescription corefFlowControl = FlowControllerFactory.createFlowControllerDescription(CorefEvalFlowController.class, (Object[])new Object[0]);
            aggregateBuilder.setFlowControllerDescription(corefFlowControl);
            SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        }
        if (this.kernelParams == null) {
            ArrayList<String> svmOptions = new ArrayList<String>();
            svmOptions.add("-c");
            svmOptions.add("" + this.params.svmCost);
            svmOptions.add("-t");
            svmOptions.add("" + this.params.svmKernelIndex);
            svmOptions.add("-d");
            svmOptions.add("3");
            svmOptions.add("-g");
            svmOptions.add("" + this.params.svmGamma);
            if (this.params.svmKernelIndex == EvaluationOfEventTimeRelations.ParameterSettings.SVM_KERNELS.indexOf("tk")) {
                svmOptions.add("-S");
                svmOptions.add("" + this.params.secondKernelIndex);
                String comboFlag = this.params.comboOperator == CompositeKernel.ComboOperator.SUM ? "+" : (this.params.comboOperator == CompositeKernel.ComboOperator.PRODUCT ? "*" : (this.params.comboOperator == CompositeKernel.ComboOperator.TREE_ONLY ? "T" : "V"));
                svmOptions.add("-C");
                svmOptions.add(comboFlag);
                svmOptions.add("-L");
                svmOptions.add("" + this.params.lambda);
                svmOptions.add("-T");
                svmOptions.add("" + this.params.tkWeight);
                svmOptions.add("-N");
                svmOptions.add("3");
            }
            optArray = svmOptions.toArray(new String[0]);
        } else {
            optArray = this.kernelParams;
        }
        JarClassifierBuilder.trainAndPackage((File)directory, (String[])optArray);
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AnnotationStatistics corefStats = new AnnotationStatistics();
        if (this.skipTest) {
            logger.info((Object)"Skipping test");
            return corefStats;
        }
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DocumentIDPrinter.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(UncertaintyCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(GenericCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(HistoryCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(SubjectCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ParagraphAnnotator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RelationPropagator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(BackwardsTimeAnnotator.createAnnotatorDescription((String)"/org/apache/ctakes/temporal/ae/timeannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventAnnotator.createAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription((String)"/org/apache/ctakes/temporal/ae/doctimerel/model.jar"), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CoreferenceChainScoringOutput.class, (Object[])new Object[]{"OutputDirectory", this.outputDirectory + goldOut, "GoldViewName", "GoldView"}), new String[0]);
        if (this.goldMarkables) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CopyGoldMarkablesInChains.class, (Object[])new Object[0]), new String[0]);
        } else {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(DeterministicMarkableAnnotator.class, (Object[])new Object[0]), new String[0]);
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemovePersonMarkables.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(MarkableHeadTreeCreator.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(MarkableSalienceAnnotator.createAnnotatorDescription("/org/apache/ctakes/temporal/ae/salience/model.jar"), new String[0]);
        if (this.evalType == EVAL_SYSTEM.MENTION_PAIR) {
            aggregateBuilder.add(EventCoreferenceAnnotator.createAnnotatorDescription(directory.getAbsolutePath() + File.separator + "model.jar"), new String[0]);
        } else if (this.evalType == EVAL_SYSTEM.MENTION_CLUSTER) {
            aggregateBuilder.add(MentionClusterCoreferenceAnnotator.createAnnotatorDescription(directory.getAbsolutePath() + File.separator + "model.jar"), new String[0]);
        } else if (this.evalType == EVAL_SYSTEM.CLUSTER_RANK) {
            aggregateBuilder.add(MentionClusterRankingCoreferenceAnnotator.createAnnotatorDescription(directory.getAbsolutePath() + File.separator + "model.jar"), new String[0]);
        } else if (this.evalType == EVAL_SYSTEM.BASELINE) {
            aggregateBuilder.add(CoreferenceAnnotatorFactory.getLegacyCoreferencePipeline(), new String[0]);
        } else {
            logger.info((Object)("Running an evaluation that does not add an annotator: " + (Object)((Object)this.evalType)));
        }
        if (!this.goldMarkables) {
            aggregateBuilder.add(PersonChainAnnotator.createAnnotatorDescription(), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(CoreferenceChainScoringOutput.class, (Object[])new Object[]{"OutputDirectory", this.outputDirectory + systemOut}), new String[0]);
        FlowControllerDescription corefFlowControl = FlowControllerFactory.createFlowControllerDescription(CorefEvalFlowController.class, (Object[])new Object[0]);
        aggregateBuilder.setFlowControllerDescription(corefFlowControl);
        Function<CoreferenceRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<CoreferenceRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(CoreferenceRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation);
            }
        };
        Function<CoreferenceRelation, String> getOutcome = new Function<CoreferenceRelation, String>(){

            public String apply(CoreferenceRelation relation) {
                return "Coreference";
            }
        };
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            Object relation2;
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldRelations = JCasUtil.select((JCas)goldView, CoreferenceRelation.class);
            Collection systemRelations = JCasUtil.select((JCas)systemView, CoreferenceRelation.class);
            corefStats.add(goldRelations, systemRelations, (Function)getSpan, (Function)getOutcome);
            if (!this.printErrors) continue;
            HashMap goldMap = Maps.newHashMap();
            for (Object relation2 : goldRelations) {
                goldMap.put(new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation2), relation2);
            }
            HashMap systemMap = Maps.newHashMap();
            relation2 = systemRelations.iterator();
            while (relation2.hasNext()) {
                BinaryTextRelation relation3 = (BinaryTextRelation)relation2.next();
                systemMap.put(new RelationExtractorEvaluation.HashableArguments(relation3), relation3);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
            for (RelationExtractorEvaluation.HashableArguments key : sorted) {
                BinaryTextRelation goldRelation = (BinaryTextRelation)goldMap.get(key);
                BinaryTextRelation systemRelation = (BinaryTextRelation)systemMap.get(key);
                if (goldRelation == null) {
                    System.out.println("System added: " + EvaluationOfEventCoreference.formatRelation((BinaryTextRelation)systemRelation));
                    continue;
                }
                if (systemRelation == null) {
                    System.out.println("System dropped: " + EvaluationOfEventCoreference.formatRelation((BinaryTextRelation)goldRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) {
                    String label = systemRelation.getCategory();
                    System.out.printf("System labeled %s for %s\n", label, EvaluationOfEventCoreference.formatRelation((BinaryTextRelation)goldRelation));
                    continue;
                }
                System.out.println("Nailed it! " + EvaluationOfEventCoreference.formatRelation((BinaryTextRelation)systemRelation));
            }
        }
        return corefStats;
    }

    public static class CorefEvalFlowController
    extends JCasFlowController_ImplBase {
        List<String> mSequence;

        public void initialize(FlowControllerContext context) throws ResourceInitializationException {
            super.initialize(context);
            FlowConstraints flowConstraints = context.getAggregateMetadata().getFlowConstraints();
            this.mSequence = new ArrayList<String>();
            if (!(flowConstraints instanceof FixedFlow)) {
                throw new ResourceInitializationException("flow_controller_requires_flow_constraints", new Object[]{((Object)((Object)this)).getClass().getName(), "fixedFlow", context.getAggregateMetadata().getSourceUrlString()});
            }
            String[] sequence = ((FixedFlow)flowConstraints).getFixedFlow();
            this.mSequence.addAll(Arrays.asList(sequence));
        }

        public Flow computeFlow(JCas jcas) throws AnalysisEngineProcessException {
            return new CorefEvalFlow(jcas, 0);
        }

        class CorefEvalFlow
        extends JCasFlow_ImplBase {
            private JCas jcas;
            private int currentStep;

            public CorefEvalFlow(JCas jcas, int step) {
                this.jcas = jcas;
                this.currentStep = step;
            }

            public Step next() {
                if (this.currentStep >= CorefEvalFlowController.this.mSequence.size()) {
                    return new FinalStep();
                }
                if (this.currentStep > 0 && CorefEvalFlowController.this.mSequence.get(this.currentStep - 1).equals(DocumentIDPrinter.class.getName())) {
                    try {
                        JCas goldView = this.jcas.getView("GoldView");
                        if (JCasUtil.select((JCas)goldView, CoreferenceRelation.class).size() == 0) {
                            System.out.println("Skipping this document with no coreference relations.");
                            return new FinalStep();
                        }
                    }
                    catch (CASException e) {
                        e.printStackTrace();
                    }
                }
                return new SimpleStep(CorefEvalFlowController.this.mSequence.get(this.currentStep++));
            }
        }
    }

    public static class RemovePersonMarkables
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            ArrayList<Markable> toRemove = new ArrayList<Markable>();
            for (Markable markable : JCasUtil.select((JCas)jcas, Markable.class)) {
                List coveredTokens;
                if (markable.getCoveredText().equals("I")) {
                    System.err.println("Unauthorized markable 'I'");
                }
                if ((coveredTokens = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)markable)).size() == 1 && ((BaseToken)coveredTokens.get(0)).getPartOfSpeech() != null && ((BaseToken)coveredTokens.get(0)).getPartOfSpeech().startsWith("PRP") && !markable.getCoveredText().toLowerCase().equals("it")) {
                    toRemove.add(markable);
                    continue;
                }
                if (coveredTokens.size() > 0 && (((BaseToken)coveredTokens.get(0)).getCoveredText().startsWith("Mr.") || ((BaseToken)coveredTokens.get(0)).getCoveredText().startsWith("Dr.") || ((BaseToken)coveredTokens.get(0)).getCoveredText().startsWith("Mrs.") || ((BaseToken)coveredTokens.get(0)).getCoveredText().startsWith("Ms."))) {
                    toRemove.add(markable);
                    continue;
                }
                if (!markable.getCoveredText().toLowerCase().endsWith("patient") && !markable.getCoveredText().toLowerCase().equals("pt")) continue;
                toRemove.add(markable);
            }
            for (Markable markable : toRemove) {
                markable.removeFromIndexes();
            }
        }
    }

    public static class RemoveAllCoreferenceAnnotations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            ArrayList chains = new ArrayList(JCasUtil.select((JCas)jcas, CollectionTextRelation.class));
            for (CollectionTextRelation chain : chains) {
                NonEmptyFSList head = null;
                FSList nextHead = chain.getMembers();
                do {
                    head = (NonEmptyFSList)nextHead;
                    head.removeFromIndexes();
                } while ((nextHead = head.getTail()) instanceof NonEmptyFSList);
                chain.removeFromIndexes();
            }
            ArrayList rels = new ArrayList(JCasUtil.select((JCas)jcas, CoreferenceRelation.class));
            for (CoreferenceRelation rel : rels) {
                rel.getArg1().removeFromIndexes();
                rel.getArg2().removeFromIndexes();
                rel.removeFromIndexes();
            }
        }
    }

    @PipeBitInfo(name="Coreference Copier", description="Sets Modality based upon context.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
    public static class CopyCoreferenceRelations
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_GOLD_VIEW = "GoldViewName";
        @ConfigurationParameter(name="GoldViewName", mandatory=true, description="View containing gold standard annotations")
        private String goldViewName;
        public static final String PARAM_DROP_ELEMENTS = "Dropout";
        @ConfigurationParameter(name="Dropout", mandatory=false)
        private boolean dropout = false;

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            JCas goldView = null;
            try {
                goldView = jcas.getView(this.goldViewName);
            }
            catch (CASException e) {
                e.printStackTrace();
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<Markable, Markable> gold2sys = new HashMap<Markable, Markable>();
            Map depIndex = JCasUtil.indexCovering((JCas)jcas, ConllDependencyNode.class, Markable.class);
            ArrayList toRemove = new ArrayList();
            for (CollectionTextRelation goldChain : JCasUtil.select((JCas)goldView, CollectionTextRelation.class)) {
                NonEmptyFSList element;
                FSList head = goldChain.getMembers();
                ArrayList systemLists = new ArrayList();
                boolean removeChain = false;
                Object prevList = null;
                do {
                    boolean mapped;
                    Markable markable;
                    if ((markable = (Markable)(element = (NonEmptyFSList)head).getHead()) == null) {
                        logger.error((Object)String.format("Found an unexpected null gold markable", new Object[0]));
                    }
                    if (!(mapped = CopyCoreferenceRelations.mapGoldMarkable(jcas, markable, gold2sys, depIndex))) {
                        String text = "<Out of bounds>";
                        if (markable.getBegin() >= 0 && markable.getEnd() < jcas.getDocumentText().length()) {
                            text = markable.getCoveredText();
                        }
                        logger.warn((Object)String.format("There is a gold markable %s [%d, %d] which could not map to a system markable.", text, markable.getBegin(), markable.getEnd()));
                        removeChain = true;
                        break;
                    }
                    Markable sysMarkable = gold2sys.get(markable);
                    if (!this.dropout || systemLists.size() == 0) {
                        if (systemLists.size() == 0) {
                            systemLists.add(new ArrayList());
                        }
                        ((List)systemLists.get(0)).add(sysMarkable);
                        continue;
                    }
                    if (Math.random() > 0.1) {
                        ((List)systemLists.get(0)).add(sysMarkable);
                        continue;
                    }
                    int listIndex = (int)Math.ceil(Math.random() * (double)systemLists.size());
                    if (listIndex == systemLists.size()) {
                        systemLists.add(new ArrayList());
                    }
                    ((List)systemLists.get(listIndex)).add(sysMarkable);
                } while ((head = element.getTail()) instanceof NonEmptyFSList);
                if (removeChain) continue;
                for (List list : systemLists) {
                    if (list.size() <= 1) continue;
                    CollectionTextRelation sysRel = new CollectionTextRelation(jcas);
                    sysRel.setMembers(ListFactory.buildList((JCas)jcas, (List)list));
                    sysRel.addToIndexes();
                }
            }
            for (CoreferenceRelation goldRel : JCasUtil.select((JCas)goldView, CoreferenceRelation.class)) {
                if (!gold2sys.containsKey(goldRel.getArg1().getArgument()) || !gold2sys.containsKey(goldRel.getArg2().getArgument())) continue;
                CoreferenceRelation sysRel = new CoreferenceRelation(jcas);
                sysRel.setCategory(goldRel.getCategory());
                sysRel.setDiscoveryTechnique(1);
                RelationArgument arg1 = new RelationArgument(jcas);
                arg1.setArgument((Annotation)gold2sys.get(goldRel.getArg1().getArgument()));
                sysRel.setArg1(arg1);
                arg1.addToIndexes();
                RelationArgument arg2 = new RelationArgument(jcas);
                arg2.setArgument((Annotation)gold2sys.get(goldRel.getArg2().getArgument()));
                sysRel.setArg2(arg2);
                arg2.addToIndexes();
                sysRel.addToIndexes();
            }
        }

        private static boolean mapGoldMarkable(JCas jcas, Markable goldMarkable, Map<Markable, Markable> gold2sys, Map<ConllDependencyNode, Collection<Markable>> depIndex) {
            if (goldMarkable.getBegin() >= 0 && goldMarkable.getEnd() < jcas.getDocumentText().length()) {
                ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)goldMarkable);
                for (Markable sysMarkable : depIndex.get(headNode)) {
                    ConllDependencyNode markNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)sysMarkable);
                    if (markNode != headNode) continue;
                    gold2sys.put(goldMarkable, sysMarkable);
                    return true;
                }
            } else {
                logger.warn((Object)String.format("There is a markable with span [%d, %d] in a document with length %d\n", goldMarkable.getBegin(), goldMarkable.getEnd(), jcas.getDocumentText().length()));
                return false;
            }
            return false;
        }
    }

    public static class ParagraphVectorAnnotator
    extends JCasAnnotator_ImplBase {
        WordEmbeddings words = null;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            try {
                this.words = WordVectorReader.getEmbeddings((InputStream)FileLocator.getAsStream((String)"org/apache/ctakes/coreference/distsem/mimic_vectors.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ResourceInitializationException((Throwable)e);
            }
        }

        public void process(JCas jcas) throws AnalysisEngineProcessException {
            ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
            FSArray parVecs = new FSArray(jcas, pars.size());
            for (int parNum = 0; parNum < pars.size(); ++parNum) {
                Paragraph par = (Paragraph)pars.get(parNum);
                float[] parVec = new float[this.words.getDimensionality()];
                List tokens = JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)par);
                for (int i = 0; i < tokens.size(); ++i) {
                    String word;
                    BaseToken token = (BaseToken)tokens.get(i);
                    if (!(token instanceof WordToken) || !this.words.containsKey(word = token.getCoveredText().toLowerCase())) continue;
                    WordVector wv = this.words.getVector(word);
                    for (int j = 0; j < parVec.length; ++j) {
                        int n = j;
                        parVec[n] = (float)((double)parVec[n] + wv.getValue(j));
                    }
                }
                ParagraphVectorAnnotator.normalize(parVec);
                FloatArray vec = new FloatArray(jcas, this.words.getDimensionality());
                vec.copyFromArray(parVec, 0, 0, parVec.length);
                vec.addToIndexes();
                parVecs.set(parNum, (FeatureStructure)vec);
            }
            parVecs.addToIndexes();
        }

        private static final void normalize(float[] vec) {
            int i;
            double sum = 0.0;
            for (i = 0; i < vec.length; ++i) {
                sum += (double)(vec[i] * vec[i]);
            }
            sum = Math.sqrt(sum);
            i = 0;
            while (i < vec.length) {
                int n = i++;
                vec[n] = (float)((double)vec[n] / sum);
            }
        }
    }

    public static class ParagraphAnnotator
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            ArrayList tokens = new ArrayList(JCasUtil.select((JCas)jcas, BaseToken.class));
            BaseToken lastToken = null;
            int parStart = 0;
            for (int i = 0; i < tokens.size(); ++i) {
                BaseToken token = (BaseToken)tokens.get(i);
                if (parStart == i && token instanceof NewlineToken) {
                    ++parStart;
                } else if (lastToken != null && token instanceof NewlineToken) {
                    Paragraph par = new Paragraph(jcas, ((BaseToken)tokens.get(parStart)).getBegin(), lastToken.getEnd());
                    par.addToIndexes();
                    parStart = i + 1;
                }
                lastToken = token;
            }
        }
    }

    public static class RelationPropagator
    extends JCasAnnotator_ImplBase {
        public void process(JCas jcas) throws AnalysisEngineProcessException {
            for (LocationOfTextRelation locRel : JCasUtil.select((JCas)jcas, LocationOfTextRelation.class)) {
                int newSize;
                int oldSize;
                Annotation a;
                IdentifiedAnnotation arg1 = (IdentifiedAnnotation)locRel.getArg1().getArgument();
                IdentifiedAnnotation arg2 = (IdentifiedAnnotation)locRel.getArg2().getArgument();
                if (arg1 instanceof ProcedureMention) {
                    ProcedureMention p = (ProcedureMention)arg1;
                    if (p.getBodyLocation() == null) {
                        p.setBodyLocation(locRel);
                        continue;
                    }
                    a = p.getBodyLocation().getArg2().getArgument();
                    oldSize = a.getEnd() - a.getBegin();
                    newSize = arg2.getEnd() - arg2.getEnd();
                    if (newSize <= oldSize) continue;
                    p.setBodyLocation(locRel);
                    continue;
                }
                if (arg1 instanceof DiseaseDisorderMention) {
                    DiseaseDisorderMention d = (DiseaseDisorderMention)arg1;
                    if (d.getBodyLocation() == null) {
                        d.setBodyLocation(locRel);
                        continue;
                    }
                    a = d.getBodyLocation().getArg2().getArgument();
                    oldSize = a.getEnd() - a.getBegin();
                    newSize = arg2.getEnd() - arg2.getEnd();
                    if (newSize <= oldSize) continue;
                    d.setBodyLocation(locRel);
                    continue;
                }
                if (!(arg1 instanceof SignSymptomMention)) continue;
                SignSymptomMention s = (SignSymptomMention)arg1;
                if (s.getBodyLocation() == null) {
                    s.setBodyLocation(locRel);
                    continue;
                }
                a = s.getBodyLocation().getArg2().getArgument();
                oldSize = a.getEnd() - a.getBegin();
                newSize = arg2.getEnd() - arg2.getEnd();
                if (newSize <= oldSize) continue;
                s.setBodyLocation(locRel);
            }
        }
    }

    @PipeBitInfo(name="Gold Markables Copier", description="Copies Markables from the Gold view to the System view.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.MARKABLE})
    public static class CopyGoldMarkablesInChains
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Markable annotation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)systemView, Markable.class))) {
                annotation.removeFromIndexes();
            }
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa");
            HashSet<String> existingSpans = new HashSet<String>();
            for (CollectionTextRelation chain : JCasUtil.select((JCas)goldView, CollectionTextRelation.class)) {
                for (Markable markable : JCasUtil.select((FSList)chain.getMembers(), Markable.class)) {
                    String key = markable.getBegin() + "-" + (markable.getEnd() - markable.getBegin());
                    if (existingSpans.contains(key)) continue;
                    Markable copy = (Markable)copier.copyFs((FeatureStructure)markable);
                    copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                    copy.addToIndexes(systemView);
                    existingSpans.add(key);
                }
            }
        }
    }

    public static class DocumentIDPrinter
    extends JCasAnnotator_ImplBase {
        static Logger logger = Logger.getLogger(DocumentIDPrinter.class);

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
            if (docId == "UnknownDocument") {
                docId = new File(ViewUriUtil.getURI((JCas)jCas)).getName();
            }
            logger.info((Object)String.format("Processing %s\n", docId));
        }
    }

    public static class AnnotationComparator
    implements Comparator<Annotation> {
        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (o1.getBegin() < o2.getBegin()) {
                return -1;
            }
            if (o1.getBegin() == o2.getBegin() && o1.getEnd() < o2.getEnd()) {
                return -1;
            }
            if (o1.getBegin() == o2.getBegin() && o1.getEnd() > o2.getEnd()) {
                return 1;
            }
            if (o2.getBegin() < o1.getBegin()) {
                return 1;
            }
            return 0;
        }
    }

    public static enum EVAL_SYSTEM {
        BASELINE,
        MENTION_PAIR,
        MENTION_CLUSTER,
        CLUSTER_RANK,
        PERSON_ONLY;

    }

    static interface CoreferenceOptions
    extends EvaluationOfTemporalRelations_ImplBase.TempRelOptions {
        @Option
        public String getOutputDirectory();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getTestOnTrain();

        @Option(longName={"external"})
        public boolean getUseExternalScorer();

        @Option(shortName={"t"}, defaultValue={"MENTION_CLUSTER"})
        public EVAL_SYSTEM getEvalSystem();

        @Option(shortName={"c"}, defaultValue={"default"})
        public String getConfig();

        @Option(shortName={"s"})
        public String getScorerPath();

        @Option
        public boolean getGoldMarkables();

        @Option
        public boolean getSkipTest();
    }
}

