/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.CasIOUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;

@Beta
public class XmiWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY = "outputDirectory";
    @ConfigurationParameter(name="outputDirectory")
    protected File outputDirectory;

    public static AnalysisEngineDescription getDescription(File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{PARAM_OUTPUT_DIRECTORY, outputDirectory});
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            File xmiFile = this.getXmiFile(jCas);
            CasIOUtil.writeXmi((JCas)jCas, (File)xmiFile);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected File getXmiFile(JCas jCas) throws AnalysisEngineProcessException {
        return new File(this.outputDirectory, ViewUriUtil.getURI(jCas).getFragment() + ".xmi");
    }
}

