/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight.rank;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.svmlight.SvmLightClassifierBuilder_ImplBase;
import org.cleartk.ml.svmlight.rank.SvmLightRank;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightRankBuilder
extends SvmLightClassifierBuilder_ImplBase<SvmLightRank, Double, Double> {
    static Logger logger = UIMAFramework.getLogger(SvmLightClassifierBuilder_ImplBase.class);

    @Override
    public void trainClassifier(File dir, String ... args) throws Exception {
        File trainingDataFile = this.getTrainingDataFile(dir);
        this.trainClassifier(dir, trainingDataFile, args);
    }

    @Override
    public void trainClassifier(File dir, File trainingDataFile, String ... args) throws Exception {
        String executable = "svm_rank_learn";
        if (args.length > 0 && args[0].equals(COMMAND_ARGUMENT)) {
            executable = args[1];
            String[] tempArgs = new String[args.length - 2];
            System.arraycopy(args, 2, tempArgs, 0, tempArgs.length);
            args = tempArgs;
        }
        Object[] command = new String[args.length + 3];
        command[0] = executable;
        System.arraycopy(args, 0, command, 1, args.length);
        command[command.length - 2] = trainingDataFile.getPath();
        command[command.length - 1] = trainingDataFile.getPath() + ".model";
        logger.log(Level.FINE, "training svmlight rank using the following command: " + Joiner.on((String)" ").join(command));
        Process process = Runtime.getRuntime().exec((String[])command);
        process.getOutputStream().close();
        SvmLightRankBuilder.output(process.getInputStream(), System.out);
        SvmLightRankBuilder.output(process.getErrorStream(), System.err);
        process.waitFor();
    }

    protected SvmLightRank newClassifier() {
        return new SvmLightRank((FeaturesEncoder<FeatureVector>)this.featuresEncoder, (OutcomeEncoder<Double, Double>)this.outcomeEncoder, this.model);
    }

    private static void output(InputStream input, PrintStream output) throws IOException {
        byte[] buffer = new byte[128];
        int count = input.read(buffer);
        while (count != -1) {
            output.write(buffer, 0, count);
            count = input.read(buffer);
        }
    }
}

