/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.io.File;
import java.util.Arrays;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.UimaContextFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.corpus.timeml.TempEval2007Writer;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.PosTaggerAnnotator;
import org.cleartk.opennlp.tools.SentenceAnnotator;
import org.cleartk.snowball.DefaultSnowballStemmer;
import org.cleartk.timeml.tlink.VerbClauseTemporalAnnotator;
import org.cleartk.token.tokenizer.TokenAnnotator;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class VerbClauseTemporalAnnotate {
    private static void error(String message) throws Exception {
        Logger logger = UimaContextFactory.createUimaContext((Object[])new Object[0]).getLogger();
        logger.log(Level.SEVERE, String.format("%s\nusage: VerbClauseTemporalAnnotate input-file-or-dir [output-dir]", message));
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1 && args.length != 2) {
            VerbClauseTemporalAnnotate.error("wrong number of arguments");
        } else if (!new File(args[0]).exists()) {
            VerbClauseTemporalAnnotate.error("file or directory not found: " + args[0]);
        }
        File inputFileOrDir = new File(args[0]);
        File outputDir = args.length == 2 ? new File(args[1]) : new File(".");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        CollectionReader uriReader = inputFileOrDir.isDirectory() ? UriCollectionReader.getCollectionReaderFromDirectory((File)inputFileOrDir) : UriCollectionReader.getCollectionReaderFromFiles(Arrays.asList(inputFileOrDir));
        SimplePipeline.runPipeline((CollectionReader)uriReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{UriToDocumentTextAnnotator.getDescription(), SentenceAnnotator.getDescription(), TokenAnnotator.getDescription(), PosTaggerAnnotator.getDescription(), DefaultSnowballStemmer.getDescription((String)"English"), ParserAnnotator.getDescription(), VerbClauseTemporalAnnotator.FACTORY.getAnnotatorDescription(), TempEval2007Writer.getDescription((String)outputDir.getPath())});
    }
}

