/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IHasLifecycle;
import edu.mit.jwi.data.ILoadableDataSource;
import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.Version;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class WordnetFile<T>
implements ILoadableDataSource<T> {
    private final String name;
    private final IContentType<T> type;
    private final ICommentDetector detector;
    private final File file;
    private transient boolean isLoaded = false;
    private final Lock lifecycleLock = new ReentrantLock();
    private final Lock loadingLock = new ReentrantLock();
    private FileChannel channel;
    private ByteBuffer buffer;
    private IVersion version;

    public WordnetFile(File file, IContentType<T> contentType) {
        if (contentType == null) {
            throw new NullPointerException();
        }
        this.name = file.getName();
        this.file = file;
        this.type = contentType;
        this.detector = this.type.getLineComparator().getCommentDetector();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public ByteBuffer getBuffer() {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
        return this.buffer;
    }

    @Override
    public IContentType<T> getContentType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        try {
            this.lifecycleLock.lock();
            if (this.isOpen()) {
                boolean bl = true;
                return bl;
            }
            RandomAccessFile raFile = new RandomAccessFile(this.file, "r");
            this.channel = raFile.getChannel();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        try {
            this.lifecycleLock.lock();
            boolean bl = this.buffer != null;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.lifecycleLock.lock();
            this.version = null;
            this.buffer = null;
            this.isLoaded = false;
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.channel = null;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void load() {
        this.load(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean block) {
        try {
            this.loadingLock.lock();
            int len = (int)this.file.length();
            ByteBuffer buf = this.buffer.asReadOnlyBuffer();
            buf.clear();
            byte[] data = new byte[len];
            buf.get(data, 0, len);
            try {
                this.lifecycleLock.lock();
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.channel = null;
                }
                if (this.buffer != null) {
                    this.buffer = ByteBuffer.wrap(data);
                    this.isLoaded = true;
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
        finally {
            this.loadingLock.unlock();
        }
    }

    @Override
    public IVersion getVersion() {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
        if (this.version == null) {
            this.version = Version.extractVersion(this.type, this.buffer.asReadOnlyBuffer());
            if (this.version == null) {
                this.version = IVersion.NO_VERSION;
            }
        }
        return this.version == IVersion.NO_VERSION ? null : this.version;
    }

    public LineIterator iterator() {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
        return this.makeIterator(this.getBuffer(), null);
    }

    public LineIterator iterator(String key) {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
        return this.makeIterator(this.getBuffer(), key);
    }

    public abstract LineIterator makeIterator(ByteBuffer var1, String var2);

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.file.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WordnetFile other = (WordnetFile)obj;
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.file.equals(other.file);
    }

    public static String getLine(ByteBuffer buf) {
        StringBuilder input = new StringBuilder();
        boolean eol = false;
        int limit = buf.limit();
        if (buf.position() == limit) {
            return null;
        }
        block4: while (!eol && buf.position() < limit) {
            char c = (char)buf.get();
            switch (c) {
                case '\n': {
                    eol = true;
                    continue block4;
                }
                case '\r': {
                    eol = true;
                    int cur = buf.position();
                    c = (char)buf.get();
                    if (c == '\n') continue block4;
                    buf.position(cur);
                    continue block4;
                }
            }
            input.append(c);
        }
        return input.toString();
    }

    public static void rewindToLineStart(ByteBuffer buf) {
        int i = buf.position();
        if (buf.get(i - 1) == 13 && buf.get(i) == 10) {
            --i;
        }
        if (i > 0) {
            --i;
        }
        while (i > 0) {
            char c = (char)buf.get(i);
            if (c == '\n' || c == '\r') {
                ++i;
                break;
            }
            --i;
        }
        buf.position(i);
    }

    protected abstract class LineIterator
    implements Iterator<String> {
        protected final ByteBuffer parentBuffer;
        protected ByteBuffer itrBuffer;
        protected String next;

        public LineIterator(ByteBuffer buffer, String key) {
            this.parentBuffer = buffer;
            this.itrBuffer = buffer.asReadOnlyBuffer();
            this.itrBuffer.clear();
            String string = key = key == null ? null : key.trim();
            if (key == null || key.length() == 0) {
                this.advance();
            } else {
                this.findFirstLine(key);
            }
        }

        public String getNextLine() {
            return this.next;
        }

        protected abstract void findFirstLine(String var1);

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected void advance() {
            String line;
            this.next = null;
            if (this.parentBuffer != WordnetFile.this.buffer) {
                int pos = this.itrBuffer.position();
                ByteBuffer newBuf = WordnetFile.this.buffer.asReadOnlyBuffer();
                newBuf.clear();
                newBuf.position(pos);
                this.itrBuffer = newBuf;
            }
            while ((line = WordnetFile.getLine(this.itrBuffer)) != null && this.isComment(line)) {
            }
            this.next = line;
        }

        protected boolean isComment(String line) {
            if (WordnetFile.this.detector == null) {
                return false;
            }
            return WordnetFile.this.detector.isCommentLine(line);
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String result = this.next;
            this.advance();
            return result;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

