/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi;

import edu.mit.jwi.IDataSourceDictionary;
import edu.mit.jwi.data.ContentType;
import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataProvider;
import edu.mit.jwi.data.IDataSource;
import edu.mit.jwi.data.IHasLifecycle;
import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.ExceptionEntry;
import edu.mit.jwi.item.ExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntryProxy;
import edu.mit.jwi.item.IHasPOS;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import java.io.IOException;
import java.util.Iterator;

public class DataSourceDictionary
implements IDataSourceDictionary {
    private final IDataProvider provider;

    public DataSourceDictionary(IDataProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    @Override
    public IDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public IVersion getVersion() {
        this.checkOpen();
        return this.provider.getVersion();
    }

    @Override
    public boolean open() throws IOException {
        return this.provider.open();
    }

    @Override
    public void close() {
        this.provider.close();
    }

    @Override
    public boolean isOpen() {
        return this.provider.isOpen();
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new IHasLifecycle.ObjectClosedException();
        }
    }

    @Override
    public IIndexWord getIndexWord(String lemma, POS pos) {
        this.checkOpen();
        return this.getIndexWord(new IndexWordID(lemma, pos));
    }

    @Override
    public IIndexWord getIndexWord(IIndexWordID id) {
        this.checkOpen();
        IContentType<IIndexWord> content = this.resolveIndexContentType(id.getPOS());
        IDataSource<IIndexWord> file = this.provider.getSource(content);
        String line = file.getLine(id.getLemma());
        if (line == null) {
            return null;
        }
        return content.getDataType().getParser().parseLine(line);
    }

    @Override
    public IWord getWord(IWordID id) {
        this.checkOpen();
        ISynset synset = this.getSynset(id.getSynsetID());
        if (synset == null) {
            return null;
        }
        if (id.getWordNumber() > 0) {
            return synset.getWords().get(id.getWordNumber() - 1);
        }
        if (id.getLemma() != null) {
            for (IWord word : synset.getWords()) {
                if (!word.getLemma().equalsIgnoreCase(id.getLemma())) continue;
                return word;
            }
            return null;
        }
        throw new IllegalArgumentException("Not enough information in IWordID instance to retrieve word.");
    }

    @Override
    public IWord getWord(ISenseKey key) {
        ISynset synset;
        this.checkOpen();
        ISenseEntry entry = this.getSenseEntry(key);
        if (entry != null && (synset = this.getSynset(new SynsetID(entry.getOffset(), entry.getPOS()))) != null) {
            for (IWord synonym : synset.getWords()) {
                if (!synonym.getSenseKey().equals(key)) continue;
                return synonym;
            }
        }
        IWord word = null;
        IIndexWord indexWord = this.getIndexWord(key.getLemma(), key.getPOS());
        if (indexWord != null) {
            for (IWordID wordID : indexWord.getWordIDs()) {
                IWord possibleWord = this.getWord(wordID);
                if (possibleWord == null) continue;
                for (IWord synonym : possibleWord.getSynset().getWords()) {
                    if (!synonym.getSenseKey().equals(key)) continue;
                    word = synonym;
                    if (!synonym.getLemma().equals(key.getLemma())) continue;
                    return synonym;
                }
            }
        }
        return word;
    }

    @Override
    public ISenseEntry getSenseEntry(ISenseKey key) {
        this.checkOpen();
        IContentType<ISenseEntry> content = this.resolveSenseContentType();
        IDataSource<ISenseEntry> file = this.provider.getSource(content);
        String line = file.getLine(key.toString());
        if (line == null) {
            return null;
        }
        return content.getDataType().getParser().parseLine(line);
    }

    @Override
    public ISynset getSynset(ISynsetID id) {
        this.checkOpen();
        IContentType<ISynset> content = this.resolveDataContentType(id.getPOS());
        IDataSource<ISynset> file = this.provider.getSource(content);
        String zeroFilledOffset = Synset.zeroFillOffset(id.getOffset());
        String line = file.getLine(zeroFilledOffset);
        if (line == null) {
            return null;
        }
        ISynset result = content.getDataType().getParser().parseLine(line);
        if (result != null) {
            this.setHeadWord(result);
        }
        return result;
    }

    protected void setHeadWord(ISynset synset) {
        boolean isVer16;
        if (!synset.isAdjectiveSatellite()) {
            return;
        }
        IWord headWord = null;
        for (ISynsetID simID : synset.getRelatedSynsets(Pointer.SIMILAR_TO)) {
            ISynset headSynset = this.getSynset(simID);
            if (!headSynset.isAdjectiveHead()) continue;
            headWord = headSynset.getWords().get(0);
            break;
        }
        if (headWord == null) {
            return;
        }
        String headLemma = headWord.getLemma();
        IVersion ver = this.getVersion();
        boolean bl = ver == null ? false : (isVer16 = ver.getMajorVersion() == 1 && ver.getMinorVersion() == 6);
        if (isVer16 && headWord.getAdjectiveMarker() != null) {
            headLemma = headLemma + headWord.getAdjectiveMarker().getSymbol();
        }
        for (IWord word : synset.getWords()) {
            if (!word.getSenseKey().needsHeadSet()) continue;
            word.getSenseKey().setHead(headLemma, headWord.getLexicalID());
        }
    }

    @Override
    public IExceptionEntry getExceptionEntry(String surfaceForm, POS pos) {
        return this.getExceptionEntry(new ExceptionEntryID(surfaceForm, pos));
    }

    @Override
    public IExceptionEntry getExceptionEntry(IExceptionEntryID id) {
        this.checkOpen();
        IContentType<IExceptionEntryProxy> content = this.resolveExceptionContentType(id.getPOS());
        IDataSource<IExceptionEntryProxy> file = this.provider.getSource(content);
        if (file == null) {
            return null;
        }
        String line = file.getLine(id.getSurfaceForm());
        if (line == null) {
            return null;
        }
        IExceptionEntryProxy proxy = content.getDataType().getParser().parseLine(line);
        if (proxy == null) {
            return null;
        }
        return new ExceptionEntry(proxy, id.getPOS());
    }

    protected IContentType<IIndexWord> resolveIndexContentType(POS pos) {
        return ContentType.getIndexContentType(pos);
    }

    protected IContentType<ISynset> resolveDataContentType(POS pos) {
        return ContentType.getDataContentType(pos);
    }

    protected IContentType<IExceptionEntryProxy> resolveExceptionContentType(POS pos) {
        return ContentType.getExceptionContentType(pos);
    }

    protected IContentType<ISenseEntry> resolveSenseContentType() {
        return ContentType.SENSE;
    }

    @Override
    public Iterator<IIndexWord> getIndexWordIterator(POS pos) {
        this.checkOpen();
        return new IndexFileIterator(pos);
    }

    @Override
    public Iterator<ISynset> getSynsetIterator(POS pos) {
        this.checkOpen();
        return new DataFileIterator(pos);
    }

    @Override
    public Iterator<IExceptionEntry> getExceptionEntryIterator(POS pos) {
        this.checkOpen();
        return new ExceptionFileIterator(pos);
    }

    @Override
    public Iterator<ISenseEntry> getSenseEntryIterator() {
        this.checkOpen();
        return new SenseEntryFileIterator();
    }

    public class ExceptionFileIterator
    extends FileIterator<IExceptionEntryProxy, IExceptionEntry> {
        public ExceptionFileIterator(POS pos) {
            super(DataSourceDictionary.this.resolveExceptionContentType(pos));
        }

        @Override
        public IExceptionEntry parseLine(String line) {
            IExceptionEntryProxy proxy = (IExceptionEntryProxy)this.fParser.parseLine(line);
            return proxy == null ? null : new ExceptionEntry(proxy, this.getPOS());
        }
    }

    public class DataFileIterator
    extends FileIterator2<ISynset> {
        public DataFileIterator(POS pos) {
            super(DataSourceDictionary.this.resolveDataContentType(pos));
        }

        @Override
        public ISynset parseLine(String line) {
            if (this.getPOS() == POS.ADJECTIVE) {
                ISynset synset = (ISynset)this.fParser.parseLine(line);
                DataSourceDictionary.this.setHeadWord(synset);
                return synset;
            }
            return (ISynset)this.fParser.parseLine(line);
        }
    }

    public class SenseEntryFileIterator
    extends FileIterator2<ISenseEntry> {
        public SenseEntryFileIterator() {
            super(DataSourceDictionary.this.resolveSenseContentType());
        }

        @Override
        public ISenseEntry parseLine(String line) {
            return (ISenseEntry)this.fParser.parseLine(line);
        }
    }

    public class IndexFileIterator
    extends FileIterator2<IIndexWord> {
        public IndexFileIterator(POS pos) {
            this(pos, "");
        }

        public IndexFileIterator(POS pos, String pattern) {
            super(DataSourceDictionary.this.resolveIndexContentType(pos), pattern);
        }

        @Override
        public IIndexWord parseLine(String line) {
            return (IIndexWord)this.fParser.parseLine(line);
        }
    }

    public abstract class FileIterator2<T>
    extends FileIterator<T, T> {
        public FileIterator2(IContentType<T> content) {
            super(content);
        }

        public FileIterator2(IContentType<T> content, String startKey) {
            super(content, startKey);
        }
    }

    public abstract class FileIterator<T, N>
    implements Iterator<N>,
    IHasPOS {
        protected final IDataSource<T> fFile;
        protected final Iterator<String> iterator;
        protected final ILineParser<T> fParser;
        protected String currentLine;

        public FileIterator(IContentType<T> content) {
            this(content, null);
        }

        public FileIterator(IContentType<T> content, String startKey) {
            this.fFile = DataSourceDictionary.this.provider.getSource(content);
            this.fParser = content.getDataType().getParser();
            this.iterator = this.fFile.iterator(startKey);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }

        @Override
        public POS getPOS() {
            return this.fFile.getContentType().getPOS();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public N next() {
            this.currentLine = this.iterator.next();
            return this.parseLine(this.currentLine);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public abstract N parseLine(String var1);
    }
}

