/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.ae;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ctakes.core.fsm.adapters.ContractionTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.DecimalTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.IntegerTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.NewlineTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.PunctuationTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.SymbolTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.WordTokenAdapter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DateParser;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.core.util.ParamUtil;
import org.apache.ctakes.drugner.DrugMention;
import org.apache.ctakes.drugner.fsm.machines.elements.DecimalStrengthFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.DosagesFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.DrugChangeStatusFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.DurationFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.FormFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.FractionStrengthFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.FrequencyFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.FrequencyUnitFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.RangeStrengthFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.RouteFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.StrengthFSM;
import org.apache.ctakes.drugner.fsm.machines.elements.StrengthUnitFSM;
import org.apache.ctakes.drugner.fsm.machines.util.SubSectionIndicatorFSM;
import org.apache.ctakes.drugner.fsm.machines.util.SuffixStrengthFSM;
import org.apache.ctakes.drugner.fsm.output.elements.BaseTokenImpl;
import org.apache.ctakes.drugner.fsm.output.elements.DosageToken;
import org.apache.ctakes.drugner.fsm.output.elements.DrugChangeStatusToken;
import org.apache.ctakes.drugner.fsm.output.elements.DurationToken;
import org.apache.ctakes.drugner.fsm.output.elements.FormToken;
import org.apache.ctakes.drugner.fsm.output.elements.FrequencyToken;
import org.apache.ctakes.drugner.fsm.output.elements.FrequencyUnitToken;
import org.apache.ctakes.drugner.fsm.output.elements.RouteToken;
import org.apache.ctakes.drugner.fsm.output.elements.StrengthUnitCombinedToken;
import org.apache.ctakes.drugner.fsm.output.elements.StrengthUnitToken;
import org.apache.ctakes.drugner.fsm.output.util.SubSectionIndicator;
import org.apache.ctakes.drugner.fsm.output.util.SuffixStrengthToken;
import org.apache.ctakes.drugner.type.ChunkAnnotation;
import org.apache.ctakes.drugner.type.DecimalStrengthAnnotation;
import org.apache.ctakes.drugner.type.DosagesAnnotation;
import org.apache.ctakes.drugner.type.DrugChangeStatusAnnotation;
import org.apache.ctakes.drugner.type.DrugMentionAnnotation;
import org.apache.ctakes.drugner.type.DurationAnnotation;
import org.apache.ctakes.drugner.type.FormAnnotation;
import org.apache.ctakes.drugner.type.FractionStrengthAnnotation;
import org.apache.ctakes.drugner.type.FrequencyAnnotation;
import org.apache.ctakes.drugner.type.FrequencyUnitAnnotation;
import org.apache.ctakes.drugner.type.RangeStrengthAnnotation;
import org.apache.ctakes.drugner.type.RouteAnnotation;
import org.apache.ctakes.drugner.type.StrengthAnnotation;
import org.apache.ctakes.drugner.type.StrengthUnitAnnotation;
import org.apache.ctakes.drugner.type.SubSectionAnnotation;
import org.apache.ctakes.drugner.type.SuffixStrengthAnnotation;
import org.apache.ctakes.typesystem.type.refsem.Attribute;
import org.apache.ctakes.typesystem.type.refsem.Date;
import org.apache.ctakes.typesystem.type.refsem.MedicationDosage;
import org.apache.ctakes.typesystem.type.refsem.MedicationDuration;
import org.apache.ctakes.typesystem.type.refsem.MedicationForm;
import org.apache.ctakes.typesystem.type.refsem.MedicationFrequency;
import org.apache.ctakes.typesystem.type.refsem.MedicationRoute;
import org.apache.ctakes.typesystem.type.refsem.MedicationStatusChange;
import org.apache.ctakes.typesystem.type.refsem.MedicationStrength;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.NumToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.DateAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationDosageModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDurationModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFormModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFrequencyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationRouteModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStatusChangeModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStrengthModifier;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Drug Mention Annotator", description="Creates modifier annotations needed to handle the drug mentions.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class DrugMentionAnnotator
extends JCasAnnotator_ImplBase {
    public static Logger iv_logger = Logger.getLogger(DrugMentionAnnotator.class);
    public static final String PARAM_SEGMENTS_MEDICATION_RELATED = "medicationRelatedSection";
    public static String DISTANCE = "DISTANCE";
    public static String DISTANCE_ANN_TYPE = "DISTANCE_ANN_TYPE";
    public static String BOUNDARY_ANN_TYPE = "STATUS_BOUNDARY_ANN_TYPE";
    public static int NO_WINDOW_SIZE_SPECIFIED = -1;
    public static int NO_ANNOTATION_TYPE_SPECIFIED = -1;
    private int iWindowSize = NO_WINDOW_SIZE_SPECIFIED;
    private int iAnnotationType = NO_ANNOTATION_TYPE_SPECIFIED;
    private int iBoundaryAnnType = NO_ANNOTATION_TYPE_SPECIFIED;
    private FractionStrengthFSM iv_fractionFSM;
    private RangeStrengthFSM iv_rangeFSM;
    private SubSectionIndicatorFSM iv_subMedSectionFSM;
    private DosagesFSM iv_dosagesFSM;
    private SuffixStrengthFSM iv_suffixFSM;
    private DurationFSM iv_durationFSM;
    private RouteFSM iv_routeFSM;
    private FrequencyFSM iv_frequencyFSM;
    private DrugChangeStatusFSM iv_statusFSM;
    private DecimalStrengthFSM iv_decimalFSM;
    private StrengthFSM iv_strengthFSM;
    private StrengthUnitFSM iv_strengthUnitFSM;
    private FrequencyUnitFSM iv_frequencyUnitFSM;
    private FormFSM iv_formFSM;
    private static final int NERTypeIdentifier = 1;
    private static boolean handledRanges;
    private Set<String> iv_exclusionTagSet = null;
    private Set<String> iv_medicationRelatedSections = new HashSet<String>();
    private int[] intermediateTypesToRemove = new int[]{FrequencyAnnotation.type, DurationAnnotation.type, RouteAnnotation.type, SuffixStrengthAnnotation.type, FractionStrengthAnnotation.type, RangeStrengthAnnotation.type, DecimalStrengthAnnotation.type, DrugChangeStatusAnnotation.type, DosagesAnnotation.type, StrengthAnnotation.type, StrengthUnitAnnotation.type, FrequencyUnitAnnotation.type, FormAnnotation.type, DrugMentionAnnotation.type, ChunkAnnotation.type};

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        this.iv_medicationRelatedSections = ParamUtil.getStringParameterValuesSet((String)PARAM_SEGMENTS_MEDICATION_RELATED, (UimaContext)annotCtx);
        this.iv_fractionFSM = new FractionStrengthFSM();
        this.iv_suffixFSM = new SuffixStrengthFSM();
        this.iv_durationFSM = new DurationFSM();
        this.iv_routeFSM = new RouteFSM();
        this.iv_frequencyFSM = new FrequencyFSM();
        this.iv_dosagesFSM = new DosagesFSM();
        this.iv_rangeFSM = new RangeStrengthFSM();
        this.iv_statusFSM = new DrugChangeStatusFSM();
        this.iv_decimalFSM = new DecimalStrengthFSM();
        this.iv_strengthFSM = new StrengthFSM();
        this.iv_strengthUnitFSM = new StrengthUnitFSM();
        this.iv_frequencyUnitFSM = new FrequencyUnitFSM();
        this.iv_formFSM = new FormFSM();
        this.iv_subMedSectionFSM = new SubSectionIndicatorFSM();
        iv_logger.info((Object)"Finite state machines loaded.");
        try {
            String windowSize = (String)annotCtx.getConfigParameterValue(DISTANCE);
            String annotationTypeName = (String)annotCtx.getConfigParameterValue(DISTANCE_ANN_TYPE);
            String boundaryAnnTypeName = (String)annotCtx.getConfigParameterValue(BOUNDARY_ANN_TYPE);
            if (windowSize != null) {
                this.iWindowSize = Integer.parseInt(windowSize);
            }
            if (annotationTypeName != null) {
                this.iAnnotationType = JCasUtil.getType((String)annotationTypeName);
            }
            if (boundaryAnnTypeName != null) {
                this.iBoundaryAnnType = JCasUtil.getType((String)boundaryAnnTypeName);
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        iv_logger.info((Object)"process(JCas)");
        try {
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator segmentItr = indexes.getAnnotationIndex(Segment.type).iterator();
            FSIterator baseTokenItr = indexes.getAnnotationIndex(BaseToken.type).iterator();
            ArrayList<org.apache.ctakes.core.fsm.token.BaseToken> baseTokenList = new ArrayList<org.apache.ctakes.core.fsm.token.BaseToken>();
            while (baseTokenItr.hasNext()) {
                BaseToken bta = (BaseToken)baseTokenItr.next();
                baseTokenList.add(this.adaptToFSMBaseToken(bta));
            }
            this.prepareSubSection(jcas, indexes, this.iv_subMedSectionFSM.execute(baseTokenList));
            while (segmentItr.hasNext()) {
                Segment seg = (Segment)segmentItr.next();
                if (this.iv_medicationRelatedSections.contains(seg.getId())) {
                    this.generateDrugMentions(jcas, seg, false);
                    continue;
                }
                this.generateDrugMentions(jcas, seg, true);
            }
            this.generateUidValues(jcas);
            this.removeDrugNerTypes(jcas, this.intermediateTypesToRemove);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void removeDrugNerTypes(JCas jcas, int[] intermediateTypesToRemove) {
        for (int typeToRemove : intermediateTypesToRemove) {
            this.removeAnnotations(jcas, typeToRemove);
        }
    }

    private void removeAnnotations(JCas jcas, int type) {
        FSIterator itr = jcas.getJFSIndexRepository().getAnnotationIndex(type).iterator();
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        while (itr.hasNext()) {
            Annotation annotation = (Annotation)itr.next();
            toRemove.add(annotation);
        }
        for (Annotation anno : toRemove) {
            anno.removeFromIndexes();
        }
    }

    private void addMedicationSpecificAttributes(JCas jcas, DrugMentionAnnotation fromAnnotation, MedicationMention medicationMention) {
        MedicationDosageModifier modifier;
        if (fromAnnotation.getDosage() != null) {
            modifier = new MedicationDosageModifier(jcas);
            MedicationDosage dosage = new MedicationDosage(jcas);
            dosage.setValue(fromAnnotation.getDosage());
            modifier.setNormalizedForm((Attribute)dosage);
            modifier.setCategory(dosage.getValue());
            medicationMention.setMedicationDosage(modifier);
        }
        if (fromAnnotation.getDuration() != null) {
            modifier = new MedicationDurationModifier(jcas);
            MedicationDuration duration = new MedicationDuration(jcas);
            duration.setValue(fromAnnotation.getDuration());
            modifier.setNormalizedForm((Attribute)duration);
            modifier.setCategory(duration.getValue());
            medicationMention.setMedicationDuration((MedicationDurationModifier)modifier);
        }
        if (fromAnnotation.getDrugChangeStatus() != null) {
            modifier = new MedicationStatusChangeModifier(jcas);
            MedicationStatusChange sc = new MedicationStatusChange(jcas);
            sc.setValue(fromAnnotation.getDrugChangeStatus());
            modifier.setNormalizedForm((Attribute)sc);
            modifier.setCategory(sc.getValue());
            medicationMention.setMedicationStatusChange((MedicationStatusChangeModifier)modifier);
        }
        if (fromAnnotation.getForm() != null) {
            modifier = new MedicationFormModifier(jcas);
            MedicationForm form = new MedicationForm(jcas);
            form.setValue(fromAnnotation.getForm());
            modifier.setNormalizedForm((Attribute)form);
            modifier.setCategory(form.getValue());
            medicationMention.setMedicationForm((MedicationFormModifier)modifier);
        }
        if (fromAnnotation.getFrequencyUnit() != null || fromAnnotation.getFrequency() != null) {
            modifier = new MedicationFrequencyModifier(jcas);
            MedicationFrequency freq = new MedicationFrequency(jcas);
            freq.setNumber(fromAnnotation.getFrequency());
            freq.setUnit(fromAnnotation.getFrequencyUnit());
            modifier.setNormalizedForm((Attribute)freq);
            modifier.setCategory(fromAnnotation.getFrequency() + fromAnnotation.getFrequencyUnit());
            medicationMention.setMedicationFrequency((MedicationFrequencyModifier)modifier);
        }
        if (fromAnnotation.getRoute() != null) {
            modifier = new MedicationRouteModifier(jcas);
            MedicationRoute route = new MedicationRoute(jcas);
            route.setValue(fromAnnotation.getRoute());
            modifier.setNormalizedForm((Attribute)route);
            modifier.setCategory(route.getValue());
            medicationMention.setMedicationRoute((MedicationRouteModifier)modifier);
        }
        if (fromAnnotation.getStrength() != null || fromAnnotation.getStrengthUnit() != null) {
            modifier = new MedicationStrengthModifier(jcas);
            String str = fromAnnotation.getStrength().trim();
            int i = str.lastIndexOf(32);
            if (i >= 0) {
                str = str.substring(i + 1);
            }
            MedicationStrength strength = new MedicationStrength(jcas);
            strength.setNumber(str);
            strength.setUnit(fromAnnotation.getStrengthUnit());
            modifier.setNormalizedForm((Attribute)strength);
            modifier.setCategory(str + fromAnnotation.getStrengthUnit());
            medicationMention.setMedicationStrength((MedicationStrengthModifier)modifier);
        }
        if (fromAnnotation.getStartDate() != null) {
            Date d = DateParser.parse((JCas)jcas, (String)fromAnnotation.getStartDate());
            TimeMention timeMention = new TimeMention(jcas);
            timeMention.setDate(d);
            timeMention.setTimeClass("DATE");
            if (d != null) {
                medicationMention.setStartDate(timeMention);
            }
        }
        if ((double)fromAnnotation.getConfidence() != 0.0) {
            medicationMention.setConfidence(fromAnnotation.getConfidence());
        }
    }

    private void generateUidValues(JCas jcas) {
        int count = this.generateUidValues(jcas, MedicationMention.type, 0);
    }

    private int generateUidValues(JCas jcas, int type, int firstId) {
        int id = firstId;
        for (MedicationMention idAnnot : jcas.getJFSIndexRepository().getAnnotationIndex(type)) {
            idAnnot.setId(id);
            ++id;
        }
        return id;
    }

    private List sortSubSectionInd(Object[] holdOutSet) {
        ArrayList<Object> holdList = new ArrayList<Object>();
        for (int i = 0; i < holdOutSet.length - 1; ++i) {
            SubSectionIndicator hos1 = (SubSectionIndicator)((Object)holdOutSet[i]);
            SubSectionIndicator hos2 = (SubSectionIndicator)((Object)holdOutSet[i + 1]);
            if (hos1.getStartOffset() <= hos2.getStartOffset()) continue;
            holdOutSet[i + 1] = hos1;
            holdOutSet[i] = hos2;
            this.sortSubSectionInd(holdOutSet);
        }
        holdList.addAll(Arrays.asList(holdOutSet));
        return holdList;
    }

    private List sortAnnotations(Object[] holdOutSet) {
        ArrayList<Object> holdList = new ArrayList<Object>();
        for (int i = 0; i < holdOutSet.length - 1; ++i) {
            Annotation hos1 = (Annotation)holdOutSet[i];
            Annotation hos2 = (Annotation)holdOutSet[i + 1];
            if (hos1.getBegin() <= hos2.getBegin()) continue;
            holdOutSet[i + 1] = hos1;
            holdOutSet[i] = hos2;
            this.sortAnnotations(holdOutSet);
        }
        holdList.addAll(Arrays.asList(holdOutSet));
        return holdList;
    }

    private List findUniqueMentions(Object[] holdOutSet) {
        boolean isDuplicate = false;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < holdOutSet.length; ++i) {
            for (int j = 0; j < holdOutSet.length; ++j) {
                iv_logger.debug((Object)("Comparing [" + ((Annotation)holdOutSet[i]).getCoveredText() + "] ==? [" + ((Annotation)holdOutSet[j]).getCoveredText() + "]"));
                isDuplicate = this.isDuplicate(holdOutSet, i, j) || isDuplicate;
            }
            if (!isDuplicate) {
                iv_logger.debug((Object)("Adding NE: " + ((Annotation)holdOutSet[i]).getCoveredText()));
                list.add(holdOutSet[i]);
            } else {
                iv_logger.debug((Object)("NOT Adding NE: " + ((Annotation)holdOutSet[i]).getCoveredText()));
            }
            isDuplicate = false;
        }
        return list;
    }

    private boolean isDuplicate(Object[] neArray, int curIdx, int checkIdx) {
        if (curIdx == checkIdx || checkIdx > neArray.length) {
            iv_logger.debug((Object)("Are indices equal?:" + curIdx + "==" + checkIdx));
            return false;
        }
        Annotation ann1 = (Annotation)neArray[curIdx];
        Annotation ann2 = (Annotation)neArray[checkIdx];
        return ann1.getBegin() == ann2.getBegin() && ann1.getEnd() < ann2.getEnd();
    }

    private void prepareSubSection(JCas jcas, JFSIndexRepository indexes, Set subSectionIndSet) throws Exception {
        List sortedSubSecInds = this.sortSubSectionInd(subSectionIndSet.toArray());
        int endBodyOffset = 0;
        for (int i = 0; i < sortedSubSecInds.size(); ++i) {
            SubSectionIndicator ssi = (SubSectionIndicator)((Object)sortedSubSecInds.get(i));
            Segment segment = this.getSegmentContainingOffsets(jcas, ssi.getStartOffset(), ssi.getEndOffset());
            endBodyOffset = segment.getEnd();
            SubSectionAnnotation ssa = new SubSectionAnnotation(jcas);
            ssa.setBegin(ssi.getStartOffset());
            ssa.setSubSectionHeaderBegin(ssi.getStartOffset());
            ssa.setSubSectionHeaderEnd(ssi.getEndOffset());
            ssa.setSubSectionBodyBegin(ssi.getEndOffset() + 1);
            if (i + 1 < sortedSubSecInds.size()) {
                SubSectionIndicator nextSsi = (SubSectionIndicator)((Object)sortedSubSecInds.get(i + 1));
                endBodyOffset = this.getSubSectionAnnotationBodyEnd(segment, nextSsi);
            } else {
                endBodyOffset = this.getSubSectionAnnotationBodyEnd(segment, null);
            }
            ssa.setSubSectionBodyEnd(endBodyOffset);
            ssa.setEnd(endBodyOffset);
            ssa.addToIndexes();
            endBodyOffset = 0;
        }
    }

    private int getSubSectionAnnotationBodyEnd(Segment currSeg, SubSectionIndicator nextSsi) {
        if (nextSsi == null) {
            return currSeg.getEnd();
        }
        if (nextSsi.getStartOffset() > currSeg.getEnd()) {
            return currSeg.getEnd();
        }
        if (nextSsi.getStartOffset() < currSeg.getEnd()) {
            return nextSsi.getStartOffset() - 1;
        }
        return -1;
    }

    private Segment getSegmentContainingOffsets(JCas jcas, int start, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (Segment seg : indexes.getAnnotationIndex(Segment.type)) {
            if (seg.getBegin() > start || seg.getEnd() < end) continue;
            return seg;
        }
        return null;
    }

    private void addAnnotations(JCas jcas, Set annotations, int type) {
        Iterator annItr = annotations.iterator();
        while (annItr.hasNext()) {
            Annotation ann = null;
            BaseTokenImpl oldAnn = (BaseTokenImpl)annItr.next();
            if (FractionStrengthAnnotation.type == type) {
                ann = new FractionStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            } else if (DecimalStrengthAnnotation.type == type) {
                ann = new DecimalStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            } else if (DrugChangeStatusAnnotation.type == type) {
                ann = new DrugChangeStatusAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
                ((DrugChangeStatusAnnotation)ann).setChangeStatus(((DrugChangeStatusToken)oldAnn).getDrugChangeStatus());
            } else if (RangeStrengthAnnotation.type == type) {
                ann = new RangeStrengthAnnotation(jcas, oldAnn.getStartOffset(), oldAnn.getEndOffset());
            }
            if (ann == null) continue;
            ann.addToIndexes();
        }
    }

    private int findTextualStringOffset(String text) {
        String subText = "";
        boolean containsNums = false;
        boolean doneHere = false;
        int textSize = text.length();
        int pos = 0;
        Object posInt = null;
        while (!doneHere && textSize > pos && textSize > 1) {
            try {
                String numString = text.substring(pos, pos + 1);
                Integer posNum = Integer.decode(numString);
                int checkInt = posNum;
                if (checkInt >= 0 && checkInt <= 9) {
                    containsNums = true;
                    subText = text.substring(pos + 1, textSize);
                    ++pos;
                    continue;
                }
                return pos;
            }
            catch (NullPointerException npe) {
                return 0;
            }
            catch (NumberFormatException nfe) {
                if (!containsNums) {
                    return 0;
                }
                doneHere = true;
            }
        }
        return pos;
    }

    private void executeFSMs(JCas jcas, List baseTokenList, List namedE, List wordTokenList) throws AnnotatorProcessException {
        try {
            Annotation ma;
            Set fractionTokenSet = this.iv_fractionFSM.execute(baseTokenList);
            this.addAnnotations(jcas, fractionTokenSet, FractionStrengthAnnotation.type);
            Set decimalTokenSet = this.iv_decimalFSM.execute(baseTokenList);
            this.addAnnotations(jcas, decimalTokenSet, FractionStrengthAnnotation.type);
            Set statusTokenSet = this.iv_statusFSM.execute(baseTokenList);
            this.addAnnotations(jcas, statusTokenSet, DrugChangeStatusAnnotation.type);
            Set rangeTokenSet = this.iv_rangeFSM.execute(baseTokenList);
            this.addAnnotations(jcas, decimalTokenSet, RangeStrengthAnnotation.type);
            Set strengthTokenSet = this.iv_strengthUnitFSM.execute(baseTokenList, rangeTokenSet);
            Iterator measurementTokenItr = strengthTokenSet.iterator();
            boolean begin = false;
            boolean previous = false;
            while (measurementTokenItr.hasNext()) {
                int endSeg;
                int begSeg;
                Iterator chkNE = namedE.iterator();
                Iterator newNE = wordTokenList.iterator();
                boolean neFound = false;
                Object we = null;
                Object mt = measurementTokenItr.next();
                if (mt instanceof StrengthUnitToken) {
                    begSeg = ((StrengthUnitToken)mt).getStartOffset();
                    endSeg = ((StrengthUnitToken)mt).getEndOffset();
                    ma = new StrengthUnitAnnotation(jcas, begSeg, endSeg);
                    ma.addToIndexes();
                    continue;
                }
                begSeg = ((StrengthUnitCombinedToken)mt).getStartOffset();
                endSeg = ((StrengthUnitCombinedToken)mt).getEndOffset();
                ma = new StrengthUnitAnnotation(jcas, begSeg, endSeg);
                ma.setBegin(this.findTextualStringOffset(ma.getCoveredText()) + begSeg);
                ma.addToIndexes();
            }
            Set formTokenSet = this.iv_formFSM.execute(baseTokenList, new HashSet());
            for (FormToken mt : formTokenSet) {
                FormAnnotation ma2 = new FormAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma2.addToIndexes();
            }
            Set preTokenSet = this.iv_strengthFSM.execute(baseTokenList, strengthTokenSet, fractionTokenSet);
            for (Object mt : preTokenSet) {
                int begOff = ((BaseTokenImpl)mt).getStartOffset();
                int endOff = ((BaseTokenImpl)mt).getEndOffset();
                ma = new StrengthAnnotation(jcas, begOff, endOff);
                FSIterator subStrengthItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)StrengthUnitAnnotation.type, (int)begOff, (int)endOff);
                if (subStrengthItr.hasNext()) {
                    ma.setEnd(((StrengthUnitAnnotation)((Object)subStrengthItr.next())).getBegin());
                }
                ma.addToIndexes();
            }
            Set doseTokenSet = this.iv_dosagesFSM.execute(baseTokenList, formTokenSet, strengthTokenSet);
            Iterator dosTokenItr = doseTokenSet.iterator();
            Iterator formCheckItr = formTokenSet.iterator();
            Iterator strengthCheckItr = strengthTokenSet.iterator();
            boolean foundDosage = false;
            int begSegDose = 0;
            int endSegDose = 0;
            while (dosTokenItr.hasNext()) {
                DosageToken mt = (DosageToken)dosTokenItr.next();
                begSegDose = mt.getStartOffset();
                endSegDose = mt.getEndOffset();
                DosagesAnnotation ma3 = new DosagesAnnotation(jcas, begSegDose, endSegDose);
                ma3.addToIndexes();
            }
            Set suffixTokenSet = this.iv_suffixFSM.execute(baseTokenList, strengthTokenSet);
            for (SuffixStrengthToken mt : suffixTokenSet) {
                SuffixStrengthAnnotation ma4 = new SuffixStrengthAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma4.addToIndexes();
            }
            Set routeTokenSet = this.iv_routeFSM.execute(baseTokenList);
            boolean foundRoute = false;
            Iterator routeTokenItr = routeTokenSet.iterator();
            int begSegRT = 0;
            int endSegRT = 0;
            while (routeTokenItr.hasNext()) {
                RouteToken mt = (RouteToken)routeTokenItr.next();
                begSegRT = mt.getStartOffset();
                endSegRT = mt.getEndOffset();
                RouteAnnotation ma5 = new RouteAnnotation(jcas, begSegRT, endSegRT);
                ma5.setIntakeMethod(new Integer(mt.getFormMethod()).toString());
                ma5.addToIndexes();
            }
            Set frequencyUnitTokenSet = this.iv_frequencyUnitFSM.execute(baseTokenList);
            boolean foundFrequencyUnit = false;
            Iterator frequencyUnitTokenItr = frequencyUnitTokenSet.iterator();
            int begSegFUT = 0;
            int endSegFUT = 0;
            while (frequencyUnitTokenItr.hasNext()) {
                FrequencyUnitToken fut = (FrequencyUnitToken)frequencyUnitTokenItr.next();
                begSegFUT = fut.getStartOffset();
                endSegFUT = fut.getEndOffset();
                FrequencyUnitAnnotation ma6 = new FrequencyUnitAnnotation(jcas, begSegFUT, endSegFUT);
                ma6.setPeriod(new Float(fut.getFrequencyUnitQuantity()).floatValue());
                ma6.addToIndexes();
            }
            Set frequencyTokenSet = this.iv_frequencyFSM.execute(baseTokenList, frequencyUnitTokenSet, rangeTokenSet);
            boolean foundFrequency = false;
            Iterator frequencyTokenItr = frequencyTokenSet.iterator();
            int begSegFT = 0;
            int endSegFT = 0;
            while (frequencyTokenItr.hasNext()) {
                FrequencyToken ft = (FrequencyToken)frequencyTokenItr.next();
                begSegFT = ft.getStartOffset();
                endSegFT = ft.getEndOffset();
                FrequencyAnnotation ma7 = new FrequencyAnnotation(jcas, begSegFT, endSegFT);
                ma7.addToIndexes();
            }
            Set durationTokenSet = this.iv_durationFSM.execute(baseTokenList, rangeTokenSet);
            Iterator durationTokenItr = durationTokenSet.iterator();
            int begSegDU = 0;
            int endSegDU = 0;
            while (durationTokenItr.hasNext()) {
                DurationToken du = (DurationToken)durationTokenItr.next();
                begSegDU = du.getStartOffset();
                endSegDU = du.getEndOffset();
                DurationAnnotation ma8 = new DurationAnnotation(jcas, begSegDU, endSegDU);
                ma8.addToIndexes();
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
    }

    private void generateDrugMentions(JCas jcas, Segment seg, boolean narrativeType) throws Exception {
        int begin = seg.getBegin();
        int end = seg.getEnd() + 1;
        MedicationMention nextNER = null;
        int nextNERPosition = 0;
        int[] validNeTypes = new int[]{1, 0};
        try {
            List uniqueNEs = this.findUniqueMentions(FSUtil.getAnnotationsInSpan((JCas)jcas, (int)MedicationMention.type, (int)begin, (int)end, (int[])validNeTypes).toArray());
            int globalArraySize = uniqueNEs.size() * 3;
            int[][] windowSpans = new int[globalArraySize][2];
            int globalWindowSize = 0;
            if (narrativeType) {
                for (int neCount = 0; neCount < uniqueNEs.size(); ++neCount) {
                    boolean processedSpan = false;
                    MedicationMention neNarrative = (MedicationMention)uniqueNEs.get(neCount);
                    for (int spanCheck = 0; spanCheck < windowSpans.length && !processedSpan && windowSpans[spanCheck][0] != 0; ++spanCheck) {
                        if (windowSpans[spanCheck][0] != neNarrative.getBegin()) continue;
                        processedSpan = true;
                    }
                    if (processedSpan) continue;
                    int[][] narrativeSpans = this.getWindowSpan(jcas, "narrative", MedicationMention.type, neNarrative.getBegin(), neNarrative.getEnd(), false, globalArraySize);
                    for (int elementCount = 0; elementCount < narrativeSpans.length; ++elementCount) {
                        windowSpans[globalWindowSize] = narrativeSpans[elementCount];
                        ++globalWindowSize;
                    }
                }
            } else if (uniqueNEs.size() > 0 && (windowSpans = this.getWindowSpan(jcas, "list", MedicationMention.type, begin, end, false, globalArraySize)).length > 0 && windowSpans[0][0] == -1) {
                windowSpans[0][0] = begin;
                windowSpans[0][1] = end;
            }
            for (int count = 0; count < windowSpans.length; ++count) {
                List<Annotation> neTokenUpdatedList = this.getAnnotationsInSpan(jcas, MedicationMention.type, windowSpans[count][0], windowSpans[count][1]);
                if (neTokenUpdatedList.isEmpty()) continue;
                ArrayList<DrugMentionAnnotation> globalDrugNERList = new ArrayList<DrugMentionAnnotation>();
                try {
                    this.generateDrugMentionsAndAnnotations(jcas, neTokenUpdatedList, windowSpans[count][0], windowSpans[count][1], null, null, 0, globalDrugNERList);
                }
                catch (NumberFormatException nfe) {
                    iv_logger.info((Object)nfe.getMessage());
                }
                catch (Exception e) {
                    iv_logger.info((Object)e.getMessage());
                }
                globalDrugNERList.clear();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            List allNEs = FSUtil.getAnnotationsInSpan((JCas)jcas, (int)MedicationMention.type, (int)begin, (int)end, (int[])validNeTypes);
            List uniqueNEs = this.findUniqueMentions(allNEs.toArray());
            int lastNL = seg.getEnd();
            boolean lastOne = false;
            FSIterator newLineItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)NewlineToken.type, (int)begin, (int)end);
            for (int i = 0; i < uniqueNEs.size(); ++i) {
                MedicationMention thisNER = (MedicationMention)uniqueNEs.get(i);
                boolean hasNext = false;
                if (uniqueNEs.size() > i + 1) {
                    nextNER = (MedicationMention)uniqueNEs.get(i + 1);
                    nextNERPosition = nextNER.getBegin();
                    if (nextNER != null) {
                        hasNext = true;
                    }
                } else if (!uniqueNEs.isEmpty()) {
                    nextNER = (MedicationMention)uniqueNEs.get(i);
                    nextNERPosition = nextNER.getBegin();
                    lastOne = true;
                }
                boolean foundLeftParen = false;
                boolean foundRightParen = false;
                foundRightParen = this.findCoveredTextInSpan(jcas, PunctuationToken.type, thisNER.getEnd(), thisNER.getEnd() + 3, new String[]{")", "/"});
                end = hasNext && !lastOne ? nextNERPosition : seg.getEnd();
                boolean hasNLEnd = true;
                boolean wrapItUp = false;
                while (hasNLEnd && !wrapItUp && end <= seg.getEnd() && (begin < end || !hasNext && begin <= end || foundLeftParen)) {
                    if (begin == end) {
                        foundLeftParen = false;
                        ++end;
                    }
                    NewlineToken nl = null;
                    if (hasNLEnd && newLineItr.hasNext()) {
                        nl = (NewlineToken)newLineItr.next();
                        hasNLEnd = true;
                    }
                    if (!hasNext && begin <= end || nextNERPosition < end) {
                        wrapItUp = true;
                    }
                    boolean findNextNL = false;
                    if (lastNL <= thisNER.getBegin()) {
                        begin = thisNER.getBegin();
                    }
                    if (nl != null && thisNER.getBegin() >= nl.getEnd()) {
                        findNextNL = true;
                    } else if (nl != null) {
                        lastNL = nl.getEnd();
                    }
                    if (!hasNext) {
                        findNextNL = false;
                        end = seg.getEnd();
                    }
                    if (findNextNL) continue;
                    if (nextNER != null && (nextNER.getCoveredText().compareToIgnoreCase(thisNER.getCoveredText()) == 0 || foundRightParen || nextNER.getBegin() == thisNER.getEnd() + 2)) {
                        if (nl == null) {
                            if (!hasNext) {
                                end = seg.getEnd();
                            }
                        } else if (nextNER.getBegin() >= nl.getEnd() && hasNext) {
                            end = nextNERPosition;
                        }
                    } else if (hasNLEnd && hasNext) {
                        foundLeftParen = this.findCoveredTextInSpan(jcas, PunctuationToken.type, nextNER.getBegin() - 1, nextNER.getBegin() + 1, new String[]{"(", "/"});
                        end = nl != null && nl.getEnd() > nextNER.getBegin() && !foundLeftParen ? nextNERPosition : nextNER.getBegin();
                    } else {
                        end = hasNext ? nextNERPosition : seg.getEnd();
                    }
                    if (begin < end) {
                        this.findDrugAttributesInRange(jcas, begin, end);
                        List<Annotation> neTokenUpdatedList = this.getAnnotationsInSpan(jcas, MedicationMention.type, begin, end + 1);
                        if (!neTokenUpdatedList.isEmpty()) {
                            ArrayList<DrugMentionAnnotation> globalDrugNERList = new ArrayList<DrugMentionAnnotation>();
                            try {
                                this.generateDrugMentionsAndAnnotations(jcas, neTokenUpdatedList, begin, end, null, null, 0, globalDrugNERList);
                            }
                            catch (NumberFormatException nfe) {
                                iv_logger.info((Object)nfe.getMessage());
                            }
                            catch (Exception e) {
                                iv_logger.info((Object)e.getMessage());
                            }
                            globalDrugNERList.clear();
                        }
                    }
                    begin = end;
                }
            }
        }
    }

    private boolean findCoveredTextInSpan(JCas jcas, int annotationType, int beginOffset, int endOffset, String[] searchStrs) {
        boolean foundCoveredText = false;
        FSIterator coveredTextIter = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)annotationType, (int)beginOffset, (int)endOffset);
        while (coveredTextIter.hasNext() && !foundCoveredText) {
            Annotation ann = (Annotation)coveredTextIter.next();
            for (int i = 0; i < searchStrs.length && !foundCoveredText; ++i) {
                foundCoveredText = searchStrs[i].equals(ann.getCoveredText());
            }
        }
        return foundCoveredText;
    }

    private List getAnnotationsInSpanWithAdaptToBaseTokenFSM(JCas jcas, int type, int begin, int end) throws Exception {
        List<Annotation> list = this.getAnnotationsInSpan(jcas, type, begin, end);
        for (int i = 0; i < list.size(); ++i) {
            list.add(i, (Annotation)this.adaptToFSMBaseToken((BaseToken)list.get(i)));
            list.remove(i + 1);
        }
        return list;
    }

    private List<Annotation> getAnnotationsInSpan(JCas jcas, int type, int begin, int end) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        FSIterator annItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)type, (int)begin, (int)end);
        while (annItr.hasNext()) {
            Annotation ann = (Annotation)annItr.next();
            list.add(ann);
        }
        return list;
    }

    private void findDrugAttributesInRange(JCas jcas, int begin, int end) throws Exception {
        List baseTokenList = this.getAnnotationsInSpanWithAdaptToBaseTokenFSM(jcas, BaseToken.type, begin, end + 1);
        List<Annotation> neTokenList = this.getAnnotationsInSpan(jcas, MedicationMention.type, begin, end + 1);
        List<Annotation> weTokenList = this.getAnnotationsInSpan(jcas, WordToken.type, begin, end + 1);
        this.executeFSMs(jcas, baseTokenList, neTokenList, weTokenList);
    }

    private void generateDrugMentionsAndAnnotations(JCas jcas, List<MedicationMention> nerTokenList, int begin, int end, DrugMentionAnnotation recurseNER, String[] relatedStatus, int countNER, List<DrugMentionAnnotation> globalDrugNER) throws Exception {
        Iterator<MedicationMention> uniqueNER = nerTokenList.iterator();
        DrugMentionAnnotation drugTokenAnt = null;
        MedicationMention tokenAnt = null;
        ArrayList<DrugMentionAnnotation> holdDrugNERArr = new ArrayList<DrugMentionAnnotation>();
        while (uniqueNER.hasNext()) {
            tokenAnt = uniqueNER.next();
            boolean isDrugNER = false;
            FSArray ocArr = tokenAnt.getOntologyConceptArr();
            if (ocArr != null) {
                for (int i = 0; i < ocArr.size() && !isDrugNER; ++i) {
                    OntologyConcept oc = (OntologyConcept)ocArr.get(i);
                    String scheme = oc.getCodingScheme();
                    isDrugNER = true;
                }
            }
            if (tokenAnt != null && (isDrugNER || relatedStatus != null)) {
                boolean keepNoChangeStatus = false;
                boolean maxExists = false;
                int maxOffsetEnd = 0;
                int holdRightEnd = end + 1;
                int holdLeftStart = begin;
                drugTokenAnt = new DrugMentionAnnotation(jcas, tokenAnt.getBegin(), tokenAnt.getEnd());
                tokenAnt.setTypeID(1);
                holdDrugNERArr.add(drugTokenAnt);
                FSIterator statusChangeItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DrugChangeStatusAnnotation.type, (int)holdLeftStart, (int)holdRightEnd);
                ArrayList<DrugChangeStatusAnnotation> holdStatusChanges = new ArrayList<DrugChangeStatusAnnotation>();
                int[] localSpan = this.getNarrativeSpansContainingGivenSpanType(jcas, drugTokenAnt.getBegin(), this.iBoundaryAnnType);
                while (statusChangeItr.hasNext()) {
                    FSIterator findSubSection = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)SubSectionAnnotation.type, (int)holdLeftStart, (int)holdRightEnd);
                    boolean isolate = false;
                    if (!findSubSection.hasNext()) {
                        DrugChangeStatusAnnotation dsa = (DrugChangeStatusAnnotation)((Object)statusChangeItr.next());
                        if (dsa.getChangeStatus().compareTo("maximum") != 0 && dsa.getEnd() < holdRightEnd && localSpan[0] < dsa.getBegin() && localSpan[1] > dsa.getEnd()) {
                            holdStatusChanges.add(dsa);
                            continue;
                        }
                        if (dsa.getChangeStatus().compareTo("maximum") != 0 || dsa.getEnd() >= holdRightEnd) continue;
                        maxExists = true;
                        maxOffsetEnd = dsa.getEnd();
                        continue;
                    }
                    statusChangeItr.next();
                    boolean noWeirdError = true;
                    boolean pullOut = false;
                    while (!pullOut && !isolate && findSubSection.hasNext() && noWeirdError) {
                        try {
                            SubSectionAnnotation sub = (SubSectionAnnotation)((Object)findSubSection.next());
                            FSIterator findStartLF = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)NewlineToken.type, (int)holdLeftStart, (int)(sub.getBegin() + 1));
                            FSIterator findEndLF = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)NewlineToken.type, (int)sub.getEnd(), (int)holdRightEnd);
                            if (findStartLF.hasNext() && findEndLF.hasNext()) {
                                while (findStartLF.hasNext()) {
                                    NewlineToken nta = (NewlineToken)findStartLF.next();
                                    int countSymbols = FSUtil.countAnnotationsInSpan((JCas)jcas, (int)SymbolToken.type, (int)nta.getEnd(), (int)sub.getBegin());
                                    if (nta.getEnd() + countSymbols + 1 < sub.getBegin()) continue;
                                    isolate = true;
                                    holdRightEnd = sub.getBegin();
                                    end = sub.getBegin();
                                }
                                if (isolate) continue;
                                DrugChangeStatusAnnotation dsa = (DrugChangeStatusAnnotation)((Object)statusChangeItr.next());
                                holdStatusChanges.add(dsa);
                                pullOut = true;
                                sub.removeFromIndexes();
                                continue;
                            }
                            if (findEndLF.hasNext()) {
                                holdLeftStart = sub.getEnd();
                                continue;
                            }
                            if (sub.getBegin() > tokenAnt.getEnd()) {
                                end = sub.getBegin();
                                holdRightEnd = sub.getBegin();
                                sub.removeFromIndexes();
                                continue;
                            }
                            holdLeftStart = sub.getEnd();
                            holdRightEnd = tokenAnt.getBegin();
                        }
                        catch (NoSuchElementException nsee) {
                            noWeirdError = false;
                            iv_logger.info((Object)nsee.getLocalizedMessage());
                        }
                    }
                }
                ArrayList<DrugChangeStatusAnnotation> modifiedOrderDrugStatusChanges = new ArrayList<DrugChangeStatusAnnotation>();
                Iterator sortStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                Iterator sortNextStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                if (sortNextStatusChanges.hasNext()) {
                    sortNextStatusChanges.next();
                }
                boolean skipNext = false;
                int checkSkippedOffsetBegin = 0;
                int checkSkippedOffsetEnd = 0;
                while (sortStatusChanges.hasNext()) {
                    DrugChangeStatusAnnotation hos1 = (DrugChangeStatusAnnotation)((Object)sortStatusChanges.next());
                    if (sortNextStatusChanges.hasNext()) {
                        DrugChangeStatusAnnotation hos2 = (DrugChangeStatusAnnotation)((Object)sortNextStatusChanges.next());
                        if (hos1.getBegin() == hos2.getBegin()) {
                            if (hos1.getEnd() >= hos2.getEnd()) {
                                skipNext = true;
                                checkSkippedOffsetBegin = hos2.getBegin();
                                checkSkippedOffsetEnd = hos2.getEnd();
                                hos2.removeFromIndexes();
                                modifiedOrderDrugStatusChanges.add(hos1);
                                continue;
                            }
                            iv_logger.info((Object)"found reverse case . . need to handle");
                            continue;
                        }
                        if (!skipNext) {
                            modifiedOrderDrugStatusChanges.add(hos1);
                            continue;
                        }
                        skipNext = false;
                        continue;
                    }
                    if (checkSkippedOffsetBegin != 0 && (checkSkippedOffsetBegin == hos1.getBegin() || checkSkippedOffsetEnd == hos1.getEnd())) continue;
                    modifiedOrderDrugStatusChanges.add(hos1);
                }
                Iterator orderedStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                Iterator orderedDrugStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
                if (modifiedOrderDrugStatusChanges.size() > 0) {
                    int[] newSpan = new int[]{begin, end};
                    newSpan = this.statusChangePhraseGenerator(jcas, begin, end, maxExists, uniqueNER, orderedStatusChanges, modifiedOrderDrugStatusChanges, relatedStatus, drugTokenAnt, globalDrugNER, countNER);
                    begin = newSpan[0];
                    end = newSpan[1];
                    if (drugTokenAnt.getDrugChangeStatus() != null && drugTokenAnt.getDrugChangeStatus().equals("noChange") || drugTokenAnt.getDrugChangeStatus() != null && drugTokenAnt.getDrugChangeStatus().equals("change")) {
                        keepNoChangeStatus = true;
                        if (drugTokenAnt.getDrugChangeStatus().equals("change")) {
                            drugTokenAnt.setDrugChangeStatus("noChange");
                        }
                    }
                }
                DrugMention dm = new DrugMention(jcas, begin, end);
                boolean overrideStatus = false;
                boolean statusFound = false;
                if (!keepNoChangeStatus) {
                    JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                    FSIterator subSectionItr = indexes.getAnnotationIndex(SubSectionAnnotation.type).iterator();
                    String statusKey = null;
                    while (subSectionItr.hasNext() && !statusFound) {
                        FSIterator oneDrugChangeStatus;
                        SubSectionAnnotation ssid = (SubSectionAnnotation)((Object)subSectionItr.next());
                        if (ssid.getSubSectionBodyBegin() > tokenAnt.getBegin() || ssid.getSubSectionBodyEnd() < tokenAnt.getEnd()) continue;
                        boolean overrideDate = false;
                        FSIterator statusSpecialDateItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DateAnnotation.type, (int)ssid.getEnd(), (int)drugTokenAnt.getBegin());
                        while (statusSpecialDateItr.hasNext() && !overrideDate) {
                            DateAnnotation specialDate = (DateAnnotation)statusSpecialDateItr.next();
                            FSIterator findLF = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)NewlineToken.type, (int)ssid.getEnd(), (int)specialDate.getBegin());
                            if (findLF.hasNext()) continue;
                            drugTokenAnt.setStartDate(specialDate.getCoveredText());
                            overrideDate = true;
                        }
                        DrugChangeStatusAnnotation dsa = null;
                        if (orderedDrugStatusChanges.hasNext()) {
                            dsa = (DrugChangeStatusAnnotation)((Object)orderedDrugStatusChanges.next());
                        }
                        if (dsa != null && (dsa.getChangeStatus().compareTo("start") == 0 || dsa.getChangeStatus().compareTo("stop") == 0)) {
                            drugTokenAnt.setDrugChangeStatus(dsa.getChangeStatus());
                            continue;
                        }
                        statusKey = dm.convertToChangeStatus(ssid.getCoveredText());
                        if (ssid.getStatus() == 1) {
                            statusKey = "stop";
                        }
                        if (statusKey.compareTo("noChange") == 0 && (oneDrugChangeStatus = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DrugChangeStatusAnnotation.type, (int)ssid.getBegin(), (int)(ssid.getEnd() + 1))).hasNext()) {
                            dsa = (DrugChangeStatusAnnotation)((Object)oneDrugChangeStatus.next());
                            drugTokenAnt.setDrugChangeStatus(dsa.getChangeStatus());
                            statusKey = dsa.getChangeStatus();
                        }
                        drugTokenAnt.setStatus(ssid.getStatus());
                        dm.setDrugChangeStatusElement(statusKey, begin, end);
                        statusFound = true;
                    }
                    FSIterator statusSpecialChangeItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DrugChangeStatusAnnotation.type, (int)(begin - 20), (int)(drugTokenAnt.getBegin() + 1));
                    while (statusSpecialChangeItr.hasNext()) {
                        DrugChangeStatusAnnotation specialDsa = (DrugChangeStatusAnnotation)((Object)statusSpecialChangeItr.next());
                        if (specialDsa.getEnd() + 1 != drugTokenAnt.getBegin() || relatedStatus != null) continue;
                        drugTokenAnt.setDrugChangeStatus(specialDsa.getChangeStatus());
                        drugTokenAnt.setChangeStatusBegin(specialDsa.getBegin());
                        drugTokenAnt.setChangeStatusEnd(specialDsa.getEnd());
                        overrideStatus = true;
                    }
                }
                String strengthText = null;
                boolean onlyNeedOneStrength = false;
                if (!keepNoChangeStatus || drugTokenAnt.getStrength() == null) {
                    List<Annotation> holdStrength = this.getAnnotationsInSpan(jcas, StrengthAnnotation.type, begin, end + 1);
                    Iterator strengthItr = this.findUniqueMentions(holdStrength.toArray()).iterator();
                    double strengthValue = 0.0;
                    int holdStrengthBeginOffset = 0;
                    int holdStrengthEndOffset = 0;
                    while (strengthItr.hasNext() && !onlyNeedOneStrength) {
                        StrengthAnnotation sa = (StrengthAnnotation)((Object)strengthItr.next());
                        if (holdStrengthBeginOffset != sa.getBegin() && holdStrengthEndOffset != sa.getEnd() && relatedStatus != null) {
                            int spaceLocation;
                            double curStrengthValue = 0.0;
                            int hyphenLocation = sa.getCoveredText().indexOf("-");
                            String holdStrengthValue = sa.getCoveredText();
                            if (hyphenLocation > 0) {
                                holdStrengthValue = holdStrengthValue.substring(0, hyphenLocation);
                            }
                            if ((spaceLocation = holdStrengthValue.indexOf(" ")) > 0) {
                                holdStrengthValue = holdStrengthValue.substring(0, spaceLocation);
                            }
                            if (holdStrengthValue != null && holdStrengthValue.compareTo("") != 0) {
                                curStrengthValue = new Double(dm.parseDoubleValue(holdStrengthValue));
                            }
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curStrengthValue > strengthValue) {
                                    strengthValue = curStrengthValue;
                                    strengthText = dm.getStrengthElement();
                                }
                            } else if (relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    strengthValue = curStrengthValue;
                                }
                                if (curStrengthValue <= strengthValue) {
                                    strengthValue = curStrengthValue;
                                    strengthText = dm.getStrengthElement();
                                }
                                findLowValue = false;
                            } else if (relatedStatus[0].compareTo("add") == 0) {
                                strengthValue = curStrengthValue;
                                strengthText = dm.getStrengthElement();
                            }
                        } else {
                            strengthText = dm.getStrengthElement();
                            if (!maxExists) {
                                onlyNeedOneStrength = true;
                            } else if (maxOffsetEnd + 1 == sa.getBegin()) {
                                onlyNeedOneStrength = true;
                                strengthText = sa.getCoveredText();
                            }
                        }
                        holdStrengthBeginOffset = sa.getBegin();
                        holdStrengthEndOffset = sa.getEnd();
                    }
                }
                String doseText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getDosage() == null) {
                    FSIterator dosageItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DosagesAnnotation.type, (int)begin, (int)(end + 1));
                    ArrayList<DosagesAnnotation> holdDosages = new ArrayList<DosagesAnnotation>();
                    double doseValue = 0.0;
                    int holdDoseBeginOffset = 0;
                    int holdDoseEndOffset = 0;
                    boolean onlyNeedOneDose = false;
                    while (dosageItr.hasNext() && !onlyNeedOneDose) {
                        DosagesAnnotation da = (DosagesAnnotation)((Object)dosageItr.next());
                        if (holdDoseBeginOffset != da.getBegin() && holdDoseEndOffset != da.getEnd() && relatedStatus != null) {
                            int removeComma = da.getCoveredText().indexOf(44);
                            String doseTextCheck = da.getCoveredText();
                            if (removeComma > 0) {
                                doseTextCheck = doseTextCheck.substring(0, removeComma);
                            }
                            double curDoseValue = new Double(dm.convertFromTextToNum(doseTextCheck));
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curDoseValue > doseValue) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                } else if (relatedStatus[0].compareTo("add") == 0) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                }
                            } else if (relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    doseValue = curDoseValue;
                                }
                                if (curDoseValue <= doseValue) {
                                    doseValue = curDoseValue;
                                    doseText = dm.getDosageElement();
                                }
                                findLowValue = false;
                            }
                            holdDosages.add(da);
                            holdDoseBeginOffset = da.getBegin();
                            holdDoseEndOffset = da.getEnd();
                            continue;
                        }
                        doseText = dm.getDosageElement();
                        if (maxExists) continue;
                        onlyNeedOneDose = true;
                    }
                }
                String frequencyText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getFrequency() == null) {
                    FSIterator freqItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)FrequencyAnnotation.type, (int)begin, (int)(end + 1));
                    ArrayList holdFreqItr = new ArrayList();
                    while (freqItr.hasNext()) {
                        holdFreqItr.add(freqItr.next());
                    }
                    Iterator frequencyItr = this.sortAnnotations(holdFreqItr.toArray()).iterator();
                    ArrayList<FrequencyAnnotation> holdFrequency = new ArrayList<FrequencyAnnotation>();
                    double frequencyValue = 0.0;
                    int holdFrequencyBeginOffset = 0;
                    int holdFrequencyEndOffset = 0;
                    boolean onlyNeedOneFrequency = false;
                    while (frequencyItr.hasNext() && !onlyNeedOneFrequency) {
                        FrequencyAnnotation fa = (FrequencyAnnotation)((Object)frequencyItr.next());
                        if (dm.frequency != null && dm.frequency.getFrequencyMention() == null) {
                            double curFrequencyValue = new Double(dm.convertFromTextToNum(fa.getCoveredText()));
                            String curFreqValueText = new Double(curFrequencyValue).toString();
                            dm.setFrequencyElement(curFreqValueText, fa.getBegin(), fa.getEnd());
                            frequencyText = curFreqValueText;
                        }
                        onlyNeedOneFrequency = true;
                        holdFrequency.add(fa);
                        holdFrequencyBeginOffset = fa.getBegin();
                        holdFrequencyEndOffset = fa.getEnd();
                    }
                }
                boolean foundPRN = false;
                String frequencyUnitText = null;
                if (!keepNoChangeStatus || drugTokenAnt.getFrequencyUnit() == null) {
                    FSIterator frequencyUnitItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)FrequencyUnitAnnotation.type, (int)begin, (int)(end + 1));
                    ArrayList<FrequencyUnitAnnotation> holdFrequencyUnit = new ArrayList<FrequencyUnitAnnotation>();
                    double frequencyUnitValue = 0.0;
                    int holdFrequencyUnitBeginOffset = 0;
                    int holdFrequencyUnitEndOffset = 0;
                    boolean onlyNeedOneFrequencyUnit = false;
                    while (frequencyUnitItr.hasNext() && !onlyNeedOneFrequencyUnit) {
                        FrequencyUnitAnnotation fua = (FrequencyUnitAnnotation)((Object)frequencyUnitItr.next());
                        if (holdFrequencyUnitBeginOffset != fua.getBegin() && holdFrequencyUnitEndOffset != fua.getEnd() && relatedStatus != null) {
                            double curFrequencyUnitValue = new Float(fua.getPeriod()).doubleValue();
                            boolean findLowValue = true;
                            if (relatedStatus[0].compareTo("increase") == 0) {
                                if (curFrequencyUnitValue > frequencyUnitValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                    frequencyUnitText = dm.getFrequencyUnitElement();
                                }
                            } else if (relatedStatus[0] == null || relatedStatus[0].compareTo("decrease") == 0) {
                                if (findLowValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                }
                                if (curFrequencyUnitValue <= frequencyUnitValue) {
                                    frequencyUnitValue = curFrequencyUnitValue;
                                    frequencyUnitText = dm.getFrequencyUnitElement();
                                }
                                findLowValue = false;
                            }
                        } else if ((double)fua.getPeriod() == 0.0) {
                            foundPRN = true;
                        } else {
                            frequencyUnitText = dm.getFrequencyUnitElement();
                            if (!maxExists) {
                                onlyNeedOneStrength = true;
                            }
                        }
                        holdFrequencyUnit.add(fua);
                        holdFrequencyUnitBeginOffset = fua.getBegin();
                        holdFrequencyUnitEndOffset = fua.getEnd();
                    }
                }
                if (recurseNER != null && recurseNER.getDrugChangeStatus() != null && relatedStatus[0] != null && dm.changeStatus == null) {
                    drugTokenAnt.setDrugChangeStatus(relatedStatus[0]);
                } else if (keepNoChangeStatus || dm.changeStatus != null && (dm.changeStatus.getDrugChangeStatus().equals("increasefrom") || dm.changeStatus.getDrugChangeStatus().equals("decreasefrom"))) {
                    drugTokenAnt.setDrugChangeStatus("noChange");
                } else if (dm.getDrugChangeStatusElement() != null && dm.getDrugChangeStatusElement().compareTo("") != 0 && dm.getDrugChangeStatusElement().compareTo("noChange") != 0 && !overrideStatus) {
                    FSIterator negateStatusChanges = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)SubSectionAnnotation.type, (int)dm.changeStatus.getBeginOffset(), (int)(dm.changeStatus.getEndOffset() + 2));
                    if (!(negateStatusChanges.hasNext() && !statusFound || keepNoChangeStatus)) {
                        drugTokenAnt.setDrugChangeStatus(dm.getDrugChangeStatusElement());
                        drugTokenAnt.setChangeStatusBegin(dm.getChangeStatusBegin());
                        drugTokenAnt.setChangeStatusEnd(dm.getChangeStatusEnd());
                    } else {
                        drugTokenAnt.setDrugChangeStatus("noChange");
                    }
                } else if (relatedStatus != null && relatedStatus[0] != null) {
                    drugTokenAnt.setDrugChangeStatus(relatedStatus[0]);
                    drugTokenAnt.setChangeStatusBegin(new Integer(relatedStatus[1]));
                    drugTokenAnt.setChangeStatusEnd(new Integer(relatedStatus[2]));
                } else if (drugTokenAnt.getDrugChangeStatus() == null || drugTokenAnt.getDrugChangeStatus().compareTo("") == 0) {
                    drugTokenAnt.setDrugChangeStatus("noChange");
                }
                if (!keepNoChangeStatus) {
                    String relatedStatusString = null;
                    if (relatedStatus != null && relatedStatus[0] != null) {
                        relatedStatusString = relatedStatus[0];
                    }
                    float confidenceScore = this.alignDrugMentionAttributes(strengthText, dm, drugTokenAnt, recurseNER, relatedStatusString, statusFound, overrideStatus, maxExists, doseText, frequencyText, frequencyUnitText);
                    drugTokenAnt.setConfidence(confidenceScore);
                }
                if (foundPRN) {
                    drugTokenAnt.setDrugChangeStatus(drugTokenAnt.getDrugChangeStatus());
                }
                ChunkAnnotation ca = new ChunkAnnotation(jcas, begin, end);
                ca.addToIndexes();
                ca.setSentenceID(tokenAnt.getSentenceID());
                drugTokenAnt.addToIndexes();
                globalDrugNER.add(drugTokenAnt);
            }
            if (!isDrugNER) continue;
            countNER = globalDrugNER.size();
            boolean gotChangeStatus = false;
            for (int i = 0; i < countNER; ++i) {
                if (!(globalDrugNER.get(i).getDrugChangeStatus().equals("noChange") || globalDrugNER.get(i).getDrugChangeStatus().equals("stop") || globalDrugNER.get(i).getDrugChangeStatus().equals("start"))) {
                    gotChangeStatus = true;
                }
                if (i == 0) {
                    this.addMedicationSpecificAttributes(jcas, globalDrugNER.get(i), tokenAnt);
                    continue;
                }
                if (!gotChangeStatus) continue;
                MedicationMention mem = new MedicationMention(jcas, globalDrugNER.get(i).getBegin(), globalDrugNER.get(i).getEnd());
                this.addMedicationSpecificAttributes(jcas, globalDrugNER.get(i), mem);
                mem.addToIndexes(jcas);
            }
        }
    }

    private float alignDrugMentionAttributes(String strengthText, DrugMention dm, DrugMentionAnnotation drugTokenAnt, DrugMentionAnnotation recurseNER, String relatedStatus, boolean statusFound, boolean overrideStatus, boolean maxExists, String doseText, String frequencyText, String frequencyUnitText) {
        float keepScoreOfConfidence = 0.05f;
        if (dm.getStrengthElement() != null && dm.getStrengthElement() != "" && dm.getStrengthElement().compareTo("null") != 0) {
            keepScoreOfConfidence = 0.15f;
        }
        if (strengthText != null) {
            drugTokenAnt.setStrength(strengthText);
            drugTokenAnt.setStrengthBegin(dm.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(dm.getStrengthEnd());
            drugTokenAnt.setStrengthUnit(dm.getStrengthUnitElement());
            drugTokenAnt.setSuBegin(dm.getStrengthUnitBegin());
            drugTokenAnt.setSuEnd(dm.getStrengthUnitEnd());
        } else if (recurseNER != null && recurseNER.getStrength() != null) {
            drugTokenAnt.setStrength(recurseNER.getStrength());
            drugTokenAnt.setStrengthBegin(recurseNER.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(recurseNER.getStrengthEnd());
            drugTokenAnt.setStrengthUnit(recurseNER.getStrengthUnit());
            drugTokenAnt.setSuBegin(recurseNER.getSuBegin());
            drugTokenAnt.setSuEnd(recurseNER.getSuEnd());
        } else if (dm.getStrengthElement() != null && dm.strength != null) {
            drugTokenAnt.setStrength(dm.getStrengthElement());
            drugTokenAnt.setStrengthBegin(dm.getStrengthBegin());
            drugTokenAnt.setStrengthEnd(dm.getStrengthEnd());
            drugTokenAnt.setStrengthUnit(dm.getStrengthUnitElement());
            drugTokenAnt.setSuBegin(dm.getStrengthUnitBegin());
            drugTokenAnt.setSuEnd(dm.getStrengthUnitEnd());
        }
        if (dm.getDosageElement() != null && dm.getDosageElement().compareTo("null") != 0 && doseText != null) {
            keepScoreOfConfidence += 0.05f;
        }
        if (doseText != null) {
            if (maxExists) {
                drugTokenAnt.setDosage("1.0");
            } else {
                drugTokenAnt.setDosage(doseText);
                drugTokenAnt.setDosageBegin(dm.getDosageBegin());
                drugTokenAnt.setDosageEnd(dm.getDosageEnd());
            }
        } else if (recurseNER != null && recurseNER.getDosage() != null) {
            drugTokenAnt.setDosage(recurseNER.getDosage());
            drugTokenAnt.setDosageBegin(recurseNER.getDosageBegin());
            drugTokenAnt.setDosageEnd(recurseNER.getDosageEnd());
        } else if (dm.getDosageElement() != null && dm.dosage != null) {
            drugTokenAnt.setDosage(dm.getDosageElement());
            drugTokenAnt.setDosageBegin(dm.getDosageBegin());
            drugTokenAnt.setDosageEnd(dm.getDosageEnd());
        }
        if (dm.getDurationElement() != null && dm.getDurationElement().compareTo("") != 0 && dm.getDurationElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setDuration(dm.getDurationElement());
            drugTokenAnt.setDurationBegin(dm.getDuratationBegin());
            drugTokenAnt.setDurationEnd(dm.getDuratationEnd());
        }
        if (dm.getStartDateElement() != null && dm.getStartDateElement().compareTo("") != 0) {
            drugTokenAnt.setStartDate(dm.getStartDateElement());
        }
        if (dm.getFormElement() != null && dm.getFormElement().compareTo("") != 0 && dm.getFormElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setForm(dm.getFormElement());
            drugTokenAnt.setFormBegin(dm.getFormBegin());
            drugTokenAnt.setFormEnd(dm.getFormEnd());
        } else if (recurseNER != null && recurseNER.getForm() != null) {
            drugTokenAnt.setForm(recurseNER.getForm());
            drugTokenAnt.setFormBegin(recurseNER.getFormBegin());
            drugTokenAnt.setFormEnd(recurseNER.getFormEnd());
        }
        if (dm.getFrequencyElement() != null && dm.getFrequencyElement().compareTo("") != 0 && dm.frequency != null && dm.getFrequencyElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.5f;
        }
        if (frequencyText != null) {
            if (maxExists) {
                drugTokenAnt.setFrequency("1.0");
            } else {
                drugTokenAnt.setFrequency(frequencyText);
            }
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        } else if (recurseNER != null && recurseNER.getFrequencyUnit() != null) {
            drugTokenAnt.setFrequency(recurseNER.getFrequency());
            drugTokenAnt.setFrequencyBegin(recurseNER.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(recurseNER.getFrequencyEnd());
        } else if (dm.getFrequencyElement() != null && dm.frequency != null) {
            drugTokenAnt.setFrequency(dm.getFrequencyElement());
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        }
        if (dm.getFrequencyUnitElement() != null && dm.getFrequencyUnitElement().compareTo("") != 0 && dm.frequencyUnit != null) {
            keepScoreOfConfidence *= 1.5f;
        }
        if (frequencyUnitText != null) {
            drugTokenAnt.setFrequencyUnit(frequencyUnitText);
            drugTokenAnt.setFuBegin(dm.getFUBegin());
            drugTokenAnt.setFuEnd(dm.getFUENd());
        } else if (recurseNER != null && recurseNER.getFrequencyUnit() != null) {
            drugTokenAnt.setFrequencyUnit(recurseNER.getFrequencyUnit());
            drugTokenAnt.setFuBegin(recurseNER.getFuBegin());
            drugTokenAnt.setFuEnd(recurseNER.getFuEnd());
        } else if (dm.getFrequencyElement() != null && dm.getFrequencyElement().compareTo("null") != 0 && dm.frequency != null) {
            drugTokenAnt.setFrequency(dm.getFrequencyElement());
            drugTokenAnt.setFrequencyBegin(dm.getFrequencyBegin());
            drugTokenAnt.setFrequencyEnd(dm.getFrequencyEnd());
        }
        if (dm.getRouteElement() != null && dm.getRouteElement().compareTo("") != 0 && dm.getRouteElement().compareTo("null") != 0) {
            keepScoreOfConfidence *= 1.3f;
            drugTokenAnt.setRoute(dm.getRouteElement());
            drugTokenAnt.setRouteBegin(dm.getRouteBegin());
            drugTokenAnt.setRouteEnd(dm.getRouteEnd());
        } else if (recurseNER != null && recurseNER.getRoute() != null) {
            drugTokenAnt.setRoute(recurseNER.getRoute());
            drugTokenAnt.setRouteBegin(recurseNER.getRouteBegin());
            drugTokenAnt.setRouteEnd(recurseNER.getRouteEnd());
        }
        return keepScoreOfConfidence;
    }

    private int[] statusChangePhraseGenerator(JCas jcas, int begin, int end, boolean maxExists, Iterator uniqueNER, Iterator orderedStatusChanges, List holdStatusChanges, String[] relatedStatus, DrugMentionAnnotation drugTokenAnt, List globalDrugNER, int countNER) throws Exception {
        int[] checkSpan = new int[]{begin, end};
        handledRanges = false;
        boolean deferRight = false;
        if (orderedStatusChanges.hasNext() && !handledRanges) {
            Iterator nextStatusChanges = this.sortAnnotations(holdStatusChanges.toArray()).iterator();
            DrugChangeStatusAnnotation nextDrugStatus = null;
            if (nextStatusChanges.hasNext()) {
                nextDrugStatus = (DrugChangeStatusAnnotation)((Object)nextStatusChanges.next());
            }
            DrugChangeStatusAnnotation drugStatus = (DrugChangeStatusAnnotation)((Object)orderedStatusChanges.next());
            if (nextStatusChanges.hasNext() && drugStatus.getChangeStatus().compareTo("stop") != 0) {
                nextDrugStatus = (DrugChangeStatusAnnotation)((Object)nextStatusChanges.next());
                if (drugStatus.getBegin() == nextDrugStatus.getBegin()) {
                    if (drugStatus.getEnd() < nextDrugStatus.getEnd()) {
                        drugStatus = nextDrugStatus;
                    } else {
                        nextDrugStatus = drugStatus;
                    }
                }
                if (!uniqueNER.hasNext()) {
                    if ((nextDrugStatus.getChangeStatus().compareTo("increase") == 0 || nextDrugStatus.getChangeStatus().compareTo("decrease") == 0 || nextDrugStatus.getChangeStatus().compareTo("change") == 0) && (drugStatus.getChangeStatus().compareTo("start") == 0 || drugStatus.getChangeStatus().compareTo("stop") == 0) || drugTokenAnt.getEnd() + 1 == drugStatus.getBegin()) {
                        drugStatus = nextDrugStatus;
                        deferRight = true;
                    }
                } else if (nextDrugStatus.getBegin() <= drugStatus.getEnd() + 2) {
                    if (orderedStatusChanges.hasNext() && nextDrugStatus.getBegin() != drugStatus.getBegin()) {
                        orderedStatusChanges.next();
                    } else if (!(nextDrugStatus.getChangeStatus().compareTo("increase") != 0 && nextDrugStatus.getChangeStatus().compareTo("decrease") != 0 && nextDrugStatus.getChangeStatus().compareTo("change") != 0 || drugStatus.getChangeStatus().compareTo("start") != 0 && drugStatus.getChangeStatus().compareTo("stop") != 0)) {
                        drugStatus = nextDrugStatus;
                    }
                }
                if (relatedStatus != null) {
                    end = nextDrugStatus.getBegin();
                }
            }
            if (drugStatus.getEnd() < end && !maxExists && (drugStatus.getEnd() != nextDrugStatus.getEnd() || drugStatus.getChangeStatus().compareTo("decrease") == 0 || drugStatus.getChangeStatus().compareTo("decreasefrom") == 0 || drugStatus.getChangeStatus().compareTo("increase") == 0 || drugStatus.getChangeStatus().compareTo("increasefrom") == 0) || drugStatus.getChangeStatus().compareTo("change") == 0) {
                checkSpan = this.generateAdditionalNER(jcas, drugTokenAnt, drugStatus, begin, end, countNER, globalDrugNER);
            }
        }
        return checkSpan;
    }

    private int[] generateAdditionalNER(JCas jcas, DrugMentionAnnotation tokenDrugNER, DrugChangeStatusAnnotation drugChangeStatus, int beginSpan, int endSpan, int count, List globalNER) throws Exception {
        boolean noPriorMention = false;
        boolean noPostMention = false;
        int originalEndSpan = endSpan;
        int originalBeginSpan = beginSpan;
        MedicationMention neAnnot = new MedicationMention(jcas, tokenDrugNER.getBegin(), tokenDrugNER.getEnd());
        int beginChunk = drugChangeStatus.getEnd();
        DrugMention compareDM = new DrugMention(jcas, beginChunk, endSpan);
        DrugMention priorDM = new DrugMention(jcas, beginSpan, drugChangeStatus.getBegin());
        if (priorDM.dosage == null && priorDM.strength == null && priorDM.frequency == null) {
            noPriorMention = true;
        }
        if (compareDM.dosage == null && compareDM.strength == null && compareDM.frequency == null) {
            noPostMention = true;
        }
        ++count;
        if (!noPriorMention) {
            if (priorDM.dosage != null) {
                tokenDrugNER.setDosage(priorDM.getDosageElement());
                tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
            }
            if (priorDM.strength != null) {
                tokenDrugNER.setStrength(priorDM.getStrengthElement());
                tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                tokenDrugNER.setStrengthUnit(priorDM.getStrengthUnitElement());
                tokenDrugNER.setSuBegin(priorDM.getStrengthUnitBegin());
                tokenDrugNER.setSuEnd(priorDM.getStrengthUnitEnd());
            }
            if (priorDM.frequency != null) {
                tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
            }
        }
        neAnnot.setTypeID(1);
        int[] updatedSpan = new int[]{beginSpan, endSpan};
        ArrayList<MedicationMention> buildNewNER = new ArrayList<MedicationMention>();
        buildNewNER.add(neAnnot);
        if (drugChangeStatus.getChangeStatus().compareTo("decrease") == 0) {
            int endChunk = 0;
            int startChunk = 0;
            int midChunk = 0;
            if (noPriorMention) {
                startChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[0];
                midChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0];
                endChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[1];
            }
            updatedSpan[0] = beginChunk;
            String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, midChunk, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                compareDM = new DrugMention(jcas, startChunk, endChunk);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                    tokenDrugNER.setStrengthUnit(compareDM.getStrengthUnitElement());
                    tokenDrugNER.setSuBegin(compareDM.getStrengthUnitBegin());
                    tokenDrugNER.setSuEnd(compareDM.getStrengthUnitEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("decreasefrom") == 0) {
            if (noPriorMention && (beginChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0]) == -1) {
                beginChunk = drugChangeStatus.getEnd();
            }
            String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                priorDM = new DrugMention(jcas, originalBeginSpan, beginChunk);
                if (priorDM.dosage != null) {
                    tokenDrugNER.setDosage(priorDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
                }
                if (priorDM.strength != null) {
                    tokenDrugNER.setStrength(priorDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                    tokenDrugNER.setStrengthUnit(compareDM.getStrengthUnitElement());
                    tokenDrugNER.setSuBegin(compareDM.getStrengthUnitBegin());
                    tokenDrugNER.setSuEnd(compareDM.getStrengthUnitEnd());
                }
                if (priorDM.frequency != null) {
                    tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("increase") == 0) {
            if (noPriorMention) {
                endSpan = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[0];
            }
            updatedSpan[0] = beginChunk;
            String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                compareDM = new DrugMention(jcas, endSpan, originalEndSpan);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                    tokenDrugNER.setStrengthUnit(compareDM.getStrengthUnitElement());
                    tokenDrugNER.setSuBegin(compareDM.getStrengthUnitBegin());
                    tokenDrugNER.setSuEnd(compareDM.getStrengthUnitEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("change");
        } else if (drugChangeStatus.getChangeStatus().compareTo("increasefrom") == 0) {
            int startChunk = 0;
            int endChunk = 0;
            int midChunk = 0;
            if (noPriorMention) {
                startChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[0];
                midChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false)[1];
                endChunk = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, true)[1];
            }
            String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
            this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, startChunk, endChunk, tokenDrugNER, changeStatusArray, count, globalNER);
            if (noPriorMention) {
                priorDM = new DrugMention(jcas, originalBeginSpan, midChunk);
                if (priorDM.dosage != null) {
                    tokenDrugNER.setDosage(priorDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
                }
                if (priorDM.strength != null) {
                    tokenDrugNER.setStrength(priorDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                    tokenDrugNER.setStrengthUnit(priorDM.getStrengthUnitElement());
                    tokenDrugNER.setSuBegin(priorDM.getStrengthUnitBegin());
                    tokenDrugNER.setSuEnd(priorDM.getStrengthUnitEnd());
                }
                if (priorDM.frequency != null) {
                    tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(priorDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(priorDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("noChange");
        } else if (drugChangeStatus.getChangeStatus().compareTo("stop") == 0) {
            tokenDrugNER.setDrugChangeStatus(tokenDrugNER.getDrugChangeStatus());
        } else if (drugChangeStatus.getChangeStatus().compareTo("change") == 0 || drugChangeStatus.getChangeStatus().compareTo("add") == 0) {
            double strengthChange = 1.0;
            double dosageChange = 1.0;
            double frequencyChange = 1.0;
            if (noPriorMention) {
                int[] updateSpan = this.getAdjustedWindowSpan(jcas, beginChunk, endSpan, false);
                compareDM = new DrugMention(jcas, endSpan, originalEndSpan);
                if (compareDM.dosage != null) {
                    tokenDrugNER.setDosage(compareDM.getDosageElement());
                    tokenDrugNER.setDosageBegin(compareDM.getDosageBegin());
                    tokenDrugNER.setDosageEnd(compareDM.getDosageEnd());
                }
                if (compareDM.strength != null) {
                    tokenDrugNER.setStrength(compareDM.getStrengthElement());
                    tokenDrugNER.setStrengthBegin(compareDM.getStrengthBegin());
                    tokenDrugNER.setStrengthEnd(compareDM.getStrengthEnd());
                    tokenDrugNER.setStrengthUnit(compareDM.getStrengthUnitElement());
                    tokenDrugNER.setSuBegin(compareDM.getStrengthUnitBegin());
                    tokenDrugNER.setSuEnd(compareDM.getStrengthUnitEnd());
                }
                if (compareDM.frequency != null) {
                    tokenDrugNER.setFrequency(compareDM.getFrequencyElement());
                    tokenDrugNER.setFrequencyBegin(compareDM.getFrequencyBegin());
                    tokenDrugNER.setFrequencyEnd(compareDM.getFrequencyEnd());
                }
            }
            tokenDrugNER.setDrugChangeStatus("change");
            if (compareDM.getStrengthElement() != null && compareDM.getStrengthElement().compareTo("") != 0 && compareDM != null) {
                strengthChange = new Double(compareDM.parseDoubleValue(compareDM.getStrengthElement()));
            } else if (priorDM.getStrengthElement() != null && priorDM.getStrengthElement().compareTo("") != 0 && priorDM.getStrengthElement().length() > 0) {
                int spacePosition = priorDM.getStrengthElement().indexOf(" ");
                strengthChange = spacePosition > 0 ? new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement().substring(0, spacePosition))).doubleValue() : new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement())).doubleValue();
            }
            if (compareDM.getDosageElement() != null && compareDM.getDosageElement().compareTo("") != 0) {
                dosageChange = new Double(compareDM.parseDoubleValue(compareDM.getDosageElement()));
            } else if (priorDM.getDosageElement() != null && priorDM.getDosageElement().compareTo("") != 0) {
                dosageChange = new Double(priorDM.parseDoubleValue(priorDM.getDosageElement()));
            }
            if (compareDM.getFrequencyElement() != null && compareDM.getFrequencyElement().compareTo("") != 0) {
                frequencyChange = new Double(compareDM.parseDoubleValue(compareDM.getFrequencyElement()));
            } else if (priorDM.getFrequencyElement() != null && priorDM.getFrequencyElement().compareTo("") != 0) {
                frequencyChange = new Double(priorDM.parseDoubleValue(priorDM.getFrequencyElement()));
            }
            double strengthBefore = 1.0;
            double dosageBefore = 1.0;
            double frequencyBefore = 1.0;
            if (priorDM.getStrengthElement() != null && priorDM.getStrengthElement().compareTo("") != 0 && priorDM.getStrengthElement().length() > 0) {
                strengthBefore = new Double(priorDM.parseDoubleValue(priorDM.getStrengthElement()));
                tokenDrugNER.setStrength(priorDM.getStrengthElement());
                tokenDrugNER.setStrengthBegin(priorDM.getStrengthBegin());
                tokenDrugNER.setStrengthEnd(priorDM.getStrengthEnd());
                tokenDrugNER.setStrengthUnit(priorDM.getStrengthUnitElement());
                tokenDrugNER.setSuBegin(priorDM.getStrengthUnitBegin());
                tokenDrugNER.setSuEnd(priorDM.getStrengthUnitEnd());
            } else if (tokenDrugNER.getStrength() != null && tokenDrugNER.getStrength().compareTo("") != 0 && tokenDrugNER.getStrength().length() > 0) {
                int spacePosition;
                boolean handledSeparator = false;
                int hyphPosition = tokenDrugNER.getStrength().indexOf(45);
                String hyphString = tokenDrugNER.getStrength();
                if (hyphPosition > 0) {
                    hyphString = tokenDrugNER.getStrength().substring(0, hyphPosition);
                    strengthBefore = new Double(compareDM.parseDoubleValue(compareDM.convertFromTextToNum(hyphString)));
                    handledSeparator = true;
                }
                if ((spacePosition = hyphString.indexOf(" ")) > 0) {
                    hyphString = hyphString.substring(0, spacePosition);
                    strengthBefore = new Double(priorDM.parseDoubleValue(priorDM.convertFromTextToNum(hyphString)));
                    handledSeparator = true;
                }
                if (!handledSeparator) {
                    strengthBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getStrength()));
                }
            }
            if (priorDM.getDosageElement() != null && priorDM.getDosageElement().compareTo("") != 0 && priorDM.dosage != null) {
                dosageBefore = new Double(priorDM.getDosageElement());
                tokenDrugNER.setDosage(priorDM.getDosageElement());
                tokenDrugNER.setDosageBegin(priorDM.getDosageBegin());
                tokenDrugNER.setDosageEnd(priorDM.getDosageEnd());
            } else if (tokenDrugNER.getDosage() != null && tokenDrugNER.getDosage().compareTo("") != 0) {
                dosageBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getDosage()));
            }
            if (priorDM.getFrequencyElement() != null && priorDM.getFrequencyElement().compareTo("") != 0) {
                frequencyBefore = new Double(priorDM.parseDoubleValue(priorDM.getFrequencyElement()));
                tokenDrugNER.setFrequency(priorDM.getFrequencyElement());
            } else if (tokenDrugNER.getFrequency() != null && tokenDrugNER.getFrequency().compareTo("") != 0) {
                frequencyBefore = new Double(compareDM.parseDoubleValue(tokenDrugNER.getFrequency()));
            }
            if (drugChangeStatus.getChangeStatus().compareTo("add") == 0 && (strengthChange > 1.0 && strengthBefore > 1.0 || strengthChange == strengthBefore)) {
                FSIterator findLF = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)NewlineToken.type, (int)neAnnot.getBegin(), (int)beginChunk);
                if (!findLF.hasNext()) {
                    if (frequencyChange <= 1.0 && frequencyBefore > 1.0) {
                        tokenDrugNER.setFrequency("1.0");
                    }
                    String[] changeStatusArray = new String[]{"add", new Integer(0).toString(), new Integer(0).toString()};
                    this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
                }
            } else if (strengthChange * dosageChange * frequencyChange > strengthBefore * dosageBefore * frequencyBefore) {
                String[] changeStatusArray = new String[]{"increase", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
                this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            } else {
                String[] changeStatusArray = new String[]{"decrease", new Integer(drugChangeStatus.getBegin()).toString(), new Integer(drugChangeStatus.getEnd()).toString()};
                this.generateDrugMentionsAndAnnotations(jcas, buildNewNER, beginChunk, endSpan, tokenDrugNER, changeStatusArray, count, globalNER);
            }
            tokenDrugNER.setDrugChangeStatus("change");
        }
        return updatedSpan;
    }

    private org.apache.ctakes.core.fsm.token.BaseToken adaptToFSMBaseToken(BaseToken obj) throws Exception {
        if (obj instanceof WordToken) {
            WordToken wta = (WordToken)obj;
            return new WordTokenAdapter(wta);
        }
        if (obj instanceof NumToken) {
            NumToken nta = (NumToken)obj;
            if (nta.getNumType() == 1) {
                return new IntegerTokenAdapter(nta);
            }
            return new DecimalTokenAdapter(nta);
        }
        if (obj instanceof PunctuationToken) {
            PunctuationToken pta = (PunctuationToken)obj;
            return new PunctuationTokenAdapter(pta);
        }
        if (obj instanceof NewlineToken) {
            NewlineToken nta = (NewlineToken)obj;
            return new NewlineTokenAdapter(nta);
        }
        if (obj instanceof ContractionToken) {
            ContractionToken cta = (ContractionToken)obj;
            return new ContractionTokenAdapter(cta);
        }
        if (obj instanceof SymbolToken) {
            SymbolToken sta = (SymbolToken)obj;
            return new SymbolTokenAdapter(sta);
        }
        throw new Exception("No CDT adapter for class: " + obj.getClass());
    }

    private int[] findNextDrugEntityPost(int spanLength, int[][] elementSpan, MedicationMention nea, int endPhrase) {
        boolean patternFound = false;
        int[] locationPre = new int[]{-1, -1};
        for (int l = 0; l < spanLength && !patternFound; ++l) {
            if (elementSpan[l][0] == -1 || elementSpan[l][0] <= nea.getBegin() || elementSpan[l][0] >= endPhrase) continue;
            patternFound = true;
            locationPre = elementSpan[l];
        }
        return locationPre;
    }

    private int[] findNextDrugEntityPre(int spanLength, int[][] elementSpan, MedicationMention nea, int priorDrugEnd) {
        int numElementsInSpan = 0;
        int targetForNewSpan = 0;
        int[] locationPre = new int[]{-1, -1};
        for (int l = 0; l < spanLength; ++l) {
            if (elementSpan[l][0] != -1 && elementSpan[l][1] < nea.getBegin() && elementSpan[l][0] > priorDrugEnd) {
                ++numElementsInSpan;
                targetForNewSpan = elementSpan[l][0];
            }
            if (l == 2) {
                locationPre[1] = targetForNewSpan;
            }
            locationPre[0] = numElementsInSpan;
        }
        return locationPre;
    }

    private boolean findNextParenRelativeToNE(int spanLength, int[][] elementSpan, MedicationMention nea, int priorDrugEnd, int startOffset) {
        boolean patternFound = false;
        for (int l = startOffset; l < spanLength && !patternFound; ++l) {
            if (elementSpan[l][0] == -1 || elementSpan[l][0] >= nea.getBegin() || elementSpan[l][1] <= priorDrugEnd) continue;
            patternFound = true;
        }
        return patternFound;
    }

    private boolean findNextParenRelativeToElement(int spanLength, int[][] elementSpan, Annotation nea, int parenEnd, int startOffset) {
        boolean patternFound = false;
        for (int l = startOffset; l < spanLength && !patternFound; ++l) {
            if (elementSpan[l][0] == -1 || elementSpan[l][0] >= nea.getBegin() || elementSpan[l][1] != parenEnd || nea.getEnd() >= elementSpan[l][1]) continue;
            patternFound = true;
        }
        return patternFound;
    }

    private boolean hasMultipleDrugsInSpan(JCas jcas, int begin, int end) {
        int[] validNeTypes = new int[]{1, 0};
        int numDrugs = FSUtil.countAnnotationsInSpan((JCas)jcas, (int)MedicationMention.type, (int)begin, (int)end, (int[])validNeTypes);
        return numDrugs > 1;
    }

    private boolean hasMultipleElementsInSpan(JCas jcas, int begin, int end) {
        int numElements = 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)StrengthAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)FrequencyAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)FrequencyUnitAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)DosagesAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)FormAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)RouteAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)DurationAnnotation.type, (int)begin, (int)end) ? 1 : 0;
        return (numElements += FSUtil.isAnnotationPresentInSpan((JCas)jcas, (int)DrugChangeStatusAnnotation.type, (int)begin, (int)end) ? 1 : 0) > 1;
    }

    private int[] getSentenceSpanContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[2];
        while (iter.hasNext()) {
            Sentence sa = (Sentence)iter.next();
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            span[0] = sa.getBegin();
            span[1] = sa.getEnd();
            break;
        }
        return span;
    }

    private int[] getNarrativeSpansContainingGivenSpanType(JCas jcas, int begin, int annotType) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(annotType).iterator();
        int[] span = new int[2];
        boolean foundFirstTypeSpan = false;
        boolean foundSecondTypeSpan = false;
        int spanSizeCount = 0;
        while (iter.hasNext() && !foundSecondTypeSpan) {
            Annotation sa = (Annotation)iter.next();
            if (begin >= sa.getBegin() && begin <= sa.getEnd()) {
                span[0] = sa.getBegin();
                span[1] = sa.getEnd();
                foundFirstTypeSpan = true;
            } else if (foundFirstTypeSpan && spanSizeCount >= this.iWindowSize) {
                foundSecondTypeSpan = true;
                span[1] = sa.getEnd();
            }
            if (!foundFirstTypeSpan) continue;
            ++spanSizeCount;
        }
        return span;
    }

    private void findFSMInRange(JCas jcas, int begin, int end) throws Exception {
        MedicationMention ne = null;
        WordToken we = null;
        FSIterator btaItr = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)BaseToken.type, (int)begin, (int)(end + 1));
        FSIterator neItr = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)MedicationMention.type, (int)begin, (int)(end + 1));
        FSIterator weItr = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)WordToken.type, (int)begin, (int)(end + 1));
        ArrayList<WordToken> weTokenList = new ArrayList<WordToken>();
        while (weItr.hasNext()) {
            we = (WordToken)weItr.next();
            weTokenList.add(we);
        }
        ArrayList<MedicationMention> neTokenList = new ArrayList<MedicationMention>();
        while (neItr.hasNext()) {
            ne = (MedicationMention)neItr.next();
            neTokenList.add(ne);
        }
        ArrayList<org.apache.ctakes.core.fsm.token.BaseToken> baseTokenList = new ArrayList<org.apache.ctakes.core.fsm.token.BaseToken>();
        while (btaItr.hasNext()) {
            BaseToken bta = (BaseToken)btaItr.next();
            baseTokenList.add(this.adaptToFSMBaseToken(bta));
        }
        this.executeFSMs(jcas, baseTokenList, neTokenList, weTokenList);
    }

    private int[] findOffsetsInPattern(JCas jcas, int begin, int end, int elementType, int[][] location, boolean highest) {
        int[] lastLocation;
        block11: {
            boolean wantMuliple;
            FSIterator neItr;
            block14: {
                block13: {
                    block12: {
                        block10: {
                            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                            neItr = indexes.getAnnotationIndex(elementType).iterator();
                            lastLocation = new int[]{-1, -1};
                            wantMuliple = true;
                            if (elementType != StrengthUnitAnnotation.type) break block10;
                            while (neItr.hasNext() && wantMuliple) {
                                StrengthUnitAnnotation nea = (StrengthUnitAnnotation)((Object)neItr.next());
                                if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                                if (!highest) {
                                    wantMuliple = false;
                                }
                                lastLocation[0] = nea.getBegin();
                                lastLocation[1] = nea.getEnd();
                            }
                            break block11;
                        }
                        if (elementType != StrengthAnnotation.type) break block12;
                        while (neItr.hasNext() && wantMuliple) {
                            StrengthAnnotation nea = (StrengthAnnotation)((Object)neItr.next());
                            if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                            if (!highest) {
                                wantMuliple = false;
                            }
                            lastLocation[0] = nea.getBegin();
                            lastLocation[1] = nea.getEnd();
                        }
                        break block11;
                    }
                    if (elementType != FrequencyAnnotation.type) break block13;
                    while (neItr.hasNext() && wantMuliple) {
                        FrequencyAnnotation nea = (FrequencyAnnotation)((Object)neItr.next());
                        if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                        if (!highest) {
                            wantMuliple = false;
                        }
                        lastLocation[0] = nea.getBegin();
                        lastLocation[1] = nea.getEnd();
                    }
                    break block11;
                }
                if (elementType != FrequencyUnitAnnotation.type) break block14;
                while (neItr.hasNext() && wantMuliple) {
                    FrequencyUnitAnnotation nea = (FrequencyUnitAnnotation)((Object)neItr.next());
                    if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                    if (!highest) {
                        wantMuliple = false;
                    }
                    lastLocation[0] = nea.getBegin();
                    lastLocation[1] = nea.getEnd();
                }
                break block11;
            }
            if (elementType != DosagesAnnotation.type) break block11;
            while (neItr.hasNext() && wantMuliple) {
                DosagesAnnotation nea = (DosagesAnnotation)((Object)neItr.next());
                if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                if (!highest) {
                    wantMuliple = false;
                }
                lastLocation[0] = nea.getBegin();
                lastLocation[1] = nea.getEnd();
            }
        }
        return lastLocation;
    }

    private int[] getAdjustedWindowSpan(JCas jcas, int begin, int end, boolean highestRange) throws Exception {
        int[] spanStrength = new int[]{-1, -1};
        int[] spanFrequency = new int[]{-1, -1};
        int[] spanDose = new int[]{-1, -1};
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        int[] senSpan = new int[]{begin, end};
        int[][] strengthSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] freqSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] doseSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] parenthesisSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        int[][] statusSpan = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}};
        boolean drugSpanLength = false;
        int strengthSpanLength = 0;
        int freqSpanLength = 0;
        int doseSpanLength = 0;
        int beginSpan = senSpan[0];
        int endSpan = senSpan[1];
        doseSpanLength = this.findInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan);
        int parenthesisSpanLength = this.findInPattern(jcas, beginSpan, endSpan, PunctuationToken.type, parenthesisSpan);
        if (highestRange) {
            freqSpanLength = this.findInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, freqSpan);
            spanFrequency = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, strengthSpan, highestRange);
            strengthSpanLength = this.findInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan);
            spanStrength = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan, highestRange);
        } else {
            freqSpanLength = this.findInPattern(jcas, beginSpan, endSpan, FrequencyUnitAnnotation.type, freqSpan);
            spanFrequency = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyUnitAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, FrequencyUnitAnnotation.type, strengthSpan, highestRange);
            strengthSpanLength = this.findInPattern(jcas, beginSpan, endSpan, StrengthUnitAnnotation.type, strengthSpan);
            spanStrength = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthUnitAnnotation.type, strengthSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, StrengthUnitAnnotation.type, strengthSpan, highestRange);
        }
        int[] nArray = spanDose = highestRange ? this.findOffsetsInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan, highestRange) : this.findOffsetsInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan, highestRange);
        if (spanStrength[0] == -1 && spanFrequency[0] == -1 && spanDose[0] == -1) {
            return senSpan;
        }
        if (highestRange && spanStrength[0] != -1) {
            senSpan = spanStrength[0] > spanFrequency[0] ? spanStrength : spanFrequency;
        } else if (spanFrequency[0] != -1 && spanStrength[0] != -1) {
            senSpan = spanStrength[0] < spanFrequency[0] ? spanStrength : spanFrequency;
        }
        return spanDose[0] > senSpan[0] ? spanDose : senSpan;
    }

    private int findInPattern(JCas jcas, int begin, int end, int elementType, int[][] location) {
        int counter;
        block15: {
            int[] lastLocation;
            FSIterator neItr;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block14: {
                                                    JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                                                    neItr = indexes.getAnnotationIndex(elementType).iterator();
                                                    lastLocation = new int[]{-1, -1};
                                                    counter = 0;
                                                    if (elementType != StrengthUnitAnnotation.type) break block14;
                                                    while (neItr.hasNext()) {
                                                        StrengthUnitAnnotation nea = (StrengthUnitAnnotation)((Object)neItr.next());
                                                        lastLocation[0] = nea.getBegin();
                                                        lastLocation[1] = nea.getEnd();
                                                        if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                                        location[counter][0] = lastLocation[0];
                                                        location[counter][1] = lastLocation[1];
                                                        ++counter;
                                                    }
                                                    break block15;
                                                }
                                                if (elementType != StrengthAnnotation.type) break block16;
                                                while (neItr.hasNext()) {
                                                    StrengthAnnotation nea = (StrengthAnnotation)((Object)neItr.next());
                                                    lastLocation[0] = nea.getBegin();
                                                    lastLocation[1] = nea.getEnd();
                                                    if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                                    location[counter][0] = lastLocation[0];
                                                    location[counter][1] = lastLocation[1];
                                                    ++counter;
                                                }
                                                break block15;
                                            }
                                            if (elementType != FrequencyAnnotation.type) break block17;
                                            while (neItr.hasNext()) {
                                                FrequencyAnnotation nea = (FrequencyAnnotation)((Object)neItr.next());
                                                lastLocation[0] = nea.getBegin();
                                                lastLocation[1] = nea.getEnd();
                                                if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                                location[counter][0] = lastLocation[0];
                                                location[counter][1] = lastLocation[1];
                                                ++counter;
                                            }
                                            break block15;
                                        }
                                        if (elementType != FrequencyUnitAnnotation.type) break block18;
                                        while (neItr.hasNext()) {
                                            FrequencyUnitAnnotation nea = (FrequencyUnitAnnotation)((Object)neItr.next());
                                            lastLocation[0] = nea.getBegin();
                                            lastLocation[1] = nea.getEnd();
                                            if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                            location[counter][0] = lastLocation[0];
                                            location[counter][1] = lastLocation[1];
                                            ++counter;
                                        }
                                        break block15;
                                    }
                                    if (elementType != DosagesAnnotation.type) break block19;
                                    while (neItr.hasNext()) {
                                        DosagesAnnotation nea = (DosagesAnnotation)((Object)neItr.next());
                                        lastLocation[0] = nea.getBegin();
                                        lastLocation[1] = nea.getEnd();
                                        if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                        location[counter][0] = lastLocation[0];
                                        location[counter][1] = lastLocation[1];
                                        ++counter;
                                    }
                                    break block15;
                                }
                                if (elementType != RouteAnnotation.type) break block20;
                                while (neItr.hasNext()) {
                                    RouteAnnotation nea = (RouteAnnotation)((Object)neItr.next());
                                    lastLocation[0] = nea.getBegin();
                                    lastLocation[1] = nea.getEnd();
                                    if (nea.getBegin() < begin || nea.getEnd() > end) continue;
                                    location[counter][0] = lastLocation[0];
                                    location[counter][1] = lastLocation[1];
                                    ++counter;
                                }
                                break block15;
                            }
                            if (elementType != FormAnnotation.type) break block21;
                            while (neItr.hasNext()) {
                                FormAnnotation nea = (FormAnnotation)((Object)neItr.next());
                                lastLocation[0] = nea.getBegin();
                                lastLocation[1] = nea.getEnd();
                                if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                                location[counter][0] = lastLocation[0];
                                location[counter][1] = lastLocation[1];
                                ++counter;
                            }
                            break block15;
                        }
                        if (elementType != DurationAnnotation.type) break block22;
                        while (neItr.hasNext()) {
                            DurationAnnotation nea = (DurationAnnotation)((Object)neItr.next());
                            lastLocation[0] = nea.getBegin();
                            lastLocation[1] = nea.getEnd();
                            if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                            location[counter][0] = lastLocation[0];
                            location[counter][1] = lastLocation[1];
                            ++counter;
                        }
                        break block15;
                    }
                    if (elementType != DrugChangeStatusAnnotation.type) break block23;
                    while (neItr.hasNext()) {
                        DrugChangeStatusAnnotation nea = (DrugChangeStatusAnnotation)((Object)neItr.next());
                        lastLocation[0] = nea.getBegin();
                        lastLocation[1] = nea.getEnd();
                        if (nea.getBegin() < begin || nea.getEnd() > end || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                        location[counter][0] = lastLocation[0];
                        location[counter][1] = lastLocation[1];
                        ++counter;
                    }
                    break block15;
                }
                if (elementType != MedicationMention.type) break block24;
                while (neItr.hasNext()) {
                    MedicationMention nea = (MedicationMention)neItr.next();
                    if (nea.getTypeID() != 1 && nea.getTypeID() != 0) continue;
                    lastLocation[0] = nea.getBegin();
                    lastLocation[1] = nea.getEnd();
                    if (counter != 0 && lastLocation[0] == location[counter - 1][0] || nea.getBegin() < begin || nea.getEnd() > end) continue;
                    location[counter][0] = lastLocation[0];
                    location[counter][1] = lastLocation[1];
                    ++counter;
                }
                break block15;
            }
            if (elementType != PunctuationToken.type) break block15;
            while (neItr.hasNext()) {
                boolean foundPair = false;
                PunctuationToken nea = (PunctuationToken)neItr.next();
                if (nea.getCoveredText().compareTo("(") == 0) {
                    lastLocation[0] = nea.getBegin();
                } else if (nea.getCoveredText().compareTo(")") == 0) {
                    lastLocation[1] = nea.getEnd();
                    foundPair = true;
                }
                if (nea.getBegin() < begin || nea.getEnd() > end || !foundPair || counter != 0 && (counter <= 0 || lastLocation[0] == location[counter - 1][0])) continue;
                location[counter][0] = lastLocation[0];
                location[counter][1] = lastLocation[1];
                ++counter;
            }
        }
        return counter;
    }

    private int[][] getWindowSpan(JCas jcas, String sectionType, int typeAnnotation, int begin, int end, boolean useBegin, int sizeArrays) throws Exception {
        boolean haveNarrative;
        int[] senSpan = new int[]{begin, end};
        int[][] spanSoloTerm = new int[][]{{-1, -1}};
        boolean lastLineNum = false;
        boolean bl = haveNarrative = sectionType.compareTo("narrative") == 0;
        if (haveNarrative && (senSpan = this.getNarrativeSpansContainingGivenSpanType(jcas, begin, this.iAnnotationType))[0] < begin) {
            senSpan[0] = begin;
        }
        boolean hasMultipleDrugs = this.multipleDrugsInSpan(jcas, senSpan[0], senSpan[1]);
        boolean hasFSMrun = this.multipleElementsInSpan(jcas, senSpan[0], senSpan[1]);
        if (!hasFSMrun) {
            if (haveNarrative) {
                if (!useBegin) {
                    this.findFSMInRange(jcas, senSpan[0], senSpan[1]);
                } else {
                    this.findFSMInRange(jcas, begin, senSpan[1]);
                }
            } else {
                this.findFSMInRange(jcas, begin, end);
            }
        }
        spanSoloTerm[0] = senSpan;
        if (hasMultipleDrugs) {
            return this.sortSignatureElements(jcas, begin, end, typeAnnotation, senSpan, sizeArrays);
        }
        return spanSoloTerm;
    }

    private boolean multipleDrugsInSpan(JCas jcas, int begin, int end) {
        FSIterator neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)MedicationMention.type, (int)begin, (int)end);
        int numDrugs = 0;
        int beginOffset = 0;
        while (neItr.hasNext()) {
            MedicationMention nea = (MedicationMention)neItr.next();
            if ((nea.getTypeID() == 1 || nea.getTypeID() == 0) && beginOffset != nea.getBegin()) {
                ++numDrugs;
            }
            beginOffset = nea.getBegin();
        }
        return numDrugs > 1;
    }

    private boolean multipleElementsInSpan(JCas jcas, int begin, int end) {
        Annotation nea;
        FSIterator neItr = null;
        int numElements = 0;
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)StrengthAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (StrengthAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)FrequencyAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (FrequencyAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)FrequencyUnitAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (FrequencyUnitAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DosagesAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (DosagesAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)FormAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (FormAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)RouteAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (RouteAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DurationAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (DurationAnnotation)((Object)neItr.next());
            ++numElements;
        }
        neItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)DrugChangeStatusAnnotation.type, (int)begin, (int)end);
        while (neItr.hasNext()) {
            nea = (DrugChangeStatusAnnotation)((Object)neItr.next());
            ++numElements;
        }
        return numElements > 1;
    }

    private int[][] sortSignatureElements(JCas jcas, int begin, int end, int typeAnnotation, int[] senSpan, int sizeArray) {
        String prePattern = "";
        String pattern = "";
        String postPattern = "";
        String groupDelimiterOpen = "(";
        String groupDelimiterClose = ")";
        int[][] drugSpan = new int[sizeArray][2];
        int[][] strengthSpan = new int[sizeArray][2];
        int[][] freqSpan = new int[sizeArray][2];
        int[][] doseSpan = new int[sizeArray][2];
        int[][] freqUSpan = new int[sizeArray][2];
        int[][] routeSpan = new int[sizeArray][2];
        int[][] formSpan = new int[sizeArray][2];
        int[][] durationSpan = new int[sizeArray][2];
        int[][] parenthesisSpan = new int[sizeArray][2];
        int[][] statusSpan = new int[sizeArray * 10][2];
        for (int a = 0; a < sizeArray; ++a) {
            for (int b = 0; b < 2; ++b) {
                statusSpan[a][b] = -1;
                parenthesisSpan[a][b] = -1;
                durationSpan[a][b] = -1;
                formSpan[a][b] = -1;
                routeSpan[a][b] = -1;
                freqUSpan[a][b] = -1;
                doseSpan[a][b] = -1;
                freqSpan[a][b] = -1;
                strengthSpan[a][b] = -1;
                drugSpan[a][b] = -1;
            }
        }
        int drugSpanLength = 0;
        int strengthSpanLength = 0;
        int freqSpanLength = 0;
        int doseSpanLength = 0;
        int freqUSpanLength = 0;
        int formSpanLength = 0;
        int routeSpanLength = 0;
        int durationSpanLength = 0;
        int newLineSpanLength = 0;
        int beginSpan = senSpan[0];
        int endSpan = senSpan[1];
        drugSpanLength = this.lastInPattern(jcas, begin, endSpan, typeAnnotation, drugSpan);
        strengthSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, StrengthAnnotation.type, strengthSpan);
        freqSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, FrequencyAnnotation.type, freqSpan);
        doseSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, DosagesAnnotation.type, doseSpan);
        freqUSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, FrequencyUnitAnnotation.type, freqUSpan);
        formSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, FormAnnotation.type, formSpan);
        routeSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, RouteAnnotation.type, routeSpan);
        durationSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, DurationAnnotation.type, durationSpan);
        newLineSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, NewlineToken.type, statusSpan);
        int parenthesisSpanLength = this.lastInPattern(jcas, beginSpan, endSpan, PunctuationToken.type, parenthesisSpan);
        int priorDrugEnd = 0;
        int[] typeFoundS = new int[]{0, 0};
        int[] typeFoundF = new int[]{0, 0};
        int[] typeFoundN = new int[]{0, 0};
        int[] typeFoundU = new int[]{0, 0};
        int[] typeFoundR = new int[]{0, 0};
        int[] typeFoundM = new int[]{0, 0};
        int[] typeFoundL = new int[]{0, 0};
        int typeFoundC = 0;
        int[][] drugSpanArray = new int[drugSpanLength][2];
        boolean openParenFound = false;
        boolean shareAttributes = false;
        int targetValueInRange = 0;
        int endPhrase = senSpan[1];
        int beginPhrase = senSpan[0];
        if (drugSpanLength > 1) {
            for (int j = 0; j < drugSpanLength; ++j) {
                FSIterator drugListItr = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)MedicationMention.type, (int)drugSpan[j][0], (int)(drugSpan[j][1] + 1));
                FSIterator drugListItrNext = FSUtil.getAnnotationsIteratorInSpan((JCas)jcas, (int)MedicationMention.type, (int)drugSpan[j + 1][0], (int)(drugSpan[j + 1][1] + 1));
                if (drugListItr.hasNext()) {
                    MedicationMention nea = (MedicationMention)drugListItr.next();
                    drugSpanArray[j][0] = nea.getBegin();
                    boolean patternFound = false;
                    boolean hasNext = true;
                    boolean isPairedDrug = false;
                    boolean usingLeftParenthesisExclusive = false;
                    boolean usingLeftParenthesisInclusive = false;
                    boolean usingRightParenthesisInclusive = false;
                    boolean endRange = false;
                    int countMultiplePre = 0;
                    int highestInRange = 32;
                    int lowestPositiveInRange = 32;
                    int lowestInRange = 32;
                    int highestValueInRange = 0;
                    int lowestValueInRange = 0;
                    int lowestPositiveValueInRange = endPhrase;
                    if (drugListItrNext.hasNext()) {
                        MedicationMention neaNext = (MedicationMention)drugListItrNext.next();
                        endPhrase = neaNext.getBegin();
                    } else {
                        hasNext = false;
                        endPhrase = senSpan[1];
                    }
                    int[] testForMultipleElementsInRange = new int[]{0, 0};
                    if (priorDrugEnd == 0) {
                        priorDrugEnd = begin;
                    }
                    if (this.findNextParenRelativeToNE(parenthesisSpanLength - 1, parenthesisSpan, nea, nea.getEnd())) {
                        openParenFound = true;
                        pattern = pattern + "(D";
                    } else {
                        pattern = pattern + "D";
                    }
                    char[] signCharElements = new char[]{'S', 'F', 'N', 'U', 'R', 'M', 'L', 'C'};
                    block13: for (int x = 0; x < signCharElements.length; ++x) {
                        switch (x) {
                            case 0: {
                                typeFoundS = this.findElementRelativeToNE(strengthSpan, parenthesisSpan, strengthSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundS[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundS[1] > 0) {
                                    if (typeFoundS[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundS[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundS[0] > 1 && typeFoundS[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundS[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(strengthSpanLength, strengthSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundS[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundS[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundS[1] >= lowestValueInRange || typeFoundS[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundS[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 1: {
                                typeFoundF = this.findElementRelativeToNE(freqSpan, parenthesisSpan, freqSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundF[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundF[1] > 0) {
                                    if (typeFoundF[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundF[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundF[0] > 1 && typeFoundF[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundS[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(freqSpanLength, freqSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundF[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundF[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundF[1] >= lowestValueInRange || typeFoundF[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundF[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 2: {
                                typeFoundN = this.findElementRelativeToNE(doseSpan, parenthesisSpan, doseSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundN[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundN[1] > 0) {
                                    if (typeFoundN[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundN[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundN[0] > 1 && typeFoundN[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundN[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(doseSpanLength, doseSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundN[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundN[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundN[1] >= lowestValueInRange || typeFoundN[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundN[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 3: {
                                typeFoundU = this.findElementRelativeToNE(freqUSpan, parenthesisSpan, freqUSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundU[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundU[1] > 0) {
                                    if (typeFoundU[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundU[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundU[0] > 1 && typeFoundU[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundU[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(freqUSpanLength, freqUSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundU[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundU[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundU[1] >= lowestValueInRange || typeFoundU[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundU[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 4: {
                                typeFoundR = this.findElementRelativeToNE(routeSpan, parenthesisSpan, routeSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundR[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundR[1] > 0) {
                                    if (typeFoundR[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundR[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundR[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundR[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(routeSpanLength, routeSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundR[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundR[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundR[1] >= lowestValueInRange || typeFoundR[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundR[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 5: {
                                typeFoundM = this.findElementRelativeToNE(formSpan, parenthesisSpan, formSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundM[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundM[1] > 0) {
                                    if (typeFoundM[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundM[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundM[0] > 1 && typeFoundM[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundM[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(formSpanLength, formSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundM[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundM[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundM[1] >= lowestValueInRange || typeFoundM[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundM[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 6: {
                                typeFoundL = this.findElementRelativeToNE(durationSpan, parenthesisSpan, durationSpanLength, parenthesisSpanLength, priorDrugEnd, 0, endPhrase, nea);
                                if (typeFoundL[0] > 1) {
                                    ++countMultiplePre;
                                }
                                if (typeFoundL[1] > 0) {
                                    if (typeFoundL[1] > highestValueInRange) {
                                        highestValueInRange = typeFoundL[1];
                                        highestInRange = signCharElements[x];
                                    }
                                    if (typeFoundL[0] > 1 && typeFoundL[1] < lowestPositiveValueInRange) {
                                        lowestPositiveValueInRange = typeFoundL[1];
                                        lowestPositiveInRange = signCharElements[x];
                                        testForMultipleElementsInRange = this.findNextDrugEntityPre(durationSpanLength, durationSpan, nea, priorDrugEnd);
                                    }
                                    if (typeFoundL[1] == 1) {
                                        pattern = pattern + signCharElements[x];
                                        continue block13;
                                    }
                                    postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                                    continue block13;
                                }
                                if (typeFoundL[1] >= 0) continue block13;
                                prePattern = prePattern + signCharElements[x];
                                if (typeFoundL[1] >= lowestValueInRange || typeFoundL[0] <= 1) continue block13;
                                lowestValueInRange = typeFoundL[1];
                                lowestInRange = signCharElements[x];
                                continue block13;
                            }
                            case 7: {
                                typeFoundC = this.anchorEndofline(statusSpan, newLineSpanLength, endPhrase, nea);
                                if (typeFoundC <= 0) continue block13;
                                if (typeFoundC == 1) {
                                    pattern = pattern + signCharElements[x];
                                    continue block13;
                                }
                                postPattern = postPattern + (char)(Byte.valueOf((byte)signCharElements[x]).intValue() + 32);
                            }
                        }
                    }
                    if (openParenFound) {
                        pattern = pattern + groupDelimiterClose;
                    }
                    if (j > 0 && pattern.endsWith("(D)") && countMultiplePre == 0) {
                        shareAttributes = true;
                        if (highestValueInRange < typeFoundC) {
                            drugSpanArray[j - 1][1] = nea.getBegin() + typeFoundC;
                        } else {
                            int n = nea.getBegin() + highestValueInRange;
                            drugSpanArray[j][1] = n;
                            drugSpanArray[j - 1][1] = n;
                        }
                    } else if (!(j <= 0 || countMultiplePre <= 1 && testForMultipleElementsInRange[0] <= 2 || testForMultipleElementsInRange[1] <= 0 || shareAttributes && !hasNext)) {
                        drugSpanArray[j - 1][1] = testForMultipleElementsInRange[1];
                    } else {
                        shareAttributes = false;
                    }
                    if (postPattern.endsWith("c") || pattern.endsWith("C")) {
                        drugSpanArray[j][1] = nea.getBegin() + typeFoundC;
                    } else if (!shareAttributes) {
                        drugSpanArray[j][1] = endPhrase;
                    }
                    if (j > 0 && drugSpanArray[j - 1][1] < drugSpanArray[j][0] && typeFoundC < 0) {
                        drugSpanArray[j][0] = priorDrugEnd = drugSpanArray[j - 1][1];
                    } else {
                        priorDrugEnd = nea.getEnd();
                    }
                    targetValueInRange = highestValueInRange;
                    pattern = pattern + postPattern;
                    openParenFound = false;
                }
                prePattern = "";
                postPattern = "";
                typeFoundS[1] = 0;
                typeFoundF[1] = 0;
                typeFoundC = 0;
                typeFoundR[1] = 0;
                typeFoundU[1] = 0;
                typeFoundN[1] = 0;
                typeFoundL[1] = 0;
                typeFoundM[1] = 0;
            }
        }
        if (pattern.lastIndexOf(groupDelimiterOpen) > pattern.lastIndexOf(groupDelimiterClose)) {
            pattern = pattern + groupDelimiterClose;
        }
        return drugSpanArray;
    }

    private boolean findNextParenRelativeToNE(int spanLength, int[][] elementSpan, MedicationMention nea, int priorDrugEnd) {
        boolean patternFound = false;
        for (int l = 0; l <= spanLength && !patternFound; ++l) {
            if (elementSpan[l][0] == -1 || elementSpan[l][0] >= nea.getBegin() || elementSpan[l][1] <= priorDrugEnd) continue;
            patternFound = true;
        }
        return patternFound;
    }

    private int lastInPattern(JCas jcas, int begin, int end, int elementType, int[][] location) {
        int counter;
        block15: {
            int[] lastLocation;
            FSIterator neItr;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block14: {
                                                JFSIndexRepository indexes = jcas.getJFSIndexRepository();
                                                neItr = indexes.getAnnotationIndex(elementType).iterator();
                                                lastLocation = new int[]{-1, -1};
                                                counter = 0;
                                                if (elementType != StrengthAnnotation.type) break block14;
                                                int holdBeginElement = 0;
                                                int holdEndElement = 0;
                                                while (neItr.hasNext()) {
                                                    StrengthAnnotation nea = (StrengthAnnotation)((Object)neItr.next());
                                                    lastLocation[0] = nea.getBegin();
                                                    lastLocation[1] = nea.getEnd();
                                                    if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                                    int n = lastLocation[0];
                                                    location[counter][0] = n;
                                                    holdBeginElement = n;
                                                    int n2 = lastLocation[1];
                                                    location[counter][1] = n2;
                                                    holdEndElement = n2;
                                                    ++counter;
                                                }
                                                break block15;
                                            }
                                            if (elementType != FrequencyAnnotation.type) break block16;
                                            int holdBeginElement = 0;
                                            int holdEndElement = 0;
                                            while (neItr.hasNext()) {
                                                FrequencyAnnotation nea = (FrequencyAnnotation)((Object)neItr.next());
                                                lastLocation[0] = nea.getBegin();
                                                lastLocation[1] = nea.getEnd();
                                                if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                                int n = lastLocation[0];
                                                location[counter][0] = n;
                                                holdBeginElement = n;
                                                int n3 = lastLocation[1];
                                                location[counter][1] = n3;
                                                holdEndElement = n3;
                                                ++counter;
                                            }
                                            break block15;
                                        }
                                        if (elementType != FrequencyUnitAnnotation.type) break block17;
                                        int holdBeginElement = 0;
                                        int holdEndElement = 0;
                                        while (neItr.hasNext()) {
                                            FrequencyUnitAnnotation nea = (FrequencyUnitAnnotation)((Object)neItr.next());
                                            lastLocation[0] = nea.getBegin();
                                            lastLocation[1] = nea.getEnd();
                                            if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                            int n = lastLocation[0];
                                            location[counter][0] = n;
                                            holdBeginElement = n;
                                            int n4 = lastLocation[1];
                                            location[counter][1] = n4;
                                            holdEndElement = n4;
                                            ++counter;
                                        }
                                        break block15;
                                    }
                                    if (elementType != DosagesAnnotation.type) break block18;
                                    int holdBeginElement = 0;
                                    int holdEndElement = 0;
                                    while (neItr.hasNext()) {
                                        DosagesAnnotation nea = (DosagesAnnotation)((Object)neItr.next());
                                        lastLocation[0] = nea.getBegin();
                                        lastLocation[1] = nea.getEnd();
                                        if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                        int n = lastLocation[0];
                                        location[counter][0] = n;
                                        holdBeginElement = n;
                                        int n5 = lastLocation[1];
                                        location[counter][1] = n5;
                                        holdEndElement = n5;
                                        ++counter;
                                    }
                                    break block15;
                                }
                                if (elementType != RouteAnnotation.type) break block19;
                                int holdBeginElement = 0;
                                int holdEndElement = 0;
                                while (neItr.hasNext()) {
                                    RouteAnnotation nea = (RouteAnnotation)((Object)neItr.next());
                                    lastLocation[0] = nea.getBegin();
                                    lastLocation[1] = nea.getEnd();
                                    if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                    int n = lastLocation[0];
                                    location[counter][0] = n;
                                    holdBeginElement = n;
                                    int n6 = lastLocation[1];
                                    location[counter][1] = n6;
                                    holdEndElement = n6;
                                    ++counter;
                                }
                                break block15;
                            }
                            if (elementType != FormAnnotation.type) break block20;
                            int holdBeginElement = 0;
                            int holdEndElement = 0;
                            while (neItr.hasNext()) {
                                FormAnnotation nea = (FormAnnotation)((Object)neItr.next());
                                lastLocation[0] = nea.getBegin();
                                lastLocation[1] = nea.getEnd();
                                if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                                int n = lastLocation[0];
                                location[counter][0] = n;
                                holdBeginElement = n;
                                int n7 = lastLocation[1];
                                location[counter][1] = n7;
                                holdEndElement = n7;
                                ++counter;
                            }
                            break block15;
                        }
                        if (elementType != DurationAnnotation.type) break block21;
                        int holdBeginElement = 0;
                        int holdEndElement = 0;
                        while (neItr.hasNext()) {
                            DurationAnnotation nea = (DurationAnnotation)((Object)neItr.next());
                            lastLocation[0] = nea.getBegin();
                            lastLocation[1] = nea.getEnd();
                            if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || nea.getEnd() <= holdEndElement) continue;
                            int n = lastLocation[0];
                            location[counter][0] = n;
                            holdBeginElement = n;
                            int n8 = lastLocation[1];
                            location[counter][1] = n8;
                            holdEndElement = n8;
                            ++counter;
                        }
                        break block15;
                    }
                    if (elementType != NewlineToken.type) break block22;
                    int holdBeginElement = 0;
                    while (neItr.hasNext()) {
                        NewlineToken nea = (NewlineToken)neItr.next();
                        lastLocation[0] = nea.getBegin();
                        lastLocation[1] = nea.getEnd();
                        if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end) continue;
                        int n = lastLocation[0];
                        location[counter][0] = n;
                        holdBeginElement = n;
                        location[counter][1] = lastLocation[1];
                        ++counter;
                    }
                    break block15;
                }
                if (elementType != MedicationMention.type) break block23;
                int holdEndElement = 0;
                while (neItr.hasNext()) {
                    MedicationMention nea = (MedicationMention)neItr.next();
                    if (nea.getTypeID() != 1 && nea.getTypeID() != 0) continue;
                    lastLocation[0] = nea.getBegin();
                    lastLocation[1] = nea.getEnd();
                    if ((counter == 0 || lastLocation[0] != location[counter - 1][0]) && nea.getBegin() >= begin && nea.getEnd() <= end) {
                        location[counter][0] = lastLocation[0];
                        int n = lastLocation[1];
                        location[counter][1] = n;
                        holdEndElement = n;
                        ++counter;
                        continue;
                    }
                    if (counter <= 0 || holdEndElement <= lastLocation[1]) continue;
                    int n = lastLocation[1];
                    location[counter - 1][1] = n;
                    holdEndElement = n;
                }
                break block15;
            }
            if (elementType != PunctuationToken.type) break block15;
            while (neItr.hasNext()) {
                int holdBeginElement = 0;
                boolean foundPair = false;
                PunctuationToken nea = (PunctuationToken)neItr.next();
                if (nea.getCoveredText().compareTo("(") == 0 || nea.getCoveredText().compareTo("[") == 0) {
                    lastLocation[0] = nea.getBegin();
                } else if (nea.getCoveredText().compareTo(")") == 0 || nea.getCoveredText().compareTo("]") == 0) {
                    lastLocation[1] = nea.getEnd();
                    foundPair = true;
                }
                if (holdBeginElement >= nea.getBegin() || nea.getBegin() < begin || nea.getEnd() > end || !foundPair) continue;
                location[counter][0] = lastLocation[0];
                location[counter][1] = lastLocation[1];
                ++counter;
            }
        }
        return counter;
    }

    private int[] findElementRelativeToNE(int[][] elementSpan, int[][] parenthesisSpan, int elementSpanLength, int parenthesisSpanLength, int priorDrugEnd, int startWithParenNum, int endPhrase, MedicationMention nea) {
        int[] caseType = new int[]{0, 0};
        int[] endLocationPreSpan = this.findNextDrugEntityPre(elementSpanLength, elementSpan, nea, priorDrugEnd);
        int[] endLocationPostSpan = new int[]{0, 0};
        int[] emptyState = new int[]{-1, -1};
        boolean patternFoundPost = false;
        endLocationPostSpan[1] = this.findNextDrugEntityPost(elementSpanLength, elementSpan, nea, endPhrase)[1];
        if (-1 != endLocationPostSpan[1]) {
            patternFoundPost = true;
            caseType[1] = endLocationPostSpan[1] - nea.getBegin();
        } else if (emptyState[1] != endLocationPreSpan[1]) {
            caseType[1] = endLocationPreSpan[1] - nea.getBegin();
        }
        if (patternFoundPost && this.findNextClosestRightParenRelativeToElement(parenthesisSpanLength, parenthesisSpan, (Annotation)nea, endLocationPostSpan[1], startWithParenNum)) {
            caseType[1] = 1;
        }
        caseType[0] = endLocationPreSpan[0];
        return caseType;
    }

    private int anchorEndofline(int[][] elementSpan, int elementSpanLength, int endPhrase, MedicationMention nea) {
        return this.findNextDrugEntityPost(elementSpanLength, elementSpan, nea, endPhrase)[1] - nea.getBegin();
    }

    private boolean findNextClosestRightParenRelativeToElement(int spanLength, int[][] elementSpan, Annotation nea, int beginSpan, int startOffset) {
        boolean elementClosest = false;
        for (int l = startOffset; l < spanLength && !elementClosest; ++l) {
            if (elementSpan[l][0] == -1 || elementSpan[l][0] >= nea.getBegin() || nea.getEnd() >= elementSpan[l][1] || elementSpan[l][1] <= beginSpan) continue;
            elementClosest = true;
        }
        return elementClosest;
    }
}

