/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet.grmm;

import cc.mallet.grmm.learning.ACRF;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Labels;
import cc.mallet.types.LabelsSequence;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.SequenceClassifier_ImplBase;
import org.cleartk.ml.mallet.grmm.GrmmDataWriter;

public class GrmmClassifier
extends SequenceClassifier_ImplBase<List<NameNumber>, String[], String[]> {
    protected ACRF acrf;
    protected String outcomeExample;

    public GrmmClassifier(FeaturesEncoder<List<NameNumber>> featuresEncoder, OutcomeEncoder<String[], String[]> outcomeEncoder, ACRF acrf, String outcomeExample) {
        super(featuresEncoder, outcomeEncoder);
        this.acrf = acrf;
        this.outcomeExample = outcomeExample;
    }

    public List<String[]> classify(List<List<Feature>> features) throws CleartkProcessingException {
        String data = "";
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        for (List<Feature> f : features) {
            List nameNumbers = (List)this.featuresEncoder.encodeAll(f);
            GrmmDataWriter.writeEncoded(nameNumbers, this.outcomeExample.split(" "), printWriter);
        }
        data = out.toString();
        Pipe pipe = this.acrf.getInputPipe();
        Instance unprocessedInstance = new Instance((Object)data, null, (Object)"", null);
        Instance instance = (Instance)pipe.newIteratorFrom(Arrays.asList(unprocessedInstance).iterator()).next();
        LabelsSequence bestLabels = this.acrf.getBestLabels(instance);
        ArrayList<String[]> returnValues = new ArrayList<String[]>(features.size());
        for (int i = 0; i < bestLabels.size(); ++i) {
            Labels labels = bestLabels.getLabels(i);
            String[] outcomes = new String[labels.size()];
            for (int j = 0; j < labels.size(); ++j) {
                outcomes[j] = labels.get(j).getBestLabel().toString();
            }
            returnValues.add(outcomes);
        }
        return returnValues;
    }
}

