/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;

public enum JdbcConnectionFactory {
    INSTANCE;

    public static final String JDBC_DRIVER = "jdbcDriver";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String JDBC_USER = "jdbcUser";
    public static final String JDBC_PASS = "jdbcPass";
    private static final Logger LOGGER;
    private static final Logger DOT_LOGGER;
    private static final Logger EOL_LOGGER;
    private static final String HSQL_FILE_PREFIX = "jdbc:hsqldb:file:";
    private static final String HSQL_DB_EXT = ".script";
    private final Map<String, Connection> CONNECTIONS = Collections.synchronizedMap(new HashMap());

    public static JdbcConnectionFactory getInstance() {
        return INSTANCE;
    }

    public Connection getConnection(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPass) throws SQLException {
        Connection connection = this.CONNECTIONS.get(jdbcUrl);
        if (connection != null) {
            return connection;
        }
        String trueJdbcUrl = jdbcUrl;
        if (jdbcUrl.startsWith(HSQL_FILE_PREFIX)) {
            trueJdbcUrl = HSQL_FILE_PREFIX + JdbcConnectionFactory.getConnectionUrl(jdbcUrl);
        }
        try {
            Driver driver = (Driver)Class.forName(jdbcDriver).newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)("Could not register Driver " + jdbcDriver), (Throwable)sqlE);
            throw sqlE;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException multE) {
            LOGGER.error((Object)("Could not create Driver " + jdbcDriver), (Throwable)multE);
            throw new SQLException(multE);
        }
        LOGGER.info((Object)("Connecting to " + jdbcUrl + ":"));
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new DotPlotter(), 333L, 333L);
        try {
            connection = DriverManager.getConnection(trueJdbcUrl, jdbcUser, jdbcPass);
        }
        catch (SQLException sqlE) {
            timer.cancel();
            EOL_LOGGER.error((Object)"");
            LOGGER.error((Object)("  Could not create Connection with " + trueJdbcUrl + " as " + jdbcUser), (Throwable)sqlE);
            throw sqlE;
        }
        timer.cancel();
        EOL_LOGGER.info((Object)"");
        LOGGER.info((Object)" Database connected");
        this.CONNECTIONS.put(jdbcUrl, connection);
        return connection;
    }

    private static String getConnectionUrl(String jdbcUrl) throws SQLException {
        String urlDbPath = jdbcUrl.substring(HSQL_FILE_PREFIX.length());
        String urlFilePath = urlDbPath + HSQL_DB_EXT;
        try {
            String fullPath = FileLocator.getFullPath((String)urlFilePath);
            return fullPath.substring(0, fullPath.length() - HSQL_DB_EXT.length());
        }
        catch (FileNotFoundException fnfE) {
            throw new SQLException("No Hsql DB exists at Url", fnfE);
        }
    }

    static {
        LOGGER = Logger.getLogger((String)"JdbcConnectionFactory");
        DOT_LOGGER = Logger.getLogger((String)"ProgressAppender");
        EOL_LOGGER = Logger.getLogger((String)"ProgressDone");
    }

    private static class DotPlotter
    extends TimerTask {
        private int _count = 0;

        private DotPlotter() {
        }

        @Override
        public void run() {
            DOT_LOGGER.info((Object)".");
            ++this._count;
            if (this._count % 50 == 0) {
                EOL_LOGGER.info((Object)(" " + this._count));
            }
        }
    }
}

