/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.consumer.AbstractTermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.PrecisionTermConsumer;
import org.apache.ctakes.dictionary.lookup2.consumer.TermConsumer;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public class SemanticCleanupTermConsumer
extends AbstractTermConsumer {
    private static final Logger LOGGER = Logger.getLogger((String)"SemanticCleanupTermConsumer");
    private final TermConsumer _idHitConsumer;

    public SemanticCleanupTermConsumer(UimaContext uimaContext, Properties properties) {
        super(uimaContext, properties);
        this._idHitConsumer = new PrecisionTermConsumer(uimaContext, properties);
    }

    @Override
    public void consumeHits(JCas jcas, RareWordDictionary dictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>> textSpanCuis, CollectionMap<Long, Concept, ? extends Collection<Concept>> cuiConcepts) throws AnalysisEngineProcessException {
        String codingScheme = this.getCodingScheme();
        Collection<Integer> usedcTakesSemantics = SemanticCleanupTermConsumer.getUsedcTakesSemantics(cuiConcepts);
        HashMap<Integer, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> groupedSemanticCuis = new HashMap<Integer, CollectionMap<TextSpan, Long, ? extends Collection<Long>>>();
        for (Integer cTakesSemantic : usedcTakesSemantics) {
            HashSetMap semanticTerms = new HashSetMap();
            for (Map.Entry spanCuis : textSpanCuis) {
                for (Long cuiCode : (Collection)spanCuis.getValue()) {
                    Collection concepts = cuiConcepts.getCollection((Object)cuiCode);
                    if (!SemanticCleanupTermConsumer.hascTakesSemantic(cTakesSemantic, concepts)) continue;
                    semanticTerms.placeValue(spanCuis.getKey(), (Object)cuiCode);
                }
            }
            groupedSemanticCuis.put(cTakesSemantic, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)semanticTerms);
        }
        SemanticCleanupTermConsumer.removeUnwantedSpans(6, 3, groupedSemanticCuis);
        SemanticCleanupTermConsumer.removeUnwantedSpans(6, 2, groupedSemanticCuis);
        if (groupedSemanticCuis.containsKey(3) && groupedSemanticCuis.containsKey(2)) {
            SemanticCleanupTermConsumer.removeUnwantedSpans(2, 3, groupedSemanticCuis);
            HashSetMap copiedTerms = new HashSetMap();
            SemanticCleanupTermConsumer.copyTerms(2, groupedSemanticCuis, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)copiedTerms);
            SemanticCleanupTermConsumer.copyTerms(3, groupedSemanticCuis, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)copiedTerms);
            CollectionMap<TextSpan, Long, ? extends Collection<Long>> preciseTerms = PrecisionTermConsumer.createPreciseTerms((CollectionMap<TextSpan, Long, ? extends Collection<Long>>)copiedTerms);
            CollectionMap findingSpanCuis = (CollectionMap)groupedSemanticCuis.get(3);
            ArrayList findingSpans = new ArrayList(findingSpanCuis.keySet());
            findingSpans.stream().filter(fs -> !preciseTerms.containsKey(fs)).forEach(arg_0 -> findingSpanCuis.remove(arg_0));
        }
        for (Map.Entry group : groupedSemanticCuis.entrySet()) {
            this.consumeTypeIdHits(jcas, codingScheme, (Integer)group.getKey(), PrecisionTermConsumer.createPreciseTerms((CollectionMap<TextSpan, Long, ? extends Collection<Long>>)((CollectionMap)group.getValue())), cuiConcepts);
        }
    }

    private static void removeUnwantedSpans(int wantedTypeId, int unwantedTypeId, Map<Integer, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> groupedSemanticCuis) {
        if (!groupedSemanticCuis.containsKey(wantedTypeId) || !groupedSemanticCuis.containsKey(unwantedTypeId)) {
            return;
        }
        Set wantedSpans = groupedSemanticCuis.get(wantedTypeId).keySet();
        CollectionMap<TextSpan, Long, ? extends Collection<Long>> typeTextSpanCuis = groupedSemanticCuis.get(unwantedTypeId);
        for (TextSpan wantedSpan : wantedSpans) {
            typeTextSpanCuis.remove((Object)wantedSpan);
        }
    }

    private static void copyTerms(int typeId, Map<Integer, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> groupedSemanticCuis, CollectionMap<TextSpan, Long, ? extends Collection<Long>> copyTermsMap) {
        CollectionMap<TextSpan, Long, ? extends Collection<Long>> spanCuis = groupedSemanticCuis.get(typeId);
        for (Map.Entry spanCui : spanCuis) {
            copyTermsMap.addAllValues(spanCui.getKey(), (Collection)spanCui.getValue());
        }
    }

    @Override
    public void consumeTypeIdHits(JCas jcas, String defaultScheme, int cTakesSemantic, CollectionMap<TextSpan, Long, ? extends Collection<Long>> semanticTerms, CollectionMap<Long, Concept, ? extends Collection<Concept>> conceptMap) throws AnalysisEngineProcessException {
        this._idHitConsumer.consumeTypeIdHits(jcas, defaultScheme, cTakesSemantic, semanticTerms, conceptMap);
    }
}

