/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.ae;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.fsm.token.NumberToken;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.ae.JCasTermAnnotator;
import org.apache.ctakes.dictionary.lookup2.ae.WindowProcessor;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.concept.ConceptFactory;
import org.apache.ctakes.dictionary.lookup2.dictionary.DictionaryDescriptorParser;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.ctakes.dictionary.lookup2.util.DictionarySpec;
import org.apache.ctakes.dictionary.lookup2.util.FastLookupToken;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class AbstractJCasTermAnnotator
extends JCasAnnotator_ImplBase
implements JCasTermAnnotator,
WindowProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractJCasTermAnnotator");
    private int _lookupWindowType;
    private DictionarySpec _dictionarySpec;
    private final Set<String> _exclusionPartsOfSpeech = new HashSet<String>();
    @ConfigurationParameter(name="LookupXml", mandatory=false, description="Path to the xml file containing information for dictionary lookup configuration.", defaultValue={""})
    private String _lookupXml;
    @Deprecated
    @ConfigurationParameter(name="DictionaryDescriptor", mandatory=false, description="Path to Dictionary spec xml", defaultValue={"org/apache/ctakes/dictionary/lookup/fast/sno_rx_16ab.xml"})
    private String _descriptorFilePath;
    @ConfigurationParameter(name="windowAnnotations", mandatory=false, description="Type of Lookup window to use", defaultValue={"org.apache.ctakes.typesystem.type.textspan.Sentence"})
    private String _windowClassName;
    @ConfigurationParameter(name="exclusionTags", mandatory=false, description="Set of exclusion POS tags", defaultValue={"VB,VBD,VBG,VBN,VBP,VBZ,CC,CD,DT,EX,IN,LS,MD,PDT,POS,PP,PP$,PRP,PRP$,RP,TO,WDT,WP,WPS,WRB"})
    private String _exclusionPosTags;
    @ConfigurationParameter(name="minimumSpan", mandatory=false, description="Minimum number of characters for a term")
    protected int _minimumLookupSpan = 3;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        String[] tagArr;
        super.initialize(uimaContext);
        LOGGER.info((Object)("Using dictionary lookup window type: " + this._windowClassName));
        this._lookupWindowType = JCasUtil.getType((String)this._windowClassName);
        for (String tag : tagArr = this._exclusionPosTags.split(",")) {
            this._exclusionPartsOfSpeech.add(tag.toUpperCase());
        }
        ArrayList<String> posList = new ArrayList<String>(this._exclusionPartsOfSpeech);
        Collections.sort(posList);
        StringBuilder sb = new StringBuilder();
        for (String pos : posList) {
            sb.append(pos).append(" ");
        }
        LOGGER.info((Object)("Exclusion tagset loaded: " + sb.toString()));
        Object minimumSpan = uimaContext.getConfigParameterValue("minimumSpan");
        if (minimumSpan != null) {
            this._minimumLookupSpan = AbstractJCasTermAnnotator.parseInt(minimumSpan, "minimumSpan", this._minimumLookupSpan);
        }
        LOGGER.info((Object)("Using minimum term text span: " + this._minimumLookupSpan));
        String descriptorFilePath = this._descriptorFilePath;
        if (this._lookupXml != null && !this._lookupXml.isEmpty()) {
            descriptorFilePath = this._lookupXml;
        }
        LOGGER.info((Object)("Using Dictionary Descriptor: " + descriptorFilePath));
        try (InputStream descriptorStream = FileLocator.getAsStream((String)descriptorFilePath);){
            this._dictionarySpec = DictionaryDescriptorParser.parseDescriptor(descriptorStream, uimaContext);
        }
        catch (IOException | AnnotatorContextException multE) {
            throw new ResourceInitializationException(multE);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Starting processing");
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        AnnotationIndex lookupWindows = indexes.getAnnotationIndex(this._lookupWindowType);
        if (lookupWindows == null) {
            return;
        }
        HashMap<RareWordDictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> dictionaryTermsMap = new HashMap<RareWordDictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>>>(this.getDictionaries().size());
        for (RareWordDictionary dictionary : this.getDictionaries()) {
            HashSetMap textSpanCuis = new HashSetMap();
            dictionaryTermsMap.put(dictionary, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)textSpanCuis);
        }
        try {
            for (Object window : lookupWindows) {
                if (!this.isWindowOk((Annotation)window)) continue;
                this.processWindow(jcas, (Annotation)window, dictionaryTermsMap);
            }
        }
        catch (ArrayIndexOutOfBoundsException iobE) {
            LOGGER.warn((Object)iobE.getMessage());
        }
        HashSet<Long> allDictionaryCuis = new HashSet<Long>();
        HashSetMap allConceptsMap = new HashSetMap();
        for (Map.Entry dictionaryCuis : dictionaryTermsMap.entrySet()) {
            allDictionaryCuis.clear();
            RareWordDictionary dictionary = (RareWordDictionary)dictionaryCuis.getKey();
            CollectionMap textSpanCuis = (CollectionMap)dictionaryCuis.getValue();
            for (Collection cuiCodes : textSpanCuis.getAllCollections()) {
                allDictionaryCuis.addAll(cuiCodes);
            }
            Collection<ConceptFactory> conceptFactories = this._dictionarySpec.getPairedConceptFactories(dictionary.getName());
            allConceptsMap.clear();
            for (ConceptFactory conceptFactory : conceptFactories) {
                Map<Long, Concept> conceptMap = conceptFactory.createConcepts(allDictionaryCuis);
                allConceptsMap.placeMap(conceptMap);
            }
            this._dictionarySpec.getConsumer().consumeHits(jcas, dictionary, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)textSpanCuis, (CollectionMap<Long, Concept, ? extends Collection<Concept>>)allConceptsMap);
        }
        LOGGER.info((Object)"Finished processing");
    }

    @Override
    public Collection<RareWordDictionary> getDictionaries() {
        return this._dictionarySpec.getDictionaries();
    }

    @Override
    public boolean isWindowOk(Annotation window) {
        String coveredText = window.getCoveredText();
        return !coveredText.equals("section id") && !coveredText.startsWith("[start section id") && !coveredText.startsWith("[end section id") && !coveredText.startsWith("[meta rev_");
    }

    @Override
    public void processWindow(JCas jcas, Annotation window, Map<RareWordDictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> dictionaryTerms) {
        ArrayList<FastLookupToken> allTokens = new ArrayList<FastLookupToken>();
        ArrayList<Integer> lookupTokenIndices = new ArrayList<Integer>();
        this.getAnnotationsInWindow(jcas, (AnnotationFS)window, allTokens, lookupTokenIndices);
        this.findTerms(this.getDictionaries(), allTokens, lookupTokenIndices, dictionaryTerms);
    }

    private void findTerms(Iterable<RareWordDictionary> dictionaries, List<FastLookupToken> allTokens, List<Integer> lookupTokenIndices, Map<RareWordDictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>>> dictionaryTermsMap) {
        for (RareWordDictionary dictionary : dictionaries) {
            CollectionMap<TextSpan, Long, ? extends Collection<Long>> termsFromDictionary = dictionaryTermsMap.get(dictionary);
            this.findTerms(dictionary, allTokens, lookupTokenIndices, termsFromDictionary);
        }
    }

    protected void getAnnotationsInWindow(JCas jcas, AnnotationFS window, List<FastLookupToken> allTokens, Collection<Integer> lookupTokenIndices) {
        List allBaseTokens = org.apache.uima.fit.util.JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)window);
        for (BaseToken baseToken : allBaseTokens) {
            String partOfSpeech;
            boolean isNonLookup;
            if (baseToken instanceof NewlineToken) continue;
            boolean bl = isNonLookup = baseToken instanceof PunctuationToken || baseToken instanceof NumberToken || baseToken instanceof ContractionToken || baseToken instanceof SymbolToken;
            if (!(isNonLookup || (partOfSpeech = baseToken.getPartOfSpeech()) != null && this._exclusionPartsOfSpeech.contains(partOfSpeech))) {
                lookupTokenIndices.add(allTokens.size());
            }
            FastLookupToken lookupToken = new FastLookupToken((Annotation)baseToken);
            allTokens.add(lookupToken);
        }
    }

    protected static int parseInt(Object value, String name, int defaultValue) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfE) {
                LOGGER.warn((Object)("Could not parse " + name + " " + value + " as an integer"));
            }
        } else {
            LOGGER.warn((Object)("Could not parse " + name + " " + value + " as an integer"));
        }
        return defaultValue;
    }
}

