/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class EventTimeDurationStatistics {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        CollectionReader collectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(AnalyseRelationArgumentDuration.class, (Object[])new Object[]{"OutputFile", options.getOutputFile()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    @PipeBitInfo(name="E-T Duration Computer", description="Writes a file with durations of Contains Event-Timex temporal relations.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AnalyseRelationArgumentDuration
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the file that stores relation data")
        private String outputFile;
        public static final String GOLD_VIEW_NAME = "GoldView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            File durationLookup = new File("/Users/dima/Boston/Thyme/Duration/Data/Combined/Distribution/all.txt");
            Map textToDistribution = null;
            try {
                textToDistribution = (Map)Files.readLines((File)durationLookup, (Charset)Charsets.UTF_8, (LineProcessor)new Utils.Callback());
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            try {
                goldView = jCas.getView(GOLD_VIEW_NAME);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
                String eventText;
                String timeText;
                if (!relation.getCategory().equals("CONTAINS")) continue;
                RelationArgument arg1 = relation.getArg1();
                RelationArgument arg2 = relation.getArg2();
                if (arg1.getArgument() instanceof TimeMention && arg2.getArgument() instanceof EventMention) {
                    timeText = arg1.getArgument().getCoveredText().toLowerCase();
                    eventText = Utils.normalizeEventText(jCas, arg2.getArgument());
                } else {
                    if (!(arg1.getArgument() instanceof EventMention) || !(arg2.getArgument() instanceof TimeMention)) continue;
                    eventText = Utils.normalizeEventText(jCas, arg1.getArgument());
                    timeText = arg2.getArgument().getCoveredText().toLowerCase();
                }
                HashSet<String> timeUnits = Utils.getTimeUnits(timeText);
                if (!textToDistribution.containsKey(eventText) || timeUnits.size() <= 0) continue;
                Map eventDistribution = (Map)textToDistribution.get(eventText);
                Map<String, Float> timeDistribution = Utils.convertToDistribution(timeUnits.iterator().next());
                float eventExpectedDuration = Utils.expectedDuration(eventDistribution);
                float timeExpectedDuration = Utils.expectedDuration(timeDistribution);
                String context = Utils.getTextBetweenAnnotations(goldView, arg1.getArgument(), arg2.getArgument());
                String out = String.format("%s|%.5f|%s|%.5f|%s\n", timeUnits.iterator().next(), Float.valueOf(timeExpectedDuration * 3650.0f), eventText, Float.valueOf(eventExpectedDuration * 3650.0f), context.length() < 80 ? context : "...");
                try {
                    Files.append((CharSequence)out, (File)new File(this.outputFile), (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-file"})
        public File getOutputFile();
    }
}

