/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.TokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.DistanceExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;

public class UMLSBasedTokenFeaturesExtractor
extends TokenFeaturesExtractor {
    private FeatureExtractor1 coveredText = new CoveredTextExtractor();
    private FeatureExtractor1 tokenContext = new CleartkExtractor(BaseToken.class, this.coveredText, new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()}), new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)});
    private FeatureExtractor1 mention1CoveredFeaturesExtractor = new NamingExtractor1("mention1", this.coveredText);
    private FeatureExtractor1 mention1ContextFeaturesExtractor = new NamingExtractor1("mention1", this.tokenContext);
    private FeatureExtractor1 mention2CoveredFeaturesExtractor = new NamingExtractor1("mention2", this.coveredText);
    private FeatureExtractor1 mention2ContextFeaturesExtractor = new NamingExtractor1("mention2", this.tokenContext);
    private CleartkExtractor tokensBetween = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)new NamingExtractor1("BetweenMentions", this.coveredText), new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})});
    private DistanceExtractor nTokensBetween = new DistanceExtractor(null, BaseToken.class);

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation mention1, IdentifiedAnnotation mention2) throws AnalysisEngineProcessException {
        Collection eventList;
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
        ArrayList<Feature> features = new ArrayList<Feature>();
        IdentifiedAnnotation arg1 = mention1;
        IdentifiedAnnotation arg2 = mention2;
        if (mention1 instanceof EventMention) {
            eventList = (Collection)coveringMap.get(mention1);
            for (EventMention covEvent : eventList) {
                features.addAll(this.mention1CoveredFeaturesExtractor.extract(jCas, (Annotation)covEvent));
                features.addAll(this.tokensBetween.extractBetween(jCas, (Annotation)covEvent, (Annotation)arg2));
                features.addAll(this.nTokensBetween.extract(jCas, (Annotation)covEvent, (Annotation)arg2));
            }
        }
        if (mention2 instanceof EventMention) {
            eventList = (Collection)coveringMap.get(mention2);
            for (EventMention covEvent : eventList) {
                features.addAll(this.mention2CoveredFeaturesExtractor.extract(jCas, (Annotation)covEvent));
                features.addAll(this.tokensBetween.extractBetween(jCas, (Annotation)arg1, (Annotation)covEvent));
                features.addAll(this.nTokensBetween.extract(jCas, (Annotation)arg1, (Annotation)covEvent));
            }
        }
        features.addAll(this.mention1CoveredFeaturesExtractor.extract(jCas, (Annotation)arg1));
        features.addAll(this.mention2CoveredFeaturesExtractor.extract(jCas, (Annotation)arg2));
        features.addAll(this.tokensBetween.extractBetween(jCas, (Annotation)arg1, (Annotation)arg2));
        features.addAll(this.nTokensBetween.extract(jCas, (Annotation)arg1, (Annotation)arg2));
        return features;
    }
}

