/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class NearestFlagFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats;
        block10: {
            Feature indicator;
            Map.Entry entry;
            Iterator<Object> iterator;
            feats = new ArrayList<Feature>();
            EventMention event = null;
            TimeMention time = null;
            if (arg2.getBegin() <= arg1.getBegin() && arg2.getEnd() <= arg1.getEnd()) {
                IdentifiedAnnotation temp = arg1;
                arg1 = arg2;
                arg2 = temp;
            }
            if (arg1 instanceof EventMention) {
                event = (EventMention)arg1;
                time = (TimeMention)arg2;
            } else {
                time = (TimeMention)arg1;
                event = (EventMention)arg2;
            }
            Map eventCoveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, Sentence.class);
            Collection eventSentList = (Collection)eventCoveringMap.get(event);
            Map timeCoveringMap = JCasUtil.indexCovering((JCas)jCas, TimeMention.class, Sentence.class);
            Collection timeSentList = (Collection)timeCoveringMap.get(time);
            TreeMap<Integer, TimeMention> timeDistMap = null;
            TreeMap<Integer, EventMention> eventDistMap = null;
            if (eventSentList != null && !eventSentList.isEmpty()) {
                timeDistMap = new TreeMap<Integer, TimeMention>();
                for (Sentence sent : eventSentList) {
                    for (TimeMention atime : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sent)) {
                        timeDistMap.put(Math.abs(atime.getBegin() - event.getBegin()), atime);
                    }
                }
                iterator = timeDistMap.entrySet().iterator();
                if (iterator.hasNext() && ((TimeMention)(entry = (Map.Entry)iterator.next()).getValue()).equals((Object)time)) {
                    indicator = new Feature("ClosestPair", (Object)"ClosestPair");
                    feats.add(indicator);
                    return feats;
                }
            }
            if (timeSentList == null || timeSentList.isEmpty()) break block10;
            eventDistMap = new TreeMap<Integer, EventMention>();
            for (Sentence sent : timeSentList) {
                for (EventMention aEvent : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sent)) {
                    eventDistMap.put(Math.abs(aEvent.getBegin() - time.getBegin()), aEvent);
                }
            }
            iterator = eventDistMap.entrySet().iterator();
            if (iterator.hasNext() && ((EventMention)(entry = (Map.Entry)iterator.next()).getValue()).equals((Object)event)) {
                indicator = new Feature("ClosestPair", (Object)"ClosestPair");
                feats.add(indicator);
            }
        }
        return feats;
    }
}

