/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.utils.distsem.WordEmbeddings;
import org.apache.ctakes.utils.distsem.WordVector;
import org.apache.ctakes.utils.distsem.WordVectorReader;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;

public class ContinuousTextExtractor
implements NamedFeatureExtractor1<BaseToken> {
    private int dims;
    private WordEmbeddings words = null;

    public ContinuousTextExtractor(String vecFile) throws CleartkExtractorException {
        try {
            this.words = WordVectorReader.getEmbeddings((InputStream)FileLocator.getAsStream((String)vecFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CleartkExtractorException((Throwable)e);
        }
    }

    public List<Feature> extract(JCas view, BaseToken token) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        String wordText = token.getCoveredText();
        WordVector vec = null;
        if (this.words.containsKey(wordText)) {
            vec = this.words.getVector(wordText);
        } else if (this.words.containsKey(wordText.toLowerCase())) {
            vec = this.words.getVector(wordText.toLowerCase());
        } else {
            return feats;
        }
        for (int i = 0; i < vec.size(); ++i) {
            feats.add(new Feature(this.getFeatureName() + "_" + i, (Object)vec.getValue(i)));
        }
        return feats;
    }

    public String getFeatureName() {
        return "ContinuousText";
    }
}

