/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.util;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class UTOutput {
    public static PrintStream createPrintBufferedFileStream(String filename) {
        PrintStream fout = null;
        try {
            fout = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename), 65536), false, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fout;
    }

    public static PrintStream createPrintBufferedStream(OutputStream stream) {
        PrintStream fout = null;
        try {
            fout = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fout;
    }

    public static PrintStream createPrintBufferedGZipFileStream(String filename) {
        PrintStream fout = null;
        try {
            fout = new PrintStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fout;
    }

    public static void printSet(PrintStream fout, Set<String> set) {
        fout.println(set.size());
        for (String key : set) {
            fout.println(key);
        }
    }

    public static void printMap(PrintStream fout, Map<String, String> map, String delim) {
        fout.println(map.size());
        for (String key : map.keySet()) {
            StringBuilder build = new StringBuilder();
            build.append(key);
            build.append(delim);
            build.append(map.get(key));
            fout.println(build.toString());
        }
    }

    public static void printMap(PrintStream fout, ObjectIntOpenHashMap<String> map, String delim) {
        fout.println(map.size());
        for (ObjectCursor cur : map.keys()) {
            StringBuilder build = new StringBuilder();
            build.append((String)cur.value);
            build.append(delim);
            build.append(map.get(cur.value));
            fout.println(build.toString());
        }
    }
}

