/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.constituent.CTLib;
import com.googlecode.clearnlp.constituent.CTLibEn;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.conversion.AbstractC2DConverter;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Option;

public class C2DConvert
extends AbstractRun {
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: dep)", required=false, metaVar="<string>")
    private String s_outputExt = "dep";
    @Option(name="-l", usage="language (default: en)", required=false, metaVar="<language>")
    private String s_language = "en";
    @Option(name="-h", usage="name of a headrule file (required)", required=true, metaVar="<filename>")
    private String s_headruleFile;
    @Option(name="-d", usage="name of a dictionary file (required)", required=true, metaVar="<filename>")
    private String s_dictFile;
    @Option(name="-m", usage="merge labels (default: null)", required=false, metaVar="<string>")
    private String s_mergeLabels = null;
    @Option(name="-n", usage="if set, normalize empty category indices", required=false, metaVar="<boolean>")
    private boolean b_normalize = false;

    public C2DConvert() {
    }

    public C2DConvert(String[] args) {
        this.initArgs(args);
        AbstractC2DConverter c2d = EngineGetter.getC2DConverter(this.s_language, this.s_headruleFile, this.s_mergeLabels);
        AbstractMPAnalyzer morph = EngineGetter.getMPAnalyzer(this.s_language, this.s_dictFile);
        List<String[]> filenames = this.getFilenames(this.s_inputPath, this.s_inputExt, this.s_outputExt);
        for (String[] io : filenames) {
            int n = this.convert(c2d, morph, this.s_language, io[0], io[1], this.b_normalize);
            System.out.printf("%s: %d trees\n", io[0], n);
        }
    }

    protected int convert(AbstractC2DConverter c2d, AbstractMPAnalyzer morph, String language, String inputFile, String outputFile, boolean normalize) {
        CTTree cTree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputFile));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        int n = 0;
        while ((cTree = reader.nextTree()) != null) {
            DEPTree dTree;
            if (normalize) {
                CTLib.normalizeIndices(cTree);
            }
            if (language.equals("en")) {
                CTLibEn.preprocessTree(cTree);
            }
            if ((dTree = c2d.toDEPTree(cTree)) == null) {
                fout.println(this.getNullTree() + "\n");
            } else {
                morph.lemmatize(dTree);
                fout.println(dTree.toStringDAG() + "\n");
            }
            ++n;
        }
        reader.close();
        fout.close();
        return n;
    }

    private DEPTree getNullTree() {
        DEPTree tree = new DEPTree();
        DEPNode dummy = new DEPNode(1, "NULL", "NULL", "NULL", new DEPFeat());
        dummy.setHead(tree.get(0), "NULL");
        tree.add(dummy);
        tree.initXHeads();
        tree.initSHeads();
        return tree;
    }

    public static void main(String[] args) {
        new C2DConvert(args);
    }
}

