/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.reader.AbstractReader;
import com.googlecode.clearnlp.reader.DAGReader;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.reader.LineReader;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.reader.RawReader;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.reader.TOKReader;
import com.googlecode.clearnlp.run.LiblinearTrain;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractRun {
    public final String TAG_READER = "reader";
    public final String TAG_READER_TYPE = "type";
    public final String TAG_READER_COLUMN = "column";
    public final String TAG_READER_COLUMN_INDEX = "index";
    public final String TAG_READER_COLUMN_FIELD = "field";
    public final String TAG_LEXICA = "lexica";
    public final String TAG_LEXICA_LEXICON = "lexicon";
    public final String TAG_LEXICA_LEXICON_TYPE = "type";
    public final String TAG_LEXICA_LEXICON_LABEL = "label";
    public final String TAG_LEXICA_LEXICON_CUTOFF = "cutoff";
    public final String TAG_TRAIN = "train";
    public final String TAG_TRAIN_ALGORITHM = "algorithm";
    public final String TAG_TRAIN_ALGORITHM_NAME = "name";
    public final String TAG_TRAIN_THREADS = "threads";
    public final String TAG_LANGUAGE = "language";
    public final String TAG_DICTIONARY = "dictionary";
    public final String TAG_POS_MODEL = "pos_model";
    public final String TAG_DEP_MODEL = "dep_model";
    public final String TAG_PRED_MODEL = "pred_model";
    public final String TAG_SRL_MODEL = "srl_model";

    protected void initArgs(String[] args) {
        CmdLineParser cmd = new CmdLineParser((Object)this);
        try {
            cmd.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            cmd.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getLanguage(Element eConfig) {
        Element eLanguage = UTXml.getFirstElementByTagName(eConfig, "language");
        return UTXml.getTrimmedTextContent(eLanguage);
    }

    protected AbstractSegmenter getSegmenter(Element eConfig) {
        String language = this.getLanguage(eConfig);
        String dictFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "dictionary"));
        return EngineGetter.getSegmenter(language, EngineGetter.getTokenizer(language, dictFile));
    }

    protected AbstractTokenizer getTokenizer(Element eConfig) {
        String language = this.getLanguage(eConfig);
        String dictFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "dictionary"));
        return EngineGetter.getTokenizer(language, dictFile);
    }

    protected AbstractMPAnalyzer getMPAnalyzer(Element eConfig) {
        String language = this.getLanguage(eConfig);
        String dictFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "dictionary"));
        return EngineGetter.getMPAnalyzer(language, dictFile);
    }

    protected Pair<POSTagger[], Double> getPOSTaggers(Element eConfig) {
        try {
            String modelFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "pos_model"));
            return EngineGetter.getPOSTaggers(modelFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected AbstractDEPParser getDEPParser(Element eConfig) {
        String modelFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "dep_model"));
        AbstractDEPParser parser = null;
        try {
            parser = EngineGetter.getDEPParser(modelFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parser;
    }

    protected AbstractPredIdentifier getPredIdentifier(Element eConfig) {
        String modelFile = UTXml.getTrimmedTextContent(UTXml.getFirstElementByTagName(eConfig, "pred_model"));
        AbstractPredIdentifier identifier = null;
        try {
            identifier = EngineGetter.getPredIdentifier(modelFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return identifier;
    }

    protected Pair<AbstractReader<?>, String> getReader(Element element) {
        Element eReader = UTXml.getFirstElementByTagName(element, "reader");
        String type = UTXml.getTrimmedAttribute(eReader, "type");
        if (type.equals("raw")) {
            return new Pair(new RawReader(), type);
        }
        if (type.equals("line")) {
            return new Pair(new LineReader(), type);
        }
        if (type.equals("tok")) {
            return new Pair(this.getTOKReader(eReader), type);
        }
        if (type.equals("pos")) {
            return new Pair(this.getPOSReader(eReader), type);
        }
        if (type.equals("dep")) {
            return new Pair(this.getDEPReader(eReader), type);
        }
        if (type.equals("dag")) {
            return new Pair(this.getDAGReader(eReader), type);
        }
        if (type.equals("srl")) {
            return new Pair(this.getSRLReader(eReader), type);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private ObjectIntOpenHashMap<String> getFieldMap(Element eReader) {
        NodeList list = eReader.getElementsByTagName("column");
        int size = list.getLength();
        ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)list.item(i);
            String field = UTXml.getTrimmedAttribute(element, "field");
            int index = Integer.parseInt(element.getAttribute("index"));
            map.put((Object)field, index);
        }
        return map;
    }

    private TOKReader getTOKReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iForm = map.get((Object)"form") - 1;
        if (iForm < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "form");
            System.exit(1);
        }
        return new TOKReader(iForm);
    }

    private POSReader getPOSReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iForm = map.get((Object)"form") - 1;
        int iPos = map.get((Object)"pos") - 1;
        if (iForm < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "form");
            System.exit(1);
        }
        return new POSReader(iForm, iPos);
    }

    private DEPReader getDEPReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iId = map.get((Object)"id") - 1;
        int iForm = map.get((Object)"form") - 1;
        int iLemma = map.get((Object)"lemma") - 1;
        int iPos = map.get((Object)"pos") - 1;
        int iFeats = map.get((Object)"feats") - 1;
        int iHeadId = map.get((Object)"headId") - 1;
        int iDeprel = map.get((Object)"deprel") - 1;
        if (iId < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "id");
            System.exit(1);
        } else if (iForm < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "form");
            System.exit(1);
        } else if (iLemma < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "lemma");
            System.exit(1);
        } else if (iPos < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "pos");
            System.exit(1);
        } else if (iFeats < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "feats");
            System.exit(1);
        }
        return new DEPReader(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel);
    }

    private SRLReader getSRLReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iId = map.get((Object)"id") - 1;
        int iForm = map.get((Object)"form") - 1;
        int iLemma = map.get((Object)"lemma") - 1;
        int iPos = map.get((Object)"pos") - 1;
        int iFeats = map.get((Object)"feats") - 1;
        int iHeadId = map.get((Object)"headId") - 1;
        int iDeprel = map.get((Object)"deprel") - 1;
        int iSheads = map.get((Object)"sheads") - 1;
        if (iId < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "id");
            System.exit(1);
        } else if (iForm < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "form");
            System.exit(1);
        } else if (iLemma < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "lemma");
            System.exit(1);
        } else if (iPos < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "pos");
            System.exit(1);
        } else if (iFeats < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "feats");
            System.exit(1);
        } else if (iHeadId < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "headId");
            System.exit(1);
        } else if (iDeprel < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "deprel");
            System.exit(1);
        }
        return new SRLReader(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel, iSheads);
    }

    private DAGReader getDAGReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iId = map.get((Object)"id") - 1;
        int iForm = map.get((Object)"form") - 1;
        int iLemma = map.get((Object)"lemma") - 1;
        int iPos = map.get((Object)"pos") - 1;
        int iFeats = map.get((Object)"feats") - 1;
        int iXheads = map.get((Object)"xheads") - 1;
        if (iId < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "id");
            System.exit(1);
        } else if (iForm < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "form");
            System.exit(1);
        } else if (iLemma < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "lemma");
            System.exit(1);
        } else if (iPos < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "pos");
            System.exit(1);
        } else if (iFeats < 0) {
            System.err.printf("The '%s' field must be specified in the configuration file.\n", "feats");
            System.exit(1);
        }
        return new DAGReader(iId, iForm, iLemma, iPos, iFeats, iXheads);
    }

    protected StringTrainSpace mergeTrainSpaces(List<StringTrainSpace> spaces, int labelCutoff, int featureCutoff) {
        StringTrainSpace space;
        if (spaces.size() == 1) {
            space = spaces.get(0);
        } else {
            System.out.println("Merging training instances:");
            space = new StringTrainSpace(false, labelCutoff, featureCutoff);
            for (StringTrainSpace s : spaces) {
                space.appendSpace(s);
                System.out.print(".");
                s.clear();
            }
            System.out.println();
        }
        return space;
    }

    protected AbstractModel getModel(Element eTrain, AbstractTrainSpace space, int index) {
        NodeList list = eTrain.getElementsByTagName("algorithm");
        int numThreads = this.getNumOfThreads(eTrain);
        Element eAlgorithm = (Element)list.item(index);
        String name = UTXml.getTrimmedAttribute(eAlgorithm, "name");
        if (name.equals("liblinear")) {
            byte solver = Byte.parseByte(UTXml.getTrimmedAttribute(eAlgorithm, "solver"));
            double cost = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "cost"));
            double eps = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "eps"));
            double bias = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "bias"));
            return this.getLiblinearModel(space, numThreads, solver, cost, eps, bias);
        }
        return null;
    }

    protected AbstractModel getLiblinearModel(AbstractTrainSpace space, int numThreads, byte solver, double cost, double eps, double bias) {
        space.build();
        System.out.println("Liblinear:");
        System.out.printf("- solver=%d, cost=%f, eps=%f, bias=%f\n", solver, cost, eps, bias);
        return LiblinearTrain.getModel(space, numThreads, solver, cost, eps, bias);
    }

    protected int getNumOfThreads(Element eTrain) {
        Element eThreads = UTXml.getFirstElementByTagName(eTrain, "threads");
        return Integer.parseInt(UTXml.getTrimmedTextContent(eThreads));
    }

    protected void printTime(String message, long st, long et) {
        long millis = et - st;
        long mins = TimeUnit.MILLISECONDS.toMinutes(millis);
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(mins);
        System.out.println(message);
        System.out.println(String.format("- %d mins, %d secs", mins, secs));
    }

    protected List<String[]> getFilenames(String inputPath, String inputExt, String outputExt) {
        ArrayList<String[]> filenames = new ArrayList<String[]>();
        File f = new File(inputPath);
        if (f.isDirectory()) {
            for (String inputFile : f.list(new FileExtFilter(inputExt))) {
                inputFile = inputPath + File.separator + inputFile;
                String outputFile = inputFile + "." + outputExt;
                filenames.add(new String[]{inputFile, outputFile});
            }
        } else {
            filenames.add(new String[]{inputPath, inputPath + "." + outputExt});
        }
        return filenames;
    }
}

