/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.nlp;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.googlecode.clearnlp.classification.algorithm.AdaGrad;
import com.googlecode.clearnlp.classification.algorithm.AdaGradLR;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.reader.AbstractReader;
import com.googlecode.clearnlp.reader.JointReader;
import com.googlecode.clearnlp.reader.LineReader;
import com.googlecode.clearnlp.reader.RawReader;
import com.googlecode.clearnlp.run.LiblinearTrain;
import com.googlecode.clearnlp.util.UTXml;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractNLP {
    public final String TAG_READER = "reader";
    public final String TAG_TYPE = "type";
    public final String TAG_READER_COLUMN = "column";
    public final String TAG_READER_COLUMN_INDEX = "index";
    public final String TAG_READER_COLUMN_FIELD = "field";
    public final String TAG_TRAIN = "train";
    public final String TAG_TRAIN_ALGORITHM = "algorithm";
    public final String TAG_TRAIN_ALGORITHM_NAME = "name";
    public final String TAG_TRAIN_THREADS = "threads";
    public final String TAG_LANGUAGE = "language";
    public final String TAG_DICTIONARY = "dictionary";
    public final String TAG_MODELS = "models";
    public final String TAG_MODEL = "model";
    public final String TAG_MODE = "mode";
    public final String TAG_PATH = "path";

    protected void initArgs(String[] args) {
        CmdLineParser cmd = new CmdLineParser((Object)this);
        try {
            cmd.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            cmd.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String toString(DEPTree tree, String mode) {
        if (mode.startsWith("pos")) {
            return tree.toStringPOS();
        }
        if (mode.equals("morph")) {
            return tree.toStringMorph();
        }
        if (mode.startsWith("dep") || mode.equals("pred") || mode.equals("role") || mode.startsWith("sense")) {
            return tree.toStringDEP();
        }
        return tree.toStringSRL();
    }

    protected String getLanguage(Element element) {
        Element eLanguage = UTXml.getFirstElementByTagName(element, "language");
        return UTXml.getTrimmedTextContent(eLanguage);
    }

    protected String getDictionary(Element element) {
        Element eDictionary = UTXml.getFirstElementByTagName(element, "dictionary");
        return UTXml.getTrimmedTextContent(eDictionary);
    }

    protected List<String[]> getFilenames(String inputPath, String inputExt, String outputExt) {
        ArrayList<String[]> filenames = new ArrayList<String[]>();
        File f = new File(inputPath);
        if (f.isDirectory()) {
            Object[] inputFiles = f.list(new FileExtFilter(inputExt));
            Arrays.sort(inputFiles);
            for (Object inputFile : inputFiles) {
                inputFile = inputPath + File.separator + (String)inputFile;
                String outputFile = (String)inputFile + "." + outputExt;
                filenames.add(new String[]{inputFile, outputFile});
            }
        } else {
            filenames.add(new String[]{inputPath, inputPath + "." + outputExt});
        }
        return filenames;
    }

    protected AbstractReader<?> getReader(Element eReader) {
        String type = UTXml.getTrimmedAttribute(eReader, "type");
        if (type.equals("raw")) {
            return new RawReader();
        }
        if (type.equals("line")) {
            return new LineReader();
        }
        return this.getJointReader(eReader);
    }

    protected JointReader getJointReader(Element eReader) {
        ObjectIntOpenHashMap<String> map = this.getFieldMap(eReader);
        int iId = map.get((Object)"id") - 1;
        int iForm = map.get((Object)"form") - 1;
        int iLemma = map.get((Object)"lemma") - 1;
        int iPos = map.get((Object)"pos") - 1;
        int iFeats = map.get((Object)"feats") - 1;
        int iHeadId = map.get((Object)"headId") - 1;
        int iDeprel = map.get((Object)"deprel") - 1;
        int iXHeads = map.get((Object)"xheads") - 1;
        int iSHeads = map.get((Object)"sheads") - 1;
        int iNament = map.get((Object)"nament") - 1;
        int iCoref = map.get((Object)"coref") - 1;
        return new JointReader(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel, iXHeads, iSHeads, iNament, iCoref);
    }

    private ObjectIntOpenHashMap<String> getFieldMap(Element eReader) {
        NodeList list = eReader.getElementsByTagName("column");
        int size = list.getLength();
        ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)list.item(i);
            String field = UTXml.getTrimmedAttribute(element, "field");
            int index = Integer.parseInt(element.getAttribute("index"));
            map.put((Object)field, index);
        }
        return map;
    }

    protected AbstractModel getModel(Element eTrain, AbstractTrainSpace space, int index, int boot) {
        NodeList list = eTrain.getElementsByTagName("algorithm");
        int numThreads = this.getNumOfThreads(eTrain);
        Element eAlgorithm = (Element)list.item(index);
        String name = UTXml.getTrimmedAttribute(eAlgorithm, "name");
        if (name.equals("liblinear")) {
            byte solver = Byte.parseByte(UTXml.getTrimmedAttribute(eAlgorithm, "solver"));
            double cost = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "cost"));
            double eps = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "eps"));
            double bias = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "bias"));
            return this.getLiblinearModel(space, numThreads, solver, cost, eps, bias);
        }
        if (name.equals("adagrad")) {
            String[] tmp = UTXml.getTrimmedAttribute(eAlgorithm, "iter").split(",");
            int iter = Integer.parseInt(tmp[boot]);
            int rand = Integer.parseInt(UTXml.getTrimmedAttribute(eAlgorithm, "rand"));
            double alpha = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "alpha"));
            double rho = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "rho"));
            return this.getAdaGradModel(space, numThreads, iter, rand, alpha, rho);
        }
        if (name.equals("adagrad-lr")) {
            String[] tmp = UTXml.getTrimmedAttribute(eAlgorithm, "iter").split(",");
            int iter = Integer.parseInt(tmp[boot]);
            int rand = Integer.parseInt(UTXml.getTrimmedAttribute(eAlgorithm, "rand"));
            double alpha = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "alpha"));
            double rho = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "rho"));
            return this.getAdaGradLRModel(space, numThreads, iter, rand, alpha, rho);
        }
        return null;
    }

    protected AbstractModel getLiblinearModel(AbstractTrainSpace space, int numThreads, byte solver, double cost, double eps, double bias) {
        space.build();
        System.out.println("Liblinear:");
        System.out.printf("- solver=%d, cost=%f, eps=%f, bias=%f\n", solver, cost, eps, bias);
        return LiblinearTrain.getModel(space, numThreads, solver, cost, eps, bias);
    }

    protected AbstractModel getAdaGradModel(AbstractTrainSpace space, int numThreads, int iter, int rand, double alpha, double rho) {
        space.build();
        System.out.println("AdaGrad:");
        System.out.printf("- iter=%d, rand=%d, alpha=%f, rho=%f\n", iter, rand, alpha, rho);
        System.out.println("Training:");
        AdaGrad ag = new AdaGrad(iter, alpha, rho, new Random(rand));
        AbstractModel model = space.getModel();
        model.setWeights(ag.getWeight(space, numThreads));
        return model;
    }

    protected AbstractModel getAdaGradLRModel(AbstractTrainSpace space, int numThreads, int iter, int rand, double alpha, double rho) {
        space.build();
        System.out.println("AdaGrad-LR:");
        System.out.printf("- iter=%d, rand=%d, alpha=%f, rho=%f\n", iter, rand, alpha, rho);
        System.out.println("Training:");
        AdaGradLR ag = new AdaGradLR(iter, alpha, rho, new Random(rand));
        AbstractModel model = space.getModel();
        model.setWeights(ag.getWeight(space, numThreads));
        return model;
    }

    protected void updateModel(Element eTrain, AbstractTrainSpace space, Random rand, int nUpdate, int index) {
        NodeList list = eTrain.getElementsByTagName("algorithm");
        int numThreads = this.getNumOfThreads(eTrain);
        Element eAlgorithm = (Element)list.item(index);
        String name = UTXml.getTrimmedAttribute(eAlgorithm, "name");
        if (name.equals("adagrad")) {
            int iter = Integer.parseInt(UTXml.getTrimmedAttribute(eAlgorithm, "iter"));
            double alpha = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "alpha"));
            double rho = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "rho"));
            this.updateAdaGradModel(space, rand, numThreads, nUpdate, iter, alpha, rho);
        } else if (name.equals("adagrad-lr")) {
            int iter = Integer.parseInt(UTXml.getTrimmedAttribute(eAlgorithm, "iter"));
            double alpha = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "alpha"));
            double rho = Double.parseDouble(UTXml.getTrimmedAttribute(eAlgorithm, "rho"));
            this.updateAdaGradLRModel(space, rand, numThreads, nUpdate, iter, alpha, rho);
        }
    }

    protected void updateAdaGradModel(AbstractTrainSpace space, Random rand, int numThreads, int nUpdate, int iter, double alpha, double rho) {
        AbstractModel model = space.getModel();
        if (model.getWeights() == null) {
            space.build();
            model.initWeightVector();
        }
        System.out.printf("%3d: AdaGrad, iter=%d, alpha=%f, rho=%f\n", nUpdate, iter, alpha, rho);
        AdaGrad ag = new AdaGrad(iter, alpha, rho, rand);
        ag.updateWeight(space);
    }

    protected void updateAdaGradLRModel(AbstractTrainSpace space, Random rand, int numThreads, int nUpdate, int iter, double alpha, double rho) {
        AbstractModel model = space.getModel();
        if (model.getWeights() == null) {
            space.build();
            model.initWeightVector();
        }
        System.out.printf("%3d: AdaGrad-LR, iter=%d, alpha=%f, rho=%f\n", nUpdate, iter, alpha, rho);
        AdaGradLR ag = new AdaGradLR(iter, alpha, rho, rand);
        ag.updateWeight(space);
    }

    protected int getNumOfThreads(Element eTrain) {
        Element eThreads = UTXml.getFirstElementByTagName(eTrain, "threads");
        return Integer.parseInt(UTXml.getTrimmedTextContent(eThreads));
    }

    protected void printTime(String message, long st, long et) {
        long millis = et - st;
        long mins = TimeUnit.MILLISECONDS.toMinutes(millis);
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(mins);
        System.out.println(message);
        System.out.println(String.format("- %d mins, %d secs", mins, secs));
    }
}

