/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.File;
import java.io.PrintStream;

public class GeneratePOS {
    public GeneratePOS(String inputDir, String inputExt, String outputDir) {
        File file = new File(inputDir);
        for (File section : file.listFiles()) {
            if (!section.isDirectory()) continue;
            String outputFile = outputDir + File.separator + section.getName() + ".pos";
            PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
            System.out.println(outputFile);
            for (String inputFile : UTFile.getSortedFileList(section.getAbsolutePath())) {
                this.printTree(fout, inputFile);
            }
            fout.close();
        }
    }

    private void printTree(PrintStream fout, String inputFile) {
        CTTree tree;
        CTReader reader = new CTReader();
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((tree = reader.nextTree()) != null) {
            StringBuilder build = new StringBuilder();
            for (CTNode node : tree.getTerminals()) {
                build.append(node.form);
                build.append("\t");
                build.append(node.pTag);
                build.append("\n");
            }
            fout.println(build.toString());
        }
        reader.close();
    }

    public static void main(String[] args) {
        new GeneratePOS(args[0], args[1], args[2]);
    }
}

