/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.util.UTInput;

public class DEPErrors {
    public DEPErrors(String mergeFile) {
        DEPTree gTree;
        DEPReader gReader = new DEPReader(0, 1, 2, 4, 6, 7, 9);
        DEPReader sReader = new DEPReader(0, 1, 3, 5, 6, 8, 10);
        gReader.open(UTInput.createBufferedFileReader(mergeFile));
        sReader.open(UTInput.createBufferedFileReader(mergeFile));
        String[] errors = new String[]{"sHead is a dependent       of gHead", "sHead is a grand-dependent of gHead", "gHead is a sibling         of sHead", "sHead is a descendent      of gHead", "gHead is a sibling         of cHead", "gHead is a dependent       of cNode", "gHead is a grand-dependent of sHead"};
        int[] counts = new int[errors.length + 1];
        while ((gTree = gReader.next()) != null) {
            DEPTree sTree = sReader.next();
            gTree.setDependents();
            sTree.setDependents();
            this.checkErrors(gTree, sTree, counts);
        }
        int size = counts.length;
        int total = counts[0];
        int sum = 0;
        for (int i = 1; i < size; ++i) {
            int count = counts[i];
            sum += count;
            System.out.printf("%40s: %5.2f (%5d/%d)\n", errors[i - 1], 100.0 * (double)count / (double)total, count, total);
        }
        System.out.printf("%40s: %5.2f (%d/%d)\n", "SUM", 100.0 * (double)sum / (double)total, sum, total);
    }

    public void checkErrors(DEPTree gTree, DEPTree sTree, int[] counts) {
        int size = gTree.size();
        block0: for (int i = 1; i < size; ++i) {
            DEPNode cNode = sTree.get(i);
            DEPNode gHead = sTree.get(gTree.get((int)i).getHead().id);
            DEPNode sHead = cNode.getHead();
            if (gHead.id == sHead.id) continue;
            counts[0] = counts[0] + 1;
            if (sHead.isDependentOf(gHead)) {
                counts[1] = counts[1] + 1;
                continue;
            }
            DEPNode tmp = sHead.getHead();
            if (tmp != null) {
                if (tmp.isDependentOf(gHead)) {
                    counts[2] = counts[2] + 1;
                    continue;
                }
                for (DEPArc arc : tmp.getDependents()) {
                    if (!arc.isNode(gHead)) continue;
                    counts[3] = counts[3] + 1;
                    continue block0;
                }
            }
            if (sHead.isDescendentOf(gHead)) {
                counts[4] = counts[4] + 1;
                continue;
            }
            for (DEPArc arc : sHead.getDependents()) {
                if (!arc.isNode(gHead)) continue;
                counts[5] = counts[5] + 1;
                continue block0;
            }
            if (gHead.isDependentOf(cNode)) {
                counts[6] = counts[6] + 1;
                continue;
            }
            for (DEPArc arc : sHead.getGrandDependents()) {
                if (!arc.isNode(gHead)) continue;
                counts[7] = counts[7] + 1;
                continue block0;
            }
        }
    }

    public static void main(String[] args) {
        new DEPErrors(args[0]);
    }
}

