/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.AbstractSRLabeler;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;

public class DemoSRLabeler {
    final String language = "en";

    public DemoSRLabeler(String dictionaryFile, String posModelFile, String depModelFile, String predModelFile, String srlModelFile, String inputFile, String outputFile) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", dictionaryFile);
        AbstractMPAnalyzer analyzer = EngineGetter.getMPAnalyzer("en", dictionaryFile);
        Pair<POSTagger[], Double> taggers = EngineGetter.getPOSTaggers(posModelFile);
        AbstractDEPParser parser = EngineGetter.getDEPParser(depModelFile);
        AbstractPredIdentifier identifier = EngineGetter.getPredIdentifier(predModelFile);
        AbstractSRLabeler labeler = EngineGetter.getSRLabeler(srlModelFile);
        String sentence = "I'd like to meet Mr. Choi.";
        this.label(tokenizer, analyzer, taggers, parser, identifier, labeler, sentence);
        this.label(tokenizer, analyzer, taggers, parser, identifier, labeler, UTInput.createBufferedFileReader(inputFile), UTOutput.createPrintBufferedFileStream(outputFile));
    }

    public void label(AbstractTokenizer tokenizer, AbstractMPAnalyzer analyzer, Pair<POSTagger[], Double> taggers, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, String sentence) {
        DEPTree tree = EngineProcess.getDEPTree(tokenizer, taggers, analyzer, parser, identifier, labeler, sentence);
        System.out.println(tree.toStringSRL() + "\n");
    }

    public void label(AbstractTokenizer tokenizer, AbstractMPAnalyzer analyzer, Pair<POSTagger[], Double> taggers, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, BufferedReader reader, PrintStream fout) {
        AbstractSegmenter segmenter = EngineGetter.getSegmenter("en", tokenizer);
        for (List<String> tokens : segmenter.getSentences(reader)) {
            DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, identifier, labeler, tokens);
            fout.println(tree.toStringSRL() + "\n");
        }
        fout.close();
    }

    public static void main(String[] args) {
        String dictionaryFile = args[0];
        String posModelFile = args[1];
        String depModelFile = args[2];
        String predModelFile = args[3];
        String srlModelFile = args[4];
        String inputFile = args[5];
        String outputFile = args[6];
        try {
            new DemoSRLabeler(dictionaryFile, posModelFile, depModelFile, predModelFile, srlModelFile, inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

