/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.conversion;

import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.dependency.DEPFeat;

public class C2DInfo {
    CTNode d_head;
    CTNode p_head;
    String s_label = null;
    DEPFeat d_feats;
    private boolean b_head = false;

    public C2DInfo(CTNode head) {
        if (head.c2d == null) {
            this.d_head = head;
            this.p_head = null;
            this.d_feats = new DEPFeat();
        } else {
            this.d_head = head.c2d.getDependencyHead();
            this.p_head = head;
        }
    }

    public void setHead(CTNode head, String label) {
        this.d_head.c2d.d_head = head.c2d.getDependencyHead();
        this.setLabel(label);
        this.b_head = true;
    }

    public void setHeadTerminal(CTNode head, String label) {
        this.d_head.c2d.d_head = head;
        this.setLabel(label);
        this.b_head = true;
    }

    public boolean hasHead() {
        return this.b_head;
    }

    public void setLabel(String label) {
        if (this.p_head == null) {
            this.s_label = label;
        } else {
            this.d_head.c2d.s_label = label;
        }
    }

    public String getLabel() {
        return this.s_label;
    }

    public String putFeat(String key, String value) {
        return this.d_head.c2d.d_feats.put(key, value);
    }

    public String getFeat(String key) {
        return (String)this.d_feats.get(key);
    }

    public CTNode getDependencyHead() {
        return this.d_head;
    }

    public CTNode getPhraseHead() {
        return this.p_head;
    }
}

