/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component.dep;

import com.googlecode.clearnlp.classification.model.ONStringModel;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.component.dep.CDEPPassParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ONDEPPassParser
extends CDEPPassParser {
    private ONStringModel o_model;

    public ONDEPPassParser(JointFtrXml[] xmls, Object[] lexica, double alpha, double rho) {
        this.f_xmls = xmls;
        this.s_models = new ONStringModel[]{new ONStringModel(alpha, rho)};
        this.initLexia(lexica);
        this.initOnline();
    }

    public ONDEPPassParser(ZipInputStream zin, double alpha, double rho) {
        this.loadModels(zin, alpha, rho);
        this.initOnline();
    }

    private void initOnline() {
        this.i_flag = (byte)2;
        this.o_model = (ONStringModel)this.s_models[0];
    }

    public void loadModels(ZipInputStream zin, double alpha, double rho) {
        int fLen = "dep_FEATURE".length();
        int mLen = "dep_MODEL".length();
        this.f_xmls = new JointFtrXml[1];
        this.s_models = null;
        try {
            ZipEntry zEntry;
            while ((zEntry = zin.getNextEntry()) != null) {
                String entry = zEntry.getName();
                if (entry.equals("dep_CONFIGURATION")) {
                    this.loadDefaultConfiguration(zin);
                    continue;
                }
                if (entry.startsWith("dep_FEATURE")) {
                    this.loadFeatureTemplates(zin, Integer.parseInt(entry.substring(fLen)));
                    continue;
                }
                if (entry.startsWith("dep_MODEL")) {
                    this.loadOnlineModels(zin, Integer.parseInt(entry.substring(mLen)), alpha, rho);
                    continue;
                }
                if (!entry.equals("dep_LEXICA")) continue;
                this.loadLexica(zin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initOnline(DEPTree tree) {
        this.i_lambda = 0;
        this.i_beta = 1;
        this.s_reduce.clear();
        for (int i = 0; i < this.t_size; ++i) {
            this.lm_deps[i] = null;
            this.rm_deps[i] = null;
            this.ln_sibs[i] = null;
            this.rn_sibs[i] = null;
            ((List)this.l_2nd.get(i)).clear();
        }
        tree.clearHeads();
    }

    public void trainHard(DEPTree tree, int maxIter) {
        int[] counts = new int[4];
        byte flag = this.i_flag;
        this.i_flag = (byte)3;
        this.init(tree);
        for (int i = 0; i < maxIter; ++i) {
            this.initOnline(tree);
            Arrays.fill(counts, 0);
            List<Pair<String, StringFeatureVector>> insts = this.parse();
            this.countAccuracy(counts);
            if (counts[0] == counts[1]) break;
            this.o_model.updateWeights(insts);
        }
        this.i_flag = flag;
    }

    public void train(List<DEPTree> trees) {
        ArrayList<Pair<String, StringFeatureVector>> insts = new ArrayList<Pair<String, StringFeatureVector>>();
        int[] counts = new int[4];
        byte flag = this.i_flag;
        this.i_flag = (byte)3;
        for (DEPTree tree : trees) {
            this.init(tree);
            Arrays.fill(counts, 0);
            List<Pair<String, StringFeatureVector>> tmp = this.parse();
            this.countAccuracy(counts);
            if (counts[0] == counts[1]) continue;
            insts.addAll(tmp);
        }
        this.o_model.updateWeights(insts);
        this.i_flag = flag;
    }

    public void develop(DEPTree tree) {
        byte flag = this.i_flag;
        this.i_flag = (byte)2;
        this.process(tree);
        this.i_flag = flag;
    }
}

