/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.algorithm;

import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import java.util.List;

public abstract class AbstractAlgorithm {
    public static final byte SOLVER_LIBLINEAR_LR2_L1_SV = 0;
    public static final byte SOLVER_LIBLINEAR_LR2_L2_SV = 1;
    public static final byte SOLVER_LIBLINEAR_LR2_LR = 2;
    public static final byte SOLVER_ADAGRAD = 3;

    public abstract double[] getWeight(AbstractTrainSpace var1, int var2);

    protected int GETI(byte[] y, int i) {
        return y[i] + 1;
    }

    protected int getWeightIndex(int L, int label, int index) {
        return index * L + label;
    }

    public static void normalize(double[] scores) {
        int i;
        int size = scores.length;
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double d;
            scores[i] = d = Math.exp(scores[i]);
            sum += d;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            scores[n] = scores[n] / sum;
        }
    }

    public static void normalize(List<StringPrediction> ps) {
        int i;
        int size = ps.size();
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double d;
            StringPrediction p = ps.get(i);
            p.score = d = Math.exp(p.score);
            sum += d;
        }
        for (i = 0; i < size; ++i) {
            ps.get((int)i).score /= sum;
        }
    }
}

