/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.data;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.ctakes.core.util.Mapper;
import org.apache.ctakes.relationextractor.data.Constants;
import org.apache.ctakes.relationextractor.knowtator.RelationInfo;
import org.apache.ctakes.relationextractor.knowtator.XMLReader;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Stats {
    public static final boolean readOnlySharpRelations = true;

    public static void getEntityStats(String inputDir) throws JDOMException, IOException {
        File dir = new File(inputDir);
        HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
        int totalEntityCount = 0;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File fileDir, String name) {
                return name.endsWith(".xml");
            }
        };
        for (String file : dir.list(filter)) {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(new File(inputDir, file));
            for (String enitytType : XMLReader.getEntityTypes(document).values()) {
                if (Mapper.getEntityTypeId((String)enitytType) == 0) continue;
                ++totalEntityCount;
                if (entityCounts.containsKey(enitytType)) {
                    entityCounts.put(enitytType, entityCounts.get(enitytType) + 1);
                    continue;
                }
                entityCounts.put(enitytType, 1);
            }
        }
        System.out.println(inputDir);
        Stats.reportStats(entityCounts, totalEntityCount);
    }

    public static void getRelationStats(String inputDir) throws JDOMException, IOException {
        File dir = new File(inputDir);
        HashMap<String, Integer> relationCounts = new HashMap<String, Integer>();
        int totalRelationCount = 0;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File fileDir, String name) {
                return name.endsWith(".xml");
            }
        };
        for (String file : dir.list(filter)) {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(new File(inputDir, file));
            for (RelationInfo relationInfo : XMLReader.getRelations(document)) {
                if (!Constants.sharpRelationsSelected.contains(relationInfo.category)) continue;
                ++totalRelationCount;
                if (relationCounts.containsKey(relationInfo.category)) {
                    relationCounts.put(relationInfo.category, relationCounts.get(relationInfo.category) + 1);
                    continue;
                }
                relationCounts.put(relationInfo.category, 1);
            }
        }
        System.out.println(inputDir);
        Stats.reportStats(relationCounts, totalRelationCount);
    }

    public static void reportStats(HashMap<String, Integer> counts, int totalCount) {
        for (String key : counts.keySet()) {
            System.out.format("%-25s %5d (%.2f%%)\n", key, counts.get(key), (double)counts.get(key).intValue() * 100.0 / (double)totalCount);
        }
        System.out.format("\n%-25s %5d (%d%%)\n\n", "total", totalCount, 100);
    }

    public static void main(String[] args) throws JDOMException, IOException {
        Stats.getEntityStats("/home/dima/sharp/cloud/sharp/xml/train/");
        Stats.getRelationStats("/home/dima/sharp/cloud/sharp/xml/train/");
    }
}

